/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class NewZealand
extends DelegateCalendar {
    private static final NewZealand NZX_CALENDAR = new NewZealand(Market.NZX);

    private NewZealand(Market market) {
        NewZealandNZXCalendar delegate;
        switch (market) {
            case NZX: {
                delegate = new NewZealandNZXCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static NewZealand getCalendar(Market market) {
        switch (market) {
            case NZX: {
                return NZX_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class NewZealandNZXCalendar
    extends WesternCalendar {
        private NewZealandNZXCalendar() {
        }

        @Override
        public String getName() {
            return "OsloBors";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 3 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.JANUARY || (d == 2 || d == 4 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.JANUARY || d >= 19 && d <= 25 && w == Weekday.MONDAY && m == Month.JANUARY || d == 6 && m == Month.FEBRUARY || dd == em - 3 || dd == em || d == 25 && m == Month.APRIL || d <= 7 && w == Weekday.MONDAY && m == Month.JUNE || d >= 22 && d <= 28 && w == Weekday.MONDAY && m == Month.OCTOBER || (d == 25 || d == 27 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER) && (d != 26 && (d != 28 || w != Weekday.MONDAY && w != Weekday.TUESDAY) || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        NZX;

    }
}

