/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;

class StateWriter {
    private Map objectTable = new HashMap();
    private ArrayList forcedWrite = new ArrayList();

    StateWriter() {
    }

    private int addToObjectTable(Object object) {
        Integer cur = (Integer)this.objectTable.get(object);
        if (cur != null) {
            return cur;
        }
        this.objectTable.put(object, new Integer(this.objectTable.size()));
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Object objectResult;
        if (this.objectTable != null && (objectResult = this.objectTable.get(object)) != null) {
            return (Integer)objectResult;
        }
        return -1;
    }

    private boolean writePrefix(Object object, DataOutputStream out) throws IOException {
        if (this.writeIndex(object, out)) {
            return true;
        }
        int index = this.addToObjectTable(object);
        out.writeByte(1);
        out.writeInt(index);
        return false;
    }

    private void writeStateDeprecated(StateImpl state, DataOutputStream out) throws IOException {
        out.write(30);
        if (this.writePrefix(state, out)) {
            return;
        }
        out.writeLong(state.getTimeStamp());
        String[] platformPropKeys = state.getPlatformPropertyKeys();
        this.writePlatformProp(platformPropKeys, out);
        Dictionary[] propSet = state.getPlatformProperties();
        out.writeInt(propSet.length);
        int i = 0;
        while (i < propSet.length) {
            Dictionary props = propSet[i];
            out.writeInt(platformPropKeys.length);
            int j = 0;
            while (j < platformPropKeys.length) {
                this.writePlatformProp(props.get(platformPropKeys[j]), out);
                ++j;
            }
            ++i;
        }
        BundleDescription[] bundles = state.getBundles();
        StateHelperImpl.getInstance().sortBundles(bundles);
        out.writeInt(bundles.length);
        if (bundles.length == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < bundles.length) {
            this.writeBundleDescription(bundles[i2], out, false);
            ++i2;
        }
        out.writeBoolean(state.isResolved());
        out.writeInt(out.size());
        i2 = 0;
        while (i2 < bundles.length) {
            this.writeBundleDescriptionLazyData(bundles[i2], out);
            ++i2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveState(StateImpl state, File stateFile, File lazyFile) throws IOException {
        FileOutputStream fosState;
        DataOutputStream outState;
        block35: {
            FileOutputStream fosLazy;
            DataOutputStream outLazy;
            block31: {
                block29: {
                    block30: {
                        outLazy = null;
                        outState = null;
                        fosLazy = null;
                        fosState = null;
                        try {
                            BundleDescription[] bundles = state.getBundles();
                            StateHelperImpl.getInstance().sortBundles(bundles);
                            int i = 0;
                            while (true) {
                                if (i >= bundles.length) break;
                                this.addToObjectTable(bundles[i]);
                                ++i;
                            }
                            fosLazy = new FileOutputStream(lazyFile);
                            outLazy = new DataOutputStream(new BufferedOutputStream(fosLazy));
                            i = 0;
                            while (true) {
                                if (i >= bundles.length) {
                                    fosState = new FileOutputStream(stateFile);
                                    outState = new DataOutputStream(new BufferedOutputStream(fosState));
                                    outState.write(30);
                                    if (!this.writePrefix(state, outState)) break;
                                    Object var14_11 = null;
                                    if (outLazy == null) break block29;
                                    break block30;
                                }
                                this.writeBundleDescriptionLazyData(bundles[i], outLazy);
                                ++i;
                            }
                            outState.writeLong(state.getTimeStamp());
                            String[] platformPropKeys = state.getPlatformPropertyKeys();
                            this.writePlatformProp(platformPropKeys, outState);
                            Dictionary[] propSet = state.getPlatformProperties();
                            outState.writeInt(propSet.length);
                            int i2 = 0;
                            block21: while (true) {
                                if (i2 >= propSet.length) break;
                                Dictionary props = propSet[i2];
                                outState.writeInt(platformPropKeys.length);
                                int j = 0;
                                while (true) {
                                    if (j >= platformPropKeys.length) {
                                        ++i2;
                                        continue block21;
                                    }
                                    this.writePlatformProp(props.get(platformPropKeys[j]), outState);
                                    ++j;
                                }
                                break;
                            }
                            outState.writeInt(bundles.length);
                            i2 = 0;
                            while (true) {
                                if (i2 >= bundles.length) break;
                                this.writeBundleDescription(bundles[i2], outState, true);
                                ++i2;
                            }
                            DisabledInfo[] infos = state.getDisabledInfos();
                            outState.writeInt(infos.length);
                            int i3 = 0;
                            while (true) {
                                if (i3 >= infos.length) {
                                    outState.writeBoolean(state.isResolved());
                                    break block31;
                                }
                                this.writeDisabledInfo(infos[i3], outState);
                                ++i3;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_12 = null;
                            if (outLazy != null) {
                                try {
                                    outLazy.flush();
                                    fosLazy.getFD().sync();
                                }
                                catch (IOException iOException) {}
                                try {
                                    outLazy.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (outState == null) throw throwable;
                            try {
                                outState.flush();
                                fosState.getFD().sync();
                            }
                            catch (IOException iOException) {}
                            try {
                                outState.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException iOException) {}
                    outLazy.flush();
                    fosLazy.getFD().sync();
                    try {}
                    catch (IOException iOException) {}
                    outLazy.close();
                }
                if (outState == null) return;
                try {}
                catch (IOException iOException) {}
                outState.flush();
                fosState.getFD().sync();
                try {}
                catch (IOException iOException) {}
                outState.close();
                return;
            }
            Object var14_13 = null;
            if (outLazy == null) break block35;
            try {}
            catch (IOException iOException) {}
            outLazy.flush();
            fosLazy.getFD().sync();
            try {}
            catch (IOException iOException) {}
            outLazy.close();
        }
        if (outState == null) return;
        try {}
        catch (IOException iOException) {}
        outState.flush();
        fosState.getFD().sync();
        try {}
        catch (IOException iOException) {
            return;
        }
        outState.close();
    }

    private void writePlatformProp(Object obj, DataOutputStream out) throws IOException {
        if (!(obj instanceof String) && !(obj instanceof String[])) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            if (obj instanceof String) {
                out.writeInt(1);
                this.writeStringOrNull((String)obj, out);
            } else {
                String[] props = (String[])obj;
                out.writeInt(props.length);
                int i = 0;
                while (i < props.length) {
                    this.writeStringOrNull(props[i], out);
                    ++i;
                }
            }
        }
    }

    private void writeBundleDescription(BundleDescription bundle, DataOutputStream out, boolean force) throws IOException {
        if (force && !this.forcedWrite.contains(bundle)) {
            int index = this.addToObjectTable(bundle);
            out.writeByte(1);
            out.writeInt(index);
            this.forcedWrite.add(bundle);
        } else if (this.writePrefix(bundle, out)) {
            return;
        }
        out.writeLong(bundle.getBundleId());
        this.writeBaseDescription(bundle, out);
        out.writeInt(((BundleDescriptionImpl)bundle).getLazyDataOffset());
        out.writeInt(((BundleDescriptionImpl)bundle).getLazyDataSize());
        out.writeBoolean(bundle.isResolved());
        out.writeBoolean(bundle.isSingleton());
        out.writeBoolean(bundle.hasDynamicImports());
        out.writeBoolean(bundle.attachFragments());
        out.writeBoolean(bundle.dynamicFragments());
        this.writeHostSpec((HostSpecificationImpl)bundle.getHost(), out, force);
        List dependencies = ((BundleDescriptionImpl)bundle).getBundleDependencies();
        out.writeInt(dependencies.size());
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            this.writeBundleDescription((BundleDescription)iter.next(), out, force);
        }
    }

    private void writeBundleDescriptionLazyData(BundleDescription bundle, DataOutputStream out) throws IOException {
        int dataStart = out.size();
        int index = this.getFromObjectTable(bundle);
        ((BundleDescriptionImpl)bundle).setLazyDataOffset(out.size());
        out.writeInt(index);
        this.writeStringOrNull(bundle.getLocation(), out);
        this.writeStringOrNull(bundle.getPlatformFilter(), out);
        ExportPackageDescription[] exports = bundle.getExportPackages();
        out.writeInt(exports.length);
        int i = 0;
        while (i < exports.length) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)exports[i], out);
            ++i;
        }
        ImportPackageSpecification[] imports = bundle.getImportPackages();
        out.writeInt(imports.length);
        int i2 = 0;
        while (i2 < imports.length) {
            this.writeImportPackageSpec(imports[i2], out);
            ++i2;
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        out.writeInt(requiredBundles.length);
        int i3 = 0;
        while (i3 < requiredBundles.length) {
            this.writeBundleSpec((BundleSpecificationImpl)requiredBundles[i3], out);
            ++i3;
        }
        ExportPackageDescription[] selectedExports = bundle.getSelectedExports();
        if (selectedExports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(selectedExports.length);
            int i4 = 0;
            while (i4 < selectedExports.length) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)selectedExports[i4], out);
                ++i4;
            }
        }
        ExportPackageDescription[] substitutedExports = bundle.getSubstitutedExports();
        if (substitutedExports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(substitutedExports.length);
            int i5 = 0;
            while (i5 < substitutedExports.length) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)substitutedExports[i5], out);
                ++i5;
            }
        }
        ExportPackageDescription[] resolvedImports = bundle.getResolvedImports();
        if (resolvedImports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedImports.length);
            int i6 = 0;
            while (i6 < resolvedImports.length) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)resolvedImports[i6], out);
                ++i6;
            }
        }
        BundleDescription[] resolvedRequires = bundle.getResolvedRequires();
        if (resolvedRequires == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedRequires.length);
            int i7 = 0;
            while (i7 < resolvedRequires.length) {
                this.writeBundleDescription(resolvedRequires[i7], out, false);
                ++i7;
            }
        }
        String[] ees = bundle.getExecutionEnvironments();
        out.writeInt(ees.length);
        int i8 = 0;
        while (i8 < ees.length) {
            this.writeStringOrNull(ees[i8], out);
            ++i8;
        }
        HashMap dynamicStamps = ((BundleDescriptionImpl)bundle).getDynamicStamps();
        if (dynamicStamps == null) {
            out.writeInt(0);
        } else {
            out.writeInt(dynamicStamps.size());
            Iterator pkgs = dynamicStamps.keySet().iterator();
            while (pkgs.hasNext()) {
                String pkg = (String)pkgs.next();
                this.writeStringOrNull(pkg, out);
                out.writeLong((Long)dynamicStamps.get(pkg));
            }
        }
        GenericDescription[] genericCapabilities = bundle.getGenericCapabilities();
        if (genericCapabilities == null) {
            out.writeInt(0);
        } else {
            out.writeInt(genericCapabilities.length);
            int i9 = 0;
            while (i9 < genericCapabilities.length) {
                this.writeGenericDescription(genericCapabilities[i9], out);
                ++i9;
            }
        }
        GenericSpecification[] genericRequires = bundle.getGenericRequires();
        if (genericRequires == null) {
            out.writeInt(0);
        } else {
            out.writeInt(genericRequires.length);
            int i10 = 0;
            while (i10 < genericRequires.length) {
                this.writeGenericSpecification(genericRequires[i10], out);
                ++i10;
            }
        }
        this.writeNativeCode(bundle.getNativeCodeSpecification(), out);
        ((BundleDescriptionImpl)bundle).setLazyDataSize(out.size() - dataStart);
    }

    private void writeDisabledInfo(DisabledInfo disabledInfo, DataOutputStream out) throws IOException {
        this.writeStringOrNull(disabledInfo.getPolicyName(), out);
        this.writeStringOrNull(disabledInfo.getMessage(), out);
        this.writeBundleDescription(disabledInfo.getBundle(), out, false);
    }

    private void writeBundleSpec(BundleSpecificationImpl bundle, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(bundle, out);
        this.writeBundleDescription((BundleDescription)bundle.getSupplier(), out, false);
        out.writeBoolean(bundle.isExported());
        out.writeBoolean(bundle.isOptional());
    }

    private void writeExportPackageDesc(ExportPackageDescriptionImpl exportPackageDesc, DataOutputStream out) throws IOException {
        if (this.writePrefix(exportPackageDesc, out)) {
            return;
        }
        this.writeBaseDescription(exportPackageDesc, out);
        this.writeBundleDescription(exportPackageDesc.getExporter(), out, false);
        this.writeMap(out, exportPackageDesc.getAttributes());
        this.writeMap(out, exportPackageDesc.getDirectives());
    }

    private void writeGenericDescription(GenericDescription description, DataOutputStream out) throws IOException {
        if (this.writePrefix(description, out)) {
            return;
        }
        this.writeBaseDescription(description, out);
        this.writeBundleDescription(description.getSupplier(), out, false);
        this.writeStringOrNull(description.getType() == "generic" ? null : description.getType(), out);
        Dictionary attrs = description.getAttributes();
        HashMap mapAttrs = new HashMap(attrs.size());
        Enumeration keys = attrs.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if ("version".equals(key)) continue;
            mapAttrs.put(key, attrs.get(key));
        }
        this.writeMap(out, mapAttrs);
    }

    private void writeGenericSpecification(GenericSpecification specification, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(specification, out);
        this.writeStringOrNull(specification.getType() == "generic" ? null : specification.getType(), out);
        GenericDescription[] suppliers = specification.getSuppliers();
        out.writeInt(suppliers == null ? 0 : suppliers.length);
        if (suppliers != null) {
            int i = 0;
            while (i < suppliers.length) {
                this.writeGenericDescription(suppliers[i], out);
                ++i;
            }
        }
        out.writeInt(specification.getResolution());
        this.writeStringOrNull(specification.getMatchingFilter(), out);
    }

    private void writeNativeCode(NativeCodeSpecification nativeCodeSpecification, DataOutputStream out) throws IOException {
        if (nativeCodeSpecification == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        out.writeBoolean(nativeCodeSpecification.isOptional());
        NativeCodeDescription[] nativeDescs = nativeCodeSpecification.getPossibleSuppliers();
        int numDescs = nativeDescs == null ? 0 : nativeDescs.length;
        out.writeInt(numDescs);
        int supplierIndex = -1;
        int i = 0;
        while (i < numDescs) {
            if (nativeDescs[i] == nativeCodeSpecification.getSupplier()) {
                supplierIndex = i;
            }
            this.writeNativeCodeDescription(nativeDescs[i], out);
            ++i;
        }
        out.writeInt(supplierIndex);
    }

    private void writeNativeCodeDescription(NativeCodeDescription nativeCodeDescription, DataOutputStream out) throws IOException {
        this.writeBaseDescription(nativeCodeDescription, out);
        this.writeBundleDescription(nativeCodeDescription.getSupplier(), out, false);
        Filter filter = nativeCodeDescription.getFilter();
        this.writeStringOrNull(filter == null ? null : filter.toString(), out);
        this.writeStringArray(nativeCodeDescription.getLanguages(), out);
        this.writeStringArray(nativeCodeDescription.getNativePaths(), out);
        this.writeStringArray(nativeCodeDescription.getOSNames(), out);
        this.writeVersionRanges(nativeCodeDescription.getOSVersions(), out);
        this.writeStringArray(nativeCodeDescription.getProcessors(), out);
        out.writeBoolean(nativeCodeDescription.hasInvalidNativePaths());
    }

    private void writeVersionRanges(VersionRange[] ranges, DataOutputStream out) throws IOException {
        out.writeInt(ranges == null ? 0 : ranges.length);
        if (ranges == null) {
            return;
        }
        int i = 0;
        while (i < ranges.length) {
            this.writeVersionRange(ranges[i], out);
            ++i;
        }
    }

    private void writeStringArray(String[] strings, DataOutputStream out) throws IOException {
        out.writeInt(strings == null ? 0 : strings.length);
        if (strings == null) {
            return;
        }
        int i = 0;
        while (i < strings.length) {
            this.writeStringOrNull(strings[i], out);
            ++i;
        }
    }

    private void writeMap(DataOutputStream out, Map source) throws IOException {
        if (source == null) {
            out.writeInt(0);
        } else {
            out.writeInt(source.size());
            Iterator iter = source.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = source.get(key);
                this.writeStringOrNull(key, out);
                if (value instanceof String) {
                    out.writeByte(0);
                    this.writeStringOrNull((String)value, out);
                    continue;
                }
                if (value instanceof String[]) {
                    out.writeByte(1);
                    this.writeList(out, (String[])value);
                    continue;
                }
                if (value instanceof Boolean) {
                    out.writeByte(2);
                    out.writeBoolean((Boolean)value);
                    continue;
                }
                if (value instanceof Integer) {
                    out.writeByte(3);
                    out.writeInt((Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    out.writeByte(4);
                    out.writeLong((Long)value);
                    continue;
                }
                if (value instanceof Double) {
                    out.writeByte(5);
                    out.writeDouble((Double)value);
                    continue;
                }
                if (value instanceof Version) {
                    out.writeByte(6);
                    this.writeVersion((Version)value, out);
                    continue;
                }
                if (!"java.net.URI".equals(value.getClass().getName())) continue;
                out.writeByte(7);
                this.writeStringOrNull(value.toString(), out);
            }
        }
    }

    private void writeList(DataOutputStream out, String[] list) throws IOException {
        if (list == null) {
            out.writeInt(0);
        } else {
            out.writeInt(list.length);
            int i = 0;
            while (i < list.length) {
                this.writeStringOrNull(list[i], out);
                ++i;
            }
        }
    }

    private void writeBaseDescription(BaseDescription rootDesc, DataOutputStream out) throws IOException {
        this.writeStringOrNull(rootDesc.getName(), out);
        this.writeVersion(rootDesc.getVersion(), out);
    }

    private void writeImportPackageSpec(ImportPackageSpecification importPackageSpec, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(importPackageSpec, out);
        if (importPackageSpec.getBundle().isResolved()) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)importPackageSpec.getSupplier(), out);
        } else {
            out.writeByte(0);
        }
        this.writeStringOrNull(importPackageSpec.getBundleSymbolicName(), out);
        this.writeVersionRange(importPackageSpec.getBundleVersionRange(), out);
        this.writeMap(out, importPackageSpec.getAttributes());
        this.writeMap(out, importPackageSpec.getDirectives());
    }

    private void writeHostSpec(HostSpecificationImpl host, DataOutputStream out, boolean force) throws IOException {
        if (host == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        this.writeVersionConstraint(host, out);
        BundleDescription[] hosts = host.getHosts();
        if (hosts == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(hosts.length);
        int i = 0;
        while (i < hosts.length) {
            this.writeBundleDescription(hosts[i], out, force);
            ++i;
        }
    }

    private void writeVersionConstraint(VersionConstraint constraint, DataOutputStream out) throws IOException {
        this.writeStringOrNull(constraint.getName(), out);
        this.writeVersionRange(constraint.getVersionRange(), out);
    }

    private void writeVersion(Version version, DataOutputStream out) throws IOException {
        if (version == null || version.equals(Version.emptyVersion)) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        out.writeInt(version.getMajor());
        out.writeInt(version.getMinor());
        out.writeInt(version.getMicro());
        this.writeQualifier(version.getQualifier(), out);
    }

    private void writeVersionRange(VersionRange versionRange, DataOutputStream out) throws IOException {
        if (versionRange == null || versionRange.equals(VersionRange.emptyRange)) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        this.writeVersion(versionRange.getMinimum(), out);
        out.writeBoolean(versionRange.getIncludeMinimum());
        this.writeVersion(versionRange.getMaximum(), out);
        out.writeBoolean(versionRange.getIncludeMaximum());
    }

    private boolean writeIndex(Object object, DataOutputStream out) throws IOException {
        if (object == null) {
            out.writeByte(0);
            return true;
        }
        int index = this.getFromObjectTable(object);
        if (index == -1) {
            return false;
        }
        out.writeByte(2);
        out.writeInt(index);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveStateDeprecated(StateImpl state, DataOutputStream output) throws IOException {
        try {
            this.writeStateDeprecated(state, output);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            output.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        output.close();
    }

    private void writeStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    private void writeQualifier(String string, DataOutputStream out) throws IOException {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.writeStringOrNull(string, out);
    }
}

