/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import org.osgi.framework.PackagePermission;

final class PackagePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -3350758995234427603L;
    private final HashMap permissions = new HashMap();
    private boolean all_allowed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof PackagePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        PackagePermission pp = (PackagePermission)permission;
        String name = pp.getName();
        int newMask = pp.getMask();
        PackagePermissionCollection packagePermissionCollection = this;
        synchronized (packagePermissionCollection) {
            PackagePermission existing = (PackagePermission)this.permissions.get(name);
            if (existing != null) {
                int oldMask = existing.getMask();
                if (oldMask != newMask) {
                    this.permissions.put(name, new PackagePermission(name, oldMask | newMask));
                }
            } else {
                this.permissions.put(name, permission);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        int last;
        PackagePermission x;
        if (!(permission instanceof PackagePermission)) {
            return false;
        }
        PackagePermission pp = (PackagePermission)permission;
        String name = pp.getName();
        int desired = pp.getMask();
        int effective = 0;
        PackagePermissionCollection packagePermissionCollection = this;
        synchronized (packagePermissionCollection) {
            block11: {
                if (!this.all_allowed || (x = (PackagePermission)this.permissions.get("*")) == null || ((effective |= x.getMask()) & desired) != desired) break block11;
                return true;
            }
            x = (PackagePermission)this.permissions.get(name);
        }
        if (x != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        int offset = name.length() - 1;
        while ((last = name.lastIndexOf(".", offset)) != -1) {
            name = String.valueOf(name.substring(0, last + 1)) + "*";
            PackagePermissionCollection packagePermissionCollection2 = this;
            synchronized (packagePermissionCollection2) {
                x = (PackagePermission)this.permissions.get(name);
            }
            if (x != null && ((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
            offset = last - 1;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        return Collections.enumeration(this.permissions.values());
    }
}

