/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.TypedVisitable;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public abstract class LocalVolTermStructure
extends TermStructure
implements TypedVisitable<TermStructure> {
    public LocalVolTermStructure() {
        this(Actual365Fixed.getDayCounter());
    }

    public LocalVolTermStructure(DayCounter dc) {
        super(dc);
    }

    public LocalVolTermStructure(Date referenceDate) {
        this(referenceDate, (Calendar)new NullCalendar());
    }

    public LocalVolTermStructure(Date referenceDate, Calendar cal) {
        this(referenceDate, cal, (DayCounter)Actual365Fixed.getDayCounter());
    }

    public LocalVolTermStructure(Date referenceDate, Calendar cal, DayCounter dc) {
        super(referenceDate, cal, dc);
    }

    public LocalVolTermStructure(int settlementDays) {
        this(settlementDays, (Calendar)new NullCalendar());
    }

    public LocalVolTermStructure(int settlementDays, Calendar cal) {
        this(settlementDays, cal, (DayCounter)Actual365Fixed.getDayCounter());
    }

    public LocalVolTermStructure(int settlementDays, Calendar cal, DayCounter dc) {
        super(settlementDays, cal, dc);
    }

    public final double localVol(Date d, double underlyingLevel, boolean extrapolate) {
        double t = this.timeFromReference(d);
        this.checkRange(t, underlyingLevel, extrapolate);
        return this.localVolImpl(t, underlyingLevel);
    }

    public final double localVol(double t, double underlyingLevel) {
        return this.localVol(t, underlyingLevel, false);
    }

    public final double localVol(double t, double underlyingLevel, boolean extrapolate) {
        this.checkRange(t, underlyingLevel, extrapolate);
        return this.localVolImpl(t, underlyingLevel);
    }

    public abstract double minStrike();

    public abstract double maxStrike();

    protected abstract double localVolImpl(double var1, double var3);

    private final void checkRange(double t, double strike, boolean extrapolate) {
        super.checkRange(t, extrapolate);
        double minStrike = this.minStrike();
        double maxStrike = this.maxStrike();
        if (!(extrapolate || this.allowsExtrapolation() || strike >= minStrike && strike <= maxStrike)) {
            throw new ArithmeticException("strike (" + strike + ") is outside the curve domain [" + minStrike + "," + maxStrike + "]");
        }
    }

    @Override
    public void accept(TypedVisitor<TermStructure> v) {
        Visitor<TermStructure> v1;
        Visitor<TermStructure> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 == null) {
            throw new UnsupportedOperationException("not a local-volatility term structure visitor");
        }
        v1.visit(this);
    }
}

