/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Iceland
extends DelegateCalendar {
    private static final Iceland ICEX_CALENDAR = new Iceland(Market.ICEX);

    private Iceland(Market market) {
        IcelandICEXCalendar delegate;
        switch (market) {
            case ICEX: {
                delegate = new IcelandICEXCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Iceland getCalendar(Market market) {
        switch (market) {
            case ICEX: {
                return ICEX_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class IcelandICEXCalendar
    extends WesternCalendar {
        private IcelandICEXCalendar() {
        }

        @Override
        public String getName() {
            return "ICEX";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            int m = date.getMonth();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.MONDAY) && m == Month.JANUARY.toInteger() || dd == em - 4 || dd == em - 3 || dd == em || d >= 19 && d <= 25 && w == Weekday.THURSDAY && m == Month.APRIL.toInteger() || dd == em + 38 || dd == em + 49 || d == 1 && m == Month.MAY.toInteger() || d == 17 && m == Month.JUNE.toInteger() || d <= 7 && w == Weekday.MONDAY && m == Month.AUGUST.toInteger() || d == 25 && m == Month.DECEMBER.toInteger()) && (d != 26 || m != Month.DECEMBER.toInteger());
        }
    }

    public static enum Market {
        ICEX;

    }
}

