/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolatilityTermStructure;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public class BlackConstantVol
extends BlackVolatilityTermStructure {
    private Handle<? extends Quote> volatility;
    private DayCounter dayCounter;

    @Override
    protected final double blackVolImpl(double maturity, double strike) {
        return this.volatility.getLink().evaluate();
    }

    public BlackConstantVol(Date referenceDate, double volatility, DayCounter dayCounter) {
        super(referenceDate);
        this.volatility = new Handle<SimpleQuote>(new SimpleQuote(volatility));
        this.dayCounter = dayCounter;
    }

    public BlackConstantVol(Date referenceDate, Handle<? extends Quote> volatility, DayCounter dayCounter) {
        super(referenceDate);
        this.volatility = volatility;
        this.dayCounter = dayCounter;
        volatility.addObserver(this);
    }

    public BlackConstantVol(int settlementDays, Calendar calendar, double volatility, DayCounter dayCounter) {
        super(settlementDays, calendar);
        this.volatility = new Handle<SimpleQuote>(new SimpleQuote(volatility));
        this.dayCounter = dayCounter;
    }

    public BlackConstantVol(int settlementDays, Calendar calendar, Handle<? extends Quote> volatility, DayCounter dayCounter) {
        super(settlementDays, calendar);
        this.volatility = volatility;
        this.dayCounter = dayCounter;
        volatility.addObserver(this);
    }

    public BlackConstantVol(Date referenceDate, Calendar calendar, double volatility, DayCounter dayCounter) {
        super(referenceDate, calendar);
        this.volatility = new Handle<SimpleQuote>(new SimpleQuote(volatility));
        this.dayCounter = dayCounter;
    }

    @Override
    public final DayCounter dayCounter() {
        return this.dayCounter;
    }

    @Override
    public final Date maxDate() {
        return DateFactory.getFactory().getMaxDate();
    }

    @Override
    public final double minStrike() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public final double maxStrike() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public void accept(TypedVisitor<TermStructure> v) {
        Visitor<TermStructure> v1;
        Visitor<TermStructure> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 != null) {
            v1.visit(this);
        } else {
            super.accept(v);
        }
    }
}

