/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.RelativeDateRateHelper;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Date;

public class DepositRateHelper<T extends TermStructure>
extends RelativeDateRateHelper<T> {
    private Date fixingDate;
    private IborIndex iborIndex;
    private RelinkableHandle<YieldTermStructure> termStructureHandle;

    public DepositRateHelper(Handle<Quote> rate, Period tenor, int fixingDays, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        super(rate, null, null, null);
        throw new UnsupportedOperationException("not implemented yet");
    }

    public DepositRateHelper(double rate, Period tenor, int fixingDays, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        super(rate);
        this.iborIndex = new IborIndex("no-fix", tenor, fixingDays, calendar, null, convention, endOfMonth, dayCounter, this.termStructureHandle);
        this.initializeDates();
    }

    public DepositRateHelper(Handle<Quote> rate, IborIndex ibor) {
        super(rate, null, null, null);
        this.iborIndex = new IborIndex("no-fix", ibor.getTenor(), ibor.getFixingDays(), ibor.getFixingCalendar(), null, ibor.getConvention(), ibor.isEndOfMonth(), ibor.getDayCounter(), this.termStructureHandle);
        this.initializeDates();
    }

    public DepositRateHelper(double rate, IborIndex ibor) {
        super(rate);
        this.iborIndex = new IborIndex("no-fix", ibor.getTenor(), ibor.getFixingDays(), ibor.getFixingCalendar(), null, ibor.getConvention(), ibor.isEndOfMonth(), ibor.getDayCounter(), this.termStructureHandle);
    }

    @Override
    protected void initializeDates() {
        this.earliestDate = this.iborIndex.getFixingCalendar().advance(this.evaluationDate, this.iborIndex.getFixingDays(), TimeUnit.DAYS);
        this.latestDate = this.iborIndex.maturityDate(this.earliestDate);
        this.fixingDate = this.iborIndex.fixingDate(this.earliestDate);
    }

    @Override
    public double getImpliedQuote() {
        if (this.termStructure == null) {
            throw new IllegalStateException("term structure not set");
        }
        return this.iborIndex.fixing(this.fixingDate, true);
    }

    public void setTermStructureHandle(YieldTermStructure term) {
        this.termStructureHandle.setLink(term);
    }
}

