/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jcip.annotations.NotThreadSafe;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultObservable
implements Observable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultObservable.class);
    private final List<Observer> observers = new CopyOnWriteArrayList<Observer>();
    private final Observable observable;

    public DefaultObservable(Observable observable) {
        if (observable == null) {
            throw new NullPointerException("observable is null");
        }
        this.observable = observable;
    }

    @Override
    public void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException("observer is null");
        }
        this.observers.add(observer);
    }

    @Override
    public int countObservers() {
        return this.observers.size();
    }

    @Override
    public List<Observer> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.observers.remove(observer);
    }

    @Override
    public void deleteObservers() {
        this.observers.clear();
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(null);
    }

    @Override
    public void notifyObservers(Object arg) {
        for (Observer observer : this.observers) {
            this.wrappedNotify(observer, this.observable, arg);
        }
    }

    protected void wrappedNotify(Observer observer, Observable observable, Object arg) {
        observer.update(observable, arg);
    }
}

