/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator;

import java.util.ArrayList;
import java.util.List;

public class QuotedTokenizer {
    String m_string;
    int m_index = 0;
    String m_separators;
    boolean m_returnTokens;
    boolean m_ignoreWhiteSpace = true;
    String m_peek;
    char m_separator;

    public QuotedTokenizer(String string, String separators, boolean returnTokens) {
        if (string == null) {
            throw new IllegalArgumentException("string argument must be not null");
        }
        this.m_string = string;
        this.m_separators = separators;
        this.m_returnTokens = returnTokens;
    }

    public QuotedTokenizer(String string, String separators) {
        this(string, separators, false);
    }

    public String nextToken(String separators) {
        String result;
        this.m_separator = '\u0000';
        if (this.m_peek != null) {
            String tmp = this.m_peek;
            this.m_peek = null;
            return tmp;
        }
        if (this.m_index == this.m_string.length()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        block3: while (this.m_index < this.m_string.length()) {
            char c;
            if (Character.isWhitespace(c = this.m_string.charAt(this.m_index++))) {
                if (this.m_index != this.m_string.length()) continue;
                break;
            }
            if (separators.indexOf(c) >= 0) {
                if (this.m_returnTokens) {
                    this.m_peek = Character.toString(c);
                    break;
                }
                this.m_separator = c;
                break;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    this.quotedString(sb, c);
                    continue block3;
                }
            }
            sb.append(c);
        }
        if ((result = sb.toString().trim()).length() == 0 && this.m_index == this.m_string.length()) {
            return null;
        }
        return result;
    }

    public String nextToken() {
        return this.nextToken(this.m_separators);
    }

    private void quotedString(StringBuffer sb, char c) {
        char quote = c;
        while (this.m_index < this.m_string.length() && (c = this.m_string.charAt(this.m_index++)) != quote) {
            if (c == '\\' && this.m_index < this.m_string.length() && this.m_string.charAt(this.m_index + 1) == quote) {
                c = this.m_string.charAt(this.m_index++);
            }
            sb.append(c);
        }
    }

    public String[] getTokens() {
        return this.getTokens(0);
    }

    private String[] getTokens(int cnt) {
        String token = this.nextToken();
        if (token == null) {
            return new String[cnt];
        }
        String[] result = this.getTokens(cnt + 1);
        result[cnt] = token;
        return result;
    }

    public char getSeparator() {
        return this.m_separator;
    }

    public List getTokenSet() {
        ArrayList<String> list = new ArrayList<String>();
        String token = this.nextToken();
        while (token != null) {
            list.add(token);
            token = this.nextToken();
        }
        return list;
    }
}

