/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.examples.utils;

import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.math.distributions.InverseCumulativeNormal;
import org.jquantlib.math.randomnumbers.InverseCumulativeRsg;
import org.jquantlib.math.randomnumbers.MersenneTwisterUniformRng;
import org.jquantlib.math.randomnumbers.PseudoRandom;
import org.jquantlib.math.randomnumbers.RandomSequenceGenerator;
import org.jquantlib.math.statistics.Statistics;
import org.jquantlib.methods.montecarlo.MonteCarloModel;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.processes.BlackScholesMertonProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;
import org.jquantlib.termstructures.yieldcurves.FlatForward;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.calendars.Target;
import org.jquantlib.util.Date;
import org.jquantlib.util.DefaultDate;

public class ReplicationError {
    private Number maturity_;
    private PlainVanillaPayoff payoff_;
    private Number s0_;
    private Number sigma_;
    private Number r_;
    private Number vega_;

    public ReplicationError(Option.Type type, Number maturity, Number strike, Number s0, Number sigma, Number r) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.maturity_ = maturity;
        this.payoff_ = new PlainVanillaPayoff(type, strike.doubleValue());
        this.s0_ = s0;
        this.sigma_ = sigma;
        this.r_ = r;
        double rDiscount = Math.exp(-r.doubleValue() * this.maturity_.doubleValue());
        double qDiscount = 1.0;
        double forward = this.s0_.doubleValue() * qDiscount / rDiscount;
        double stdDev = Math.sqrt(this.sigma_.doubleValue() * this.sigma_.doubleValue() * this.maturity_.doubleValue());
        BlackCalculator black = new BlackCalculator(this.payoff_, forward, stdDev, rDiscount);
        System.out.println("Option value: " + black.value());
        this.vega_ = black.vega(maturity.doubleValue());
        System.out.println("Vega: " + this.vega_);
    }

    public void compute(int nTimeSteps, int nSamples) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        Target calendar = Target.getCalendar();
        Date today = DefaultDate.getTodaysDate();
        Actual365Fixed dayCount = Actual365Fixed.getDayCounter();
        Handle<SimpleQuote> stateVariable = new Handle<SimpleQuote>(new SimpleQuote(this.s0_.doubleValue()));
        Handle<YieldTermStructure> riskFreeRate = new Handle<YieldTermStructure>(new FlatForward(today, this.r_.doubleValue(), (DayCounter)dayCount));
        Handle<YieldTermStructure> dividendYield = new Handle<YieldTermStructure>(new FlatForward(today, 0.0, (DayCounter)dayCount));
        Handle<BlackVolTermStructure> volatility = new Handle<BlackVolTermStructure>(new BlackConstantVol(today, (Calendar)calendar, this.sigma_.doubleValue(), (DayCounter)dayCount));
        BlackScholesMertonProcess diffusion = new BlackScholesMertonProcess(stateVariable, dividendYield, riskFreeRate, volatility);
        InverseCumulativeRsg<RandomSequenceGenerator<MersenneTwisterUniformRng>, InverseCumulativeNormal> rsg = new PseudoRandom().makeSequenceGenerator(nTimeSteps, 0L);
        boolean brownianBridge = false;
        MonteCarloModel MCSimulation2 = new MonteCarloModel();
        MCSimulation2.addSamples(nSamples);
        Object s = MCSimulation2.sampleAccumulator();
        double PLMean = ((Statistics)s).mean();
        double PLStDev = ((Statistics)MCSimulation2.sampleAccumulator()).standardDeviation();
        double PLSkew = ((Statistics)MCSimulation2.sampleAccumulator()).skewness();
        double PLKurt = ((Statistics)MCSimulation2.sampleAccumulator()).kurtosis();
        double theorStD = Math.sqrt(0.7853981633974483 / (double)nTimeSteps * this.vega_.doubleValue() * this.sigma_.doubleValue());
        StringBuffer sb = new StringBuffer();
        sb.append(nSamples).append(" | ");
        sb.append(nTimeSteps).append(" | ");
        sb.append(PLMean).append(" | ");
        sb.append(PLStDev).append(" | ");
        sb.append(theorStD).append(" | ");
        sb.append(PLSkew).append(" | ");
        sb.append(PLKurt).append(" \n");
        System.out.println(sb.toString());
    }
}

