/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.volatility;

import org.jquantlib.model.volatility.VolatilityCompositor;
import org.jquantlib.util.Date;
import org.jquantlib.util.TimeSeriesDouble;

public class Garch11
implements VolatilityCompositor {
    private double alpha;
    private double beta;
    private double gamma;
    private double v;

    public Garch11(double alpha, double beta, double v) {
        this.alpha = alpha;
        this.beta = beta;
        this.v = v;
        this.gamma = 1.0 - alpha - beta;
    }

    public Garch11(TimeSeriesDouble qs) {
        this.calibrate(qs);
    }

    @Override
    public TimeSeriesDouble calculate(TimeSeriesDouble vs) {
        return this.calculate(vs, this.alpha, this.beta, this.gamma * this.v);
    }

    @Override
    public void calibrate(TimeSeriesDouble timeSeries) {
    }

    protected double costFunction(TimeSeriesDouble vs, double alpha, double beta, double omega) {
        double retValue = 0.0;
        TimeSeriesDouble test = this.calculate(vs, alpha, beta, omega);
        double[] testValues = test.values();
        double[] quoteValues = vs.values();
        double v = 0.0;
        double u2 = 0.0;
        for (int i = 0; i < testValues.length; ++i) {
            v = testValues[i] * testValues[i];
            u2 = quoteValues[i] * quoteValues[i];
            retValue += 2.0 * Math.log(v) + u2 / (v * v);
        }
        return retValue;
    }

    private TimeSeriesDouble calculate(TimeSeriesDouble vs, double alpha, double beta, double omega) {
        Date[] dates = vs.dates();
        double[] values = vs.values();
        TimeSeriesDouble retValue = new TimeSeriesDouble();
        double zerothDayValue = values[0];
        retValue.add(dates[0], zerothDayValue);
        double u = 0.0;
        double sigma2 = zerothDayValue * zerothDayValue;
        for (int i = 1; i < dates.length; ++i) {
            u = values[i];
            sigma2 = omega * u * u + beta * sigma2;
            retValue.add(dates[i], Math.sqrt(sigma2));
        }
        return retValue;
    }
}

