/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.jet.math.Functions;
import java.util.List;
import org.jquantlib.processes.Discretization;
import org.jquantlib.processes.LinearDiscretization;
import org.jquantlib.util.Date;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public abstract class StochasticProcess
implements Observable,
Observer {
    private Discretization discretization;
    private Observable delegatedObservable = new DefaultObservable(this);

    protected StochasticProcess(LinearDiscretization discretization) {
        if (discretization == null) {
            throw new NullPointerException();
        }
        this.discretization = discretization;
    }

    public abstract int getSize();

    public int factors() {
        return this.getSize();
    }

    public abstract double[] initialValues();

    public abstract double[] drift(double var1, double[] var3);

    public abstract double[][] diffusion(double var1, double[] var3);

    public double[] expectation(double t0, double[] x0, double dt) {
        return this.apply(x0, this.discretization.driftDiscretization(this, t0, x0, dt));
    }

    public double[][] stdDeviation(double t0, double[] x0, double dt) {
        return this.discretization.diffusionDiscretization(this, t0, x0, dt);
    }

    public double[][] covariance(double t0, double[] x0, double dt) {
        return this.discretization.covarianceDiscretization(this, t0, x0, dt);
    }

    public double[] evolve(double t0, double[] x0, double dt, double[] dw) {
        DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(this.stdDeviation(t0, x0, dt));
        DoubleMatrix1D y = m.zMult((DoubleMatrix1D)new DenseDoubleMatrix1D(dw), null);
        return this.apply(this.expectation(t0, x0, dt), y.toArray());
    }

    public double[] apply(double[] x0, double[] dx) {
        DenseDoubleMatrix1D mx0 = new DenseDoubleMatrix1D(x0);
        DenseDoubleMatrix1D mdx = new DenseDoubleMatrix1D(dx);
        return mx0.assign((DoubleMatrix1D)mdx, Functions.plus).toArray();
    }

    public double getTime(Date date) {
        throw new UnsupportedOperationException("date/time conversion not supported");
    }

    @Override
    public void update(Observable o, Object arg) {
        this.notifyObservers();
    }

    @Override
    public void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }
}

