/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Bitmap;
import netscape.application.Border;
import netscape.application.CheckButtonImage;
import netscape.application.Color;
import netscape.application.DrawingSequence;
import netscape.application.DrawingSequenceOwner;
import netscape.application.Font;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.Sound;
import netscape.application.Target;
import netscape.application.Timer;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Button
extends View
implements Target,
DrawingSequenceOwner,
FormElement {
    Font _titleFont;
    Color _titleColor = Color.black;
    Color _disabledTitleColor = Color.gray;
    Color _raisedColor;
    Color _loweredColor;
    Image _image;
    Image _altImage;
    Border _raisedBorder;
    Border _loweredBorder;
    Sound _downSound;
    Sound _upSound;
    Timer _actionTimer;
    Target _target;
    String _title = "";
    String _command;
    String _altTitle = "";
    int _type;
    int _imagePosition;
    int _repeatDelay = 75;
    boolean _state;
    boolean _enabled = true;
    boolean _bordered = true;
    boolean _highlighted;
    boolean _oldState;
    boolean transparent = false;
    private int _clickCount;
    private boolean _performingAction;
    static Vector _fieldDescription;
    public static final int PUSH_TYPE = 0;
    public static final int TOGGLE_TYPE = 1;
    public static final int RADIO_TYPE = 2;
    public static final int CONTINUOUS_TYPE = 3;
    public static final int IMAGE_ON_LEFT = 0;
    public static final int IMAGE_ON_RIGHT = 1;
    public static final int IMAGE_ABOVE = 2;
    public static final int IMAGE_BELOW = 3;
    public static final int IMAGE_BENEATH = 4;
    public static final String SEND_COMMAND = "sendCommand";
    public static final String CLICK = "click";
    public static final String SELECT_NEXT_RADIO_BUTTON = "selectNextRadioButton";
    public static final String SELECT_PREVIOUS_RADIO_BUTTON = "selectPreviousRadioButton";
    static final String TITLE_KEY = "title";
    static final String ALT_TITLE_KEY = "altTitle";
    static final String TITLE_FONT_KEY = "titleFont";
    static final String TITLE_COLOR_KEY = "titleColor";
    static final String DISABLED_TITLE_COLOR_KEY = "disabledTitleColor";
    static final String RAISED_COLOR_KEY = "raisedColor";
    static final String LOWERED_COLOR_KEY = "loweredColor";
    static final String IMAGE_KEY = "image";
    static final String ALT_IMAGE_KEY = "altImage";
    static final String DOWN_SOUND_KEY = "downSound";
    static final String UP_SOUND_KEY = "upSound";
    static final String TARGET_KEY = "target";
    static final String COMMAND_KEY = "command";
    static final String TYPE_KEY = "type";
    static final String IMAGE_POSITION_KEY = "imagePosition";
    static final String REPEAT_DELAY_KEY = "repeatDelay";
    static final String STATE_KEY = "state";
    static final String ENABLED_KEY = "enabled";
    static final String BORDERED_KEY = "bordered";
    static final String TRANSPARENT_KEY = "transparent";
    static final String RAISED_BORDER_KEY = "raisedBorder";
    static final String LOWERED_BORDER_KEY = "loweredBorder";

    public static Button createPushButton(int n, int n2, int n3, int n4) {
        Button button = new Button(n, n2, n3, n4);
        button.setType(0);
        return button;
    }

    public static Button createCheckButton(int n, int n2, int n3, int n4) {
        Button button = new Button(n, n2, n3, n4);
        button.setType(1);
        button.setTransparent(true);
        button.setImage(new CheckButtonImage(false));
        button.setAltImage(new CheckButtonImage(true));
        button.setImagePosition(0);
        return button;
    }

    public static Button createRadioButton(int n, int n2, int n3, int n4) {
        Button button = new Button(n, n2, n3, n4);
        button.setType(2);
        button.setImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOff.gif"));
        button.setAltImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOn.gif"));
        button.setImagePosition(0);
        button.setTransparent(true);
        return button;
    }

    public Button() {
        this(0, 0, 0, 0);
    }

    public Button(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public Button(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this._titleFont = Font.defaultFont();
        this._raisedBorder = BezelBorder.raisedButtonBezel();
        this._loweredBorder = BezelBorder.loweredButtonBezel();
        this._raisedColor = Color.lightGray;
        this._loweredColor = Color.lightGray;
        this._setupKeyboard();
    }

    public void setTitle(String string) {
        this._title = string == null ? "" : string;
        this.draw();
    }

    public String title() {
        return this._title;
    }

    public void setAltTitle(String string) {
        this._altTitle = string == null ? "" : string;
        this.setDirty(true);
    }

    public String altTitle() {
        return this._altTitle;
    }

    public void setEnabled(boolean bl) {
        if (bl != this._enabled) {
            this._enabled = bl;
            this.setDirty(true);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    void _setState(boolean bl) {
        if (bl != this._state) {
            this._state = bl;
            this.draw();
        }
    }

    void selectNextRadioButton(boolean bl) {
        View view = this.superview();
        if (view != null) {
            View view2;
            Vector vector = view.subviews();
            int n = vector.indexOfIdentical(this);
            int n2 = vector.count();
            do {
                if (bl) {
                    if (++n == n2) {
                        n = 0;
                    }
                } else if (--n < 0) {
                    n = n2 - 1;
                }
                if (!((view2 = (View)vector.elementAt(n)) instanceof Button) || ((Button)view2).type() != 2) continue;
                ((Button)view2).setState(true);
                this.rootView().selectView(view2, true);
                return;
            } while (view2 != this);
        }
    }

    Button _otherActive() {
        if (this.superview() == null) {
            return null;
        }
        Vector vector = this.superview().peersForSubview(this);
        int n = vector.count();
        while (n-- > 0) {
            Button button;
            View view = (View)vector.elementAt(n);
            if (!(view instanceof Button) || view == this || (button = (Button)view).type() != 2 || !button.isEnabled() || !button.state()) continue;
            return button;
        }
        return null;
    }

    public void setState(boolean bl) {
        this.rootView();
        if (this._type == 2) {
            Button button;
            if (bl == this.state()) {
                return;
            }
            if (bl && (button = this._otherActive()) != null) {
                button._setState(false);
            }
        }
        this._setState(bl);
    }

    public boolean state() {
        return this._state;
    }

    public void setTarget(Target target) {
        this._target = target;
    }

    public Target target() {
        return this._target;
    }

    public void setCommand(String string) {
        this._command = string;
    }

    public String command() {
        return this._command;
    }

    public Size imageAreaSize() {
        Size size = this._image != null ? new Size(this._image.width(), this._image.height()) : new Size();
        if (this._altImage != null) {
            if (this._altImage.width() > size.width) {
                size.width = this._altImage.width();
            }
            if (this._altImage.height() > size.height) {
                size.height = this._altImage.height();
            }
        }
        return size;
    }

    Size minStringSize(String string) {
        int n;
        int n2 = string.indexOf(10);
        if (n2 == -1) {
            return this._titleFont.fontMetrics().stringSize(string);
        }
        Size size = new Size(0, this._titleFont.fontMetrics().stringHeight());
        int n3 = 1;
        String string2 = string;
        while (n2 != -1) {
            n = this._titleFont.fontMetrics().stringWidth(string2.substring(0, n2));
            if (n > size.width) {
                size.width = n;
            }
            ++n3;
            string2 = string2.substring(n2 + 1);
            n2 = string2.indexOf(10);
        }
        n = this._titleFont.fontMetrics().stringWidth(string2);
        if (n > size.width) {
            size.width = n;
        }
        size.height *= n3;
        return size;
    }

    public Size minSize() {
        boolean bl;
        Size size = null;
        Size size2 = null;
        boolean bl2 = false;
        if (this._minSize != null) {
            return new Size(this._minSize);
        }
        if (this._title != null && this._title.length() > 0) {
            size = this.minStringSize(this._title);
            bl2 = true;
        }
        if (this._altTitle != null && this._altTitle.length() > 0) {
            size2 = this.minStringSize(this._altTitle);
            bl2 = true;
        }
        if (size == null) {
            size = size2;
        } else if (size2 != null) {
            if (size.width < size2.width) {
                size.width = size2.width;
            }
            if (size.height < size2.height) {
                size.height = size2.height;
            }
        }
        if (size != null) {
            if (size.width > 0) {
                size.sizeBy(3, 0);
            }
        } else {
            size = new Size();
        }
        Size size3 = this.imageAreaSize();
        boolean bl3 = bl = size3.width > 0 || size3.height > 0;
        if (bl) {
            if (this._imagePosition == 2 || this._imagePosition == 3) {
                if (size.width < size3.width) {
                    size.width = size3.width;
                }
                size.height += size3.height + 2;
            } else if (bl2 && this._imagePosition != 4) {
                size.sizeBy(size3.width + 2, 0);
                if (size3.height > size.height) {
                    size.height = size3.height;
                }
            } else {
                if (size3.width > size.width) {
                    size.width = size3.width;
                }
                if (size3.height > size.height) {
                    size.height = size3.height;
                }
            }
        }
        if (this._bordered) {
            size.sizeBy(3, 3);
        }
        return size;
    }

    public void setFont(Font font) {
        if (font == null) {
            this._titleFont = Font.defaultFont();
            return;
        }
        this._titleFont = font;
    }

    public Font font() {
        return this._titleFont;
    }

    public void setTitleColor(Color color) {
        if (color == null) {
            this._titleColor = Color.black;
            return;
        }
        this._titleColor = color;
    }

    public Color titleColor() {
        return this._titleColor;
    }

    public void setDisabledTitleColor(Color color) {
        if (color == null) {
            this._disabledTitleColor = Color.gray;
            return;
        }
        this._disabledTitleColor = color;
    }

    public Color disabledTitleColor() {
        return this._disabledTitleColor;
    }

    public void setRaisedColor(Color color) {
        if (color == null) {
            this._raisedColor = Color.lightGray;
            return;
        }
        this._raisedColor = color;
    }

    public Color raisedColor() {
        return this._raisedColor;
    }

    public void setLoweredColor(Color color) {
        if (color == null) {
            this._loweredColor = Color.lightGray;
            return;
        }
        this._loweredColor = color;
    }

    public Color loweredColor() {
        return this._loweredColor;
    }

    public void setImage(Image image) {
        this._image = image;
        if (image instanceof DrawingSequence) {
            DrawingSequence drawingSequence = (DrawingSequence)image;
            drawingSequence.setOwner(this);
        }
    }

    public Image image() {
        return this._image;
    }

    public void setAltImage(Image image) {
        this._altImage = image;
        if (image instanceof DrawingSequence) {
            DrawingSequence drawingSequence = (DrawingSequence)image;
            drawingSequence.setOwner(this);
        }
    }

    public Image altImage() {
        return this._altImage;
    }

    public void setRaisedBorder(Border border) {
        this._raisedBorder = border;
    }

    public Border raisedBorder() {
        return this._raisedBorder;
    }

    public void setLoweredBorder(Border border) {
        this._loweredBorder = border;
    }

    public Border loweredBorder() {
        return this._loweredBorder;
    }

    public void setMouseDownSound(Sound sound) {
        this._downSound = sound;
        if (this._type == 3 && this._downSound != null) {
            this._downSound.setLoops(true);
        }
    }

    public Sound mouseDownSound() {
        return this._downSound;
    }

    public void setMouseUpSound(Sound sound) {
        this._upSound = sound;
    }

    public Sound mouseUpSound() {
        return this._upSound;
    }

    public void setBordered(boolean bl) {
        this._bordered = bl;
        if (this._bordered) {
            this.setTransparent(false);
        }
    }

    public boolean isBordered() {
        return this._bordered;
    }

    public void setType(int n) {
        if (n < 0 || n > 3) {
            throw new InconsistencyException("Invalid Button type: " + n);
        }
        this._type = n;
        this.setState(false);
        if (this._type == 3) {
            if (this._downSound != null) {
                this._downSound.setLoops(true);
            }
        } else if (this._downSound != null) {
            this._downSound.setLoops(false);
        }
        this._setupKeyboard();
    }

    public int type() {
        return this._type;
    }

    public void setRepeatDelay(int n) {
        if (n > 0) {
            this._repeatDelay = n;
            if (this._actionTimer != null) {
                this._actionTimer.setDelay(this._repeatDelay);
            }
        }
    }

    public int repeatDelay() {
        return this._repeatDelay;
    }

    public void setImagePosition(int n) {
        if (n < 0 || n > 4) {
            return;
        }
        this._imagePosition = n;
    }

    public int imagePosition() {
        return this._imagePosition;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        if (this.transparent) {
            this._bordered = false;
        }
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    protected void ancestorWasAddedToViewHierarchy(View view) {
        super.ancestorWasAddedToViewHierarchy(view);
        if (this._type == 2 && this._state) {
            this._state = false;
            this.setState(true);
        }
    }

    public void drawViewTitleInRect(Graphics graphics, String string, Font font, Rect rect, int n) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this._enabled) {
            graphics.setColor(this._titleColor);
        } else {
            graphics.setColor(this._disabledTitleColor);
        }
        graphics.setFont(font);
        int n2 = string.indexOf(10);
        if (n2 == -1) {
            graphics.drawStringInRect(string, rect, n);
            return;
        }
        Rect rect2 = new Rect(rect);
        rect2.height = this._titleFont.fontMetrics().stringHeight();
        String string2 = string;
        while (n2 != -1) {
            graphics.drawStringInRect(string2.substring(0, n2), rect2, n);
            rect2.y += rect2.height;
            string2 = string2.substring(n2 + 1);
            n2 = string2.indexOf(10);
        }
        graphics.drawStringInRect(string2, rect2, n);
    }

    public void drawViewInterior(Graphics graphics, String string, Image image, Rect rect) {
        int n;
        Size size = this.imageAreaSize();
        if (this._imagePosition == 0) {
            int n2;
            int n3 = string == null || string.length() == 0 ? rect.x + 1 + (rect.width - size.width - 2) / 2 : rect.x + 1;
            if (image != null) {
                image.drawAt(graphics, n3, rect.y + (rect.height - size.height) / 2);
            }
            if (size.width > 0) {
                rect.moveBy(size.width + 3, 0);
                rect.sizeBy(-(size.width + 4), 0);
                n2 = 0;
            } else {
                rect.moveBy(1, 0);
                rect.sizeBy(-2, 0);
                n2 = 1;
            }
            this.drawViewTitleInRect(graphics, string, this._titleFont, rect, n2);
            return;
        }
        if (this._imagePosition == 2) {
            if (image != null) {
                image.drawAt(graphics, rect.x + (rect.width - size.width) / 2, rect.y + 2);
            }
            int n4 = this._titleFont.fontMetrics().charHeight();
            rect.setBounds(rect.x + 1, rect.maxY() - n4 - 1, rect.width - 2, n4);
            this.drawViewTitleInRect(graphics, string, this._titleFont, rect, 1);
            return;
        }
        if (this._imagePosition == 3) {
            if (image != null) {
                image.drawAt(graphics, rect.x + (rect.width - size.width) / 2, rect.maxY() - size.height - 2);
            }
            rect.setBounds(rect.x + 1, rect.y + 1, rect.width - 2, this._titleFont.fontMetrics().charHeight());
            this.drawViewTitleInRect(graphics, string, this._titleFont, rect, 1);
            return;
        }
        if (image != null && this._imagePosition == 4) {
            image.drawAt(graphics, rect.x + (rect.width - size.width) / 2, rect.y + (rect.height - size.height) / 2);
            n = 1;
        } else if (size.width == 0) {
            rect.moveBy(2, 0);
            n = 1;
        } else {
            n = 0;
        }
        int n5 = string == null || string.length() == 0 ? rect.x + 1 + (rect.width - size.width - 2) / 2 : rect.maxX() - size.width - 1;
        if (image != null && this._imagePosition == 1) {
            image.drawAt(graphics, n5, rect.y + (rect.height - size.height) / 2);
        }
        this.drawViewTitleInRect(graphics, string, this._titleFont, rect, n);
    }

    public void drawViewBackground(Graphics graphics, Rect rect, boolean bl) {
        if (this._bordered) {
            rect.sizeBy(-3, -3);
            if (bl) {
                this._loweredBorder.drawInRect(graphics, 0, 0, this.bounds.width, this.bounds.height);
                graphics.setColor(this._loweredColor);
                graphics.fillRect(this._loweredBorder.leftMargin(), this._loweredBorder.topMargin(), this.bounds.width - this._loweredBorder.widthMargin(), this.bounds.height - this._loweredBorder.heightMargin());
                rect.moveBy(2, 2);
                return;
            }
            this._raisedBorder.drawInRect(graphics, 0, 0, this.bounds.width, this.bounds.height);
            graphics.setColor(this._raisedColor);
            graphics.fillRect(this._raisedBorder.leftMargin(), this._raisedBorder.topMargin(), this.bounds.width - this._raisedBorder.widthMargin(), this.bounds.height - this._raisedBorder.heightMargin());
            rect.moveBy(1, 1);
            return;
        }
        if (!this.isTransparent()) {
            if (bl) {
                graphics.setColor(this._loweredColor);
            } else {
                graphics.setColor(this._raisedColor);
            }
            graphics.fillRect(0, 0, this.bounds.width, this.bounds.height);
        }
    }

    public void drawView(Graphics graphics) {
        DrawingSequence drawingSequence;
        Image image = null;
        boolean bl = this._highlighted ? !this._state : this._state;
        Rect rect = Rect.newRect(0, 0, this.bounds.width, this.bounds.height);
        this.drawViewBackground(graphics, rect, bl);
        if (this._image instanceof DrawingSequence) {
            DrawingSequence drawingSequence2 = (DrawingSequence)this._image;
            if (drawingSequence2.isAnimating()) {
                image = this._image;
            } else if (this._altImage instanceof DrawingSequence) {
                image = this._altImage;
            }
        } else if (this._altImage instanceof DrawingSequence && (drawingSequence = (DrawingSequence)this._altImage).isAnimating()) {
            image = this._altImage;
        }
        if (image == null) {
            image = this._image;
            if (bl && this._altImage != null) {
                image = this._altImage;
            }
        }
        String string = bl && this._altTitle != null && this._altTitle.length() != 0 ? this._altTitle : this._title;
        if (image == null && (string == null || string.length() == 0)) {
            Rect.returnRect(rect);
            return;
        }
        this.drawViewInterior(graphics, string, image, rect);
        Rect.returnRect(rect);
    }

    Button _activeForPoint(int n, int n2) {
        if (this.superview() == null) {
            return null;
        }
        Vector vector = this.superview().peersForSubview(this);
        Point point = Point.newPoint();
        int n3 = vector.count();
        while (n3-- > 0) {
            Button button;
            View view = (View)vector.elementAt(n3);
            if (!(view instanceof Button) || view == this || (button = (Button)view).type() != 2) continue;
            this.convertToView(view, n, n2, point);
            if (!button.containsPoint(point.x, point.y)) continue;
            Point.returnPoint(point);
            return button;
        }
        Point.returnPoint(point);
        return null;
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        if (!this._enabled) {
            return false;
        }
        if (!this.containsPoint(mouseEvent.x, mouseEvent.y)) {
            return false;
        }
        if (this._type == 2) {
            Button button = this._otherActive();
            if (button != null) {
                button._setState(false);
            }
            this._oldState = this._state;
            this._state = false;
        }
        this._clickCount = mouseEvent.clickCount;
        if (this._type == 1 || this._type == 2) {
            this.setHighlighted(true);
        } else {
            this.setState(true);
        }
        if (this._downSound != null) {
            this._downSound.play();
        }
        if (this._altImage instanceof DrawingSequence) {
            DrawingSequence drawingSequence = (DrawingSequence)this._altImage;
            drawingSequence.start();
        }
        if (this._type == 3 && this._actionTimer == null) {
            this.sendCommand();
            this._actionTimer = new Timer(this, SEND_COMMAND, this._repeatDelay);
            this._actionTimer.setInitialDelay(300);
            this._actionTimer.start();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    void _buttonDown() {
        block4: {
            if (!(this._image instanceof DrawingSequence)) break block4;
            var1_1 = (DrawingSequence)this._image;
            if (!var1_1.doesLoop()) ** GOTO lbl7
            var1_1.stop();
            break block4;
lbl-1000:
            // 1 sources

            {
                var1_1.stop();
lbl7:
                // 2 sources

                ** while (var1_1.isAnimating())
            }
        }
        if (this._altImage instanceof DrawingSequence) {
            var1_1 = (DrawingSequence)this._altImage;
            var1_1.start();
        }
        if (this._type == 3 && this._upSound != null) {
            this._upSound.stop();
        }
        if (this._downSound != null) {
            this._downSound.play();
        }
    }

    /*
     * Unable to fully structure code
     */
    void _buttonUp() {
        block4: {
            if (!(this._altImage instanceof DrawingSequence)) break block4;
            var1_1 = (DrawingSequence)this._altImage;
            if (!var1_1.doesLoop()) ** GOTO lbl7
            var1_1.stop();
            break block4;
lbl-1000:
            // 1 sources

            {
                var1_1.stop();
lbl7:
                // 2 sources

                ** while (var1_1.isAnimating())
            }
        }
        if (this._image instanceof DrawingSequence) {
            var1_1 = (DrawingSequence)this._image;
            var1_1.start();
        }
        if (this._type == 3 && this._downSound != null) {
            this._downSound.stop();
        }
        if (this._upSound != null) {
            this._upSound.play();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this._enabled) {
            return;
        }
        if (this._type == 2 && !this.containsPoint(mouseEvent.x, mouseEvent.y)) {
            Button button = this._activeForPoint(mouseEvent.x, mouseEvent.y);
            if (button != null) {
                this.setHighlighted(false);
                button.setHighlighted(true);
                this.rootView().setMouseView(button);
            }
            return;
        }
        if (this.containsPoint(mouseEvent.x, mouseEvent.y)) {
            if (!this._state && !this._highlighted) {
                this._buttonDown();
                if (this._type == 1 || this._type == 2) {
                    this.setHighlighted(true);
                } else {
                    this.setState(true);
                }
                if (this._type == 3) {
                    this.sendCommand();
                    this._actionTimer = new Timer(this, SEND_COMMAND, 100);
                    this._actionTimer.start();
                    return;
                }
            }
        } else if (this._state || this._highlighted) {
            this._buttonUp();
            if (this._type == 3 && this._actionTimer != null) {
                this._actionTimer.stop();
                this._actionTimer = null;
            }
            if (this._type == 1 || this._type == 2) {
                this.setHighlighted(false);
                return;
            }
            this.setState(false);
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        boolean bl;
        if (!this._enabled) {
            return;
        }
        if (this._type == 2) {
            if (this._highlighted) {
                this._highlighted = false;
                this.setState(true);
            }
            if (this._state != this._oldState) {
                this.sendCommand();
            }
            this._oldState = false;
            if (this.canBecomeSelectedView() && this.rootView() != null) {
                this.rootView().selectView(this, true);
            }
            return;
        }
        if (this._actionTimer != null) {
            this._actionTimer.stop();
            this._actionTimer = null;
        }
        if (bl = this.containsPoint(mouseEvent.x, mouseEvent.y)) {
            this._buttonUp();
        }
        if (this._type == 3) {
            this._state = false;
            if (bl) {
                this.setDirty(true);
            }
            if (this.canBecomeSelectedView() && this.rootView() != null) {
                this.rootView().selectView(this, true);
            }
            return;
        }
        if (this._type == 1) {
            if (bl) {
                this._highlighted = false;
                this._state = !this._state;
            } else {
                this._highlighted = false;
            }
            if (bl) {
                this.setDirty(true);
            }
            if (bl) {
                this.sendCommand();
            }
        } else {
            if (this._type != 3 && bl) {
                this.sendCommand();
            }
            this._state = false;
            if (bl) {
                this.setDirty(true);
            }
        }
        if (this.canBecomeSelectedView() && this.rootView() != null) {
            this.rootView().selectView(this, true);
        }
    }

    public int clickCount() {
        if (this._performingAction) {
            return this._clickCount;
        }
        return 0;
    }

    public void click() {
        if (!this._enabled) {
            return;
        }
        if (this._type == 2 && this._state) {
            return;
        }
        if (this._type == 1 || this._type == 2) {
            this.setState(!this._state);
            this.application().syncGraphics();
            this.sendCommand();
            return;
        }
        this.setState(true);
        this.application().syncGraphics();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this._clickCount = 1;
        this.sendCommand();
        this.setState(false);
    }

    public void performCommand(String string, Object object) {
        int n = this.type();
        if (SEND_COMMAND.equals(string)) {
            this.sendCommand();
            return;
        }
        if (CLICK.equals(string)) {
            this.click();
            return;
        }
        if (n == 2 && SELECT_PREVIOUS_RADIO_BUTTON.equals(string)) {
            this.selectNextRadioButton(false);
            return;
        }
        if (n == 2 && SELECT_NEXT_RADIO_BUTTON.equals(string)) {
            this.selectNextRadioButton(true);
            return;
        }
        throw new NoSuchMethodError("unknown command: " + string);
    }

    public void drawingSequenceFrameChanged(DrawingSequence drawingSequence) {
        this.setDirty(true);
    }

    public void drawingSequenceCompleted(DrawingSequence drawingSequence) {
    }

    public void sendCommand() {
        this._performingAction = true;
        if (this._target != null) {
            this._target.performCommand(this._command, this);
        }
        this._performingAction = false;
    }

    protected void setHighlighted(boolean bl) {
        if (this._highlighted != bl) {
            this._highlighted = bl;
            this.setDirty(true);
        }
    }

    protected boolean isHighlighted() {
        return this._highlighted;
    }

    public boolean canBecomeSelectedView() {
        if (this.isEnabled() && this.hasKeyboardBindings()) {
            if (this.type() == 2) {
                return this.state();
            }
            return true;
        }
        return false;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.Button", 2);
        classInfo.addField(TITLE_KEY, (byte)16);
        classInfo.addField(ALT_TITLE_KEY, (byte)16);
        classInfo.addField(TITLE_FONT_KEY, (byte)18);
        classInfo.addField(TITLE_COLOR_KEY, (byte)18);
        classInfo.addField(DISABLED_TITLE_COLOR_KEY, (byte)18);
        classInfo.addField(RAISED_COLOR_KEY, (byte)18);
        classInfo.addField(LOWERED_COLOR_KEY, (byte)18);
        classInfo.addField(IMAGE_KEY, (byte)18);
        classInfo.addField(ALT_IMAGE_KEY, (byte)18);
        classInfo.addField(DOWN_SOUND_KEY, (byte)18);
        classInfo.addField(UP_SOUND_KEY, (byte)18);
        classInfo.addField(TARGET_KEY, (byte)18);
        classInfo.addField(COMMAND_KEY, (byte)16);
        classInfo.addField(TYPE_KEY, (byte)8);
        classInfo.addField(IMAGE_POSITION_KEY, (byte)8);
        classInfo.addField(REPEAT_DELAY_KEY, (byte)8);
        classInfo.addField(STATE_KEY, (byte)0);
        classInfo.addField(ENABLED_KEY, (byte)0);
        classInfo.addField(BORDERED_KEY, (byte)0);
        classInfo.addField(TRANSPARENT_KEY, (byte)0);
        classInfo.addField(RAISED_BORDER_KEY, (byte)18);
        classInfo.addField(LOWERED_BORDER_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeString(TITLE_KEY, this._title);
        encoder.encodeString(ALT_TITLE_KEY, this._altTitle);
        encoder.encodeObject(TITLE_FONT_KEY, this._titleFont);
        encoder.encodeObject(TITLE_COLOR_KEY, this._titleColor);
        encoder.encodeObject(DISABLED_TITLE_COLOR_KEY, this._disabledTitleColor);
        encoder.encodeObject(RAISED_COLOR_KEY, this._raisedColor);
        encoder.encodeObject(LOWERED_COLOR_KEY, this._loweredColor);
        encoder.encodeObject(IMAGE_KEY, this._image);
        encoder.encodeObject(ALT_IMAGE_KEY, this._altImage);
        encoder.encodeObject(TARGET_KEY, (Codable)((Object)this._target));
        encoder.encodeString(COMMAND_KEY, this._command);
        encoder.encodeInt(TYPE_KEY, this._type);
        encoder.encodeInt(IMAGE_POSITION_KEY, this._imagePosition);
        encoder.encodeInt(REPEAT_DELAY_KEY, this._repeatDelay);
        encoder.encodeBoolean(STATE_KEY, this._state);
        encoder.encodeBoolean(ENABLED_KEY, this._enabled);
        encoder.encodeBoolean(BORDERED_KEY, this._bordered);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
        encoder.encodeObject(RAISED_BORDER_KEY, this._raisedBorder);
        encoder.encodeObject(LOWERED_BORDER_KEY, this._loweredBorder);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this._title = decoder.decodeString(TITLE_KEY);
        this._altTitle = decoder.decodeString(ALT_TITLE_KEY);
        this._titleFont = (Font)decoder.decodeObject(TITLE_FONT_KEY);
        this._titleColor = (Color)decoder.decodeObject(TITLE_COLOR_KEY);
        this._disabledTitleColor = (Color)decoder.decodeObject(DISABLED_TITLE_COLOR_KEY);
        this._raisedColor = (Color)decoder.decodeObject(RAISED_COLOR_KEY);
        this._loweredColor = (Color)decoder.decodeObject(LOWERED_COLOR_KEY);
        this._image = (Image)decoder.decodeObject(IMAGE_KEY);
        this._altImage = (Image)decoder.decodeObject(ALT_IMAGE_KEY);
        this._target = (Target)decoder.decodeObject(TARGET_KEY);
        this._command = decoder.decodeString(COMMAND_KEY);
        this._type = decoder.decodeInt(TYPE_KEY);
        this._imagePosition = decoder.decodeInt(IMAGE_POSITION_KEY);
        this._repeatDelay = decoder.decodeInt(REPEAT_DELAY_KEY);
        this._state = decoder.decodeBoolean(STATE_KEY);
        this._enabled = decoder.decodeBoolean(ENABLED_KEY);
        this._bordered = decoder.decodeBoolean(BORDERED_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
        if (decoder.versionForClassName("netscape.application.Button") > 1) {
            this._raisedBorder = (Border)decoder.decodeObject(RAISED_BORDER_KEY);
            this._loweredBorder = (Border)decoder.decodeObject(LOWERED_BORDER_KEY);
        }
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        if (this.type() == 2) {
            this.setCommandForKey(SELECT_NEXT_RADIO_BUTTON, 1007, 0);
            this.setCommandForKey(SELECT_NEXT_RADIO_BUTTON, 1005, 0);
            this.setCommandForKey(SELECT_PREVIOUS_RADIO_BUTTON, 1006, 0);
            this.setCommandForKey(SELECT_PREVIOUS_RADIO_BUTTON, 1004, 0);
            return;
        }
        this.setCommandForKey(CLICK, 10, 0);
    }

    public String formElementText() {
        if (this._type == 1) {
            if (this._state) {
                return "true";
            }
            return "false";
        }
        return this.title();
    }
}

