/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.applet.AudioClip;
import java.net.URL;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Sound
implements Codable {
    String name;
    AudioClip awtSound;
    boolean shouldLoop;
    static final String NAME_KEY = "name";

    public static synchronized Sound soundNamed(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Application application = Application.application();
        Sound sound = (Sound)application.soundByName.get(string);
        if (sound != null) {
            return sound;
        }
        URL uRL = application._appResources.urlForSoundNamed(string);
        sound = Sound.soundFromURL(uRL);
        if (sound == null) {
            System.err.println("Unknown sound: " + uRL);
            return null;
        }
        application.soundByName.put(string, sound);
        sound.name = string;
        return sound;
    }

    public static Sound soundFromURL(URL uRL) {
        AudioClip audioClip = AWTCompatibility.awtApplet().getAudioClip(uRL);
        Sound sound = new Sound();
        sound.awtSound = audioClip;
        return sound;
    }

    synchronized void nameSound(String string, Sound sound) {
        Application.application().soundByName.put(string, sound);
    }

    public String name() {
        return this.name;
    }

    public void setLoops(boolean bl) {
        this.shouldLoop = bl;
    }

    public boolean doesLoop() {
        return this.shouldLoop;
    }

    public void play() {
        if (this.awtSound != null) {
            if (this.shouldLoop) {
                this.awtSound.loop();
                return;
            }
            this.awtSound.play();
        }
    }

    public void stop() {
        if (this.awtSound != null) {
            this.awtSound.stop();
        }
    }

    public String toString() {
        if (this.name != null) {
            return "Sound(" + this.name + ")";
        }
        return super.toString();
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.Sound", 1);
        classInfo.addField(NAME_KEY, (byte)16);
    }

    public void encode(Encoder encoder) throws CodingException {
        if (this.name == null) {
            throw new CodingException("An encoded Sound must have a name");
        }
        encoder.encodeString(NAME_KEY, this.name);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.name = decoder.decodeString(NAME_KEY);
        if (this.name == null) {
            throw new CodingException("A decoded Sound must have a name");
        }
        Application application = Application.application();
        URL uRL = application._appResources.urlForSoundNamed(this.name);
        this.awtSound = application.applet.getAudioClip(uRL);
        this.nameSound(this.name, this);
    }

    public void finishDecoding() throws CodingException {
    }
}

