/*
 * Decompiled with CFR 0.152.
 */
package netscape.constructor;

import netscape.application.Application;
import netscape.application.Target;
import netscape.application.TargetChain;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.Hashtable;

public class TargetProxyManager
implements Codable {
    Hashtable targets;
    boolean neverReplace;
    boolean hasSingleTarget;
    static final String TARGETS_KEY = "targets";
    public static final String SINGLE_TARGET_PROXY_KEY = "__nEdEtCoDe";
    public static final String APPLICATION_TARGET_PROXY_KEY = "__APPLICATION__";
    public static final String TARGET_CHAIN_TARGET_PROXY_KEY = "__TARGETCHAIN__";
    public static final String NEVER_REPLACE_KEY = "__nEdEtCoDeNonReplacing";

    public Hashtable targets() {
        if (this.targets == null) {
            this.targets = new Hashtable();
        }
        return this.targets;
    }

    public void setTargets(Hashtable hashtable) {
        this.targets().clear();
        if (hashtable == null) {
            return;
        }
        this.neverReplace = hashtable.containsKey(NEVER_REPLACE_KEY);
        if (this.neverReplace) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (hashtable.get(object) instanceof Target) {
                this.targets.put(object, hashtable.get(object));
                continue;
            }
            System.out.println("TargetProxyManager: setTargets: Non-Target object found, will not be added: name = " + object + "\n, object = " + hashtable.get(object));
        }
        this.hasSingleTarget = this.targets.containsKey(SINGLE_TARGET_PROXY_KEY);
    }

    public Target targetNamed(String string) {
        if (this.targets == null || this.neverReplace) {
            return null;
        }
        if (APPLICATION_TARGET_PROXY_KEY.equals(string) && !this.targets.containsKey(APPLICATION_TARGET_PROXY_KEY)) {
            if (Application.application() instanceof Target) {
                return (Target)((Object)Application.application());
            }
            return null;
        }
        if (TARGET_CHAIN_TARGET_PROXY_KEY.equals(string) && !this.targets.containsKey(TARGET_CHAIN_TARGET_PROXY_KEY)) {
            return TargetChain.applicationChain();
        }
        if (this.hasSingleTarget) {
            return (Target)this.targets.get(SINGLE_TARGET_PROXY_KEY);
        }
        return (Target)this.targets.get(string);
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.constructor.TargetProxyManager", 1);
        classInfo.addField(TARGETS_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(TARGETS_KEY, this.targets);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.setTargets((Hashtable)decoder.decodeObject(TARGETS_KEY));
    }

    public void finishDecoding() throws CodingException {
    }
}

