/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.util.ASCIIArchiveLoader;
import netscape.util.ClassTable;
import netscape.util.CodingException;
import netscape.util.CompactInputStream;
import netscape.util.CompactOutputStream;
import netscape.util.DeserializationException;
import netscape.util.ExternalCoder;
import netscape.util.Hashtable;
import netscape.util.PrimitiveCoder;

public class Archive {
    public static final int ARCHIVE_MAGIC = 1852138529;
    static final int ARCHIVE_VERSION = 1;
    static Hashtable externalCoders;
    int version;
    int rootCount = 0;
    int[] roots = new int[4];
    int idCount = 1;
    int[] rowForId = new int[4];
    ClassTable[] tableForId = new ClassTable[4];
    Hashtable classTables = new Hashtable();
    public boolean performanceDebug = false;

    private static int[] growIntArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length * 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private static ClassTable[] growTableArray(ClassTable[] classTableArray) {
        ClassTable[] classTableArray2 = new ClassTable[classTableArray.length * 2];
        System.arraycopy(classTableArray, 0, classTableArray2, 0, classTableArray.length);
        return classTableArray2;
    }

    public void addRootIdentifier(int n) {
        if (this.rootCount >= this.roots.length) {
            this.roots = Archive.growIntArray(this.roots);
        }
        this.roots[this.rootCount] = n;
        ++this.rootCount;
    }

    public boolean removeRootIdentifier(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.rootCount) {
            if (this.roots[n2] == n) {
                bl = true;
                --this.rootCount;
                break;
            }
            ++n2;
        }
        while (n2 < this.rootCount) {
            this.roots[n2] = this.roots[n2 + 1];
            ++n2;
        }
        return bl;
    }

    public int[] rootIdentifiers() {
        int[] nArray = new int[this.rootCount];
        System.arraycopy(this.roots, 0, nArray, 0, this.rootCount);
        return nArray;
    }

    public ClassTable classTableForName(String string) {
        return (ClassTable)this.classTables.get(string);
    }

    public void addClassTable(ClassTable classTable) {
        this.classTables.put(classTable.className(), classTable);
    }

    public ClassTable classTableForIdentifier(int n) {
        if (n >= this.idCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.tableForId[n];
    }

    public int rowForIdentifier(int n) {
        if (n >= this.idCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.rowForId[n];
    }

    public int mapIdentifier(ClassTable classTable, int n) {
        if (this.idCount >= this.rowForId.length) {
            this.rowForId = Archive.growIntArray(this.rowForId);
            this.tableForId = Archive.growTableArray(this.tableForId);
        }
        int n2 = this.idCount++;
        this.rowForId[n2] = n;
        this.tableForId[n2] = classTable;
        return n2;
    }

    public int identifierCount() {
        return this.idCount;
    }

    static synchronized void setupExternalCoders() {
        if (externalCoders != null) {
            return;
        }
        externalCoders = new Hashtable(24);
        PrimitiveCoder primitiveCoder = new PrimitiveCoder(0);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(1);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(2);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(3);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(4);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(5);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(6);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(7);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(8);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(9);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(10);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(11);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(12);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(13);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(14);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(15);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(16);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
        primitiveCoder = new PrimitiveCoder(17);
        externalCoders.put(primitiveCoder.className(), primitiveCoder);
    }

    ExternalCoder externalCoderForName(String string) {
        if (externalCoders == null) {
            Archive.setupExternalCoders();
        }
        return (ExternalCoder)externalCoders.get(string);
    }

    public void read(InputStream inputStream) throws IOException {
        ClassTable classTable;
        CompactInputStream compactInputStream = inputStream instanceof CompactInputStream ? (CompactInputStream)inputStream : new CompactInputStream(inputStream);
        int n = compactInputStream.readInt();
        if (n != 1852138529) {
            throw new IOException("Bad magic number " + n);
        }
        this.version = compactInputStream.readInt();
        if (this.version != 1) {
            throw new IOException("Unknown archiveVersion " + this.version);
        }
        int n2 = compactInputStream.readCompactInt();
        ClassTable[] classTableArray = new ClassTable[n2];
        int n3 = 0;
        while (n3 < n2) {
            classTableArray[n3] = classTable = new ClassTable(this);
            classTable.readInfo(compactInputStream);
            this.addClassTable(classTable);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            classTable = classTableArray[n3];
            classTable.readData(compactInputStream);
            ++n3;
        }
        n2 = compactInputStream.readCompactInt();
        this.roots = new int[n2];
        this.rootCount = n2;
        n3 = 0;
        while (n3 < n2) {
            this.roots[n3] = compactInputStream.readCompactInt();
            ++n3;
        }
        n2 = compactInputStream.readCompactInt();
        this.rowForId = new int[n2];
        this.tableForId = new ClassTable[n2];
        this.idCount = n2;
        n3 = 1;
        while (n3 < n2) {
            this.rowForId[n3] = compactInputStream.readCompactInt();
            this.tableForId[n3] = classTableArray[compactInputStream.readCompactInt()];
            ++n3;
        }
        n2 = compactInputStream.readCompactInt();
        if (n2 > 0) {
            compactInputStream.skipBytes(n2);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        ClassTable classTable;
        CompactOutputStream compactOutputStream = outputStream instanceof CompactOutputStream ? (CompactOutputStream)outputStream : new CompactOutputStream(outputStream);
        compactOutputStream.writeInt(1852138529);
        compactOutputStream.writeInt(1);
        Object[] objectArray = this.classTables.elementsArray();
        int n = objectArray == null ? 0 : objectArray.length;
        compactOutputStream.writeCompactInt(n);
        int n2 = 0;
        while (n2 < n) {
            classTable = (ClassTable)objectArray[n2];
            classTable.tableId = n2++;
            classTable.writeInfo(compactOutputStream);
        }
        n2 = 0;
        while (n2 < n) {
            classTable = (ClassTable)objectArray[n2];
            classTable.writeData(compactOutputStream);
            ++n2;
        }
        n = this.rootCount;
        compactOutputStream.writeCompactInt(n);
        n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeCompactInt(this.roots[n2]);
            ++n2;
        }
        n = this.idCount;
        compactOutputStream.writeCompactInt(n);
        n2 = 1;
        while (n2 < n) {
            compactOutputStream.writeCompactInt(this.rowForId[n2]);
            classTable = this.tableForId[n2];
            if (classTable == null) {
                compactOutputStream.writeCompactInt(0);
            } else {
                compactOutputStream.writeCompactInt(classTable.tableId);
            }
            ++n2;
        }
        compactOutputStream.writeCompactInt(0);
        compactOutputStream.flush();
    }

    public void readASCII(InputStream inputStream) throws CodingException, DeserializationException, IOException {
        ASCIIArchiveLoader aSCIIArchiveLoader = new ASCIIArchiveLoader(this);
        aSCIIArchiveLoader.readASCII(inputStream);
    }

    public void writeASCII(OutputStream outputStream, boolean bl) throws CodingException, IOException {
        ASCIIArchiveLoader aSCIIArchiveLoader = new ASCIIArchiveLoader(this);
        aSCIIArchiveLoader.writeASCII(outputStream, bl);
    }
}

