/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.OutputStream;
import netscape.util.Archive;
import netscape.util.ArchivingStack;
import netscape.util.ClassInfo;
import netscape.util.ClassTable;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Encoder;
import netscape.util.ExternalCoder;
import netscape.util.IdHashtable;

public class Archiver
implements Encoder {
    Archive archive;
    ArchivingStack stack = new ArchivingStack();
    IdHashtable idHash = new IdHashtable(false);
    Object currentObject;
    ClassTable currentTable;
    int currentId;
    int currentColumnCount;
    int currentRow;
    int currentColumn;

    public Archiver(Archive archive) {
        this.archive = archive;
    }

    public Archive archive() {
        return this.archive;
    }

    public static void writeObject(OutputStream outputStream, Object object) throws IOException, CodingException {
        Archive archive = new Archive();
        Archiver archiver = new Archiver(archive);
        archiver.archiveRootObject(object);
        archive.write(outputStream);
    }

    public void archiveRootObject(Object object) throws CodingException {
        int n = this.identifierForObject(object);
        this.archive.addRootIdentifier(n);
    }

    private int identifierForObject(Object object) throws CodingException {
        if (object == null) {
            return 0;
        }
        int n = this.idHash.get(object);
        if (n != 0) {
            return n;
        }
        String string = object.getClass().getName();
        ExternalCoder externalCoder = this.archive.externalCoderForName(string);
        ClassTable classTable = this.archive.classTableForName(string);
        if (classTable == null) {
            ClassInfo classInfo = new ClassInfo(string);
            if (externalCoder != null) {
                externalCoder.describeClassInfo(object, classInfo);
            } else {
                ((Codable)object).describeClassInfo(classInfo);
            }
            classTable = new ClassTable(this.archive, classInfo);
            classTable.setUniqueStrings(true);
            this.archive.addClassTable(classTable);
        }
        n = classTable.newIdentifier();
        this.idHash.putKnownAbsent(object, n);
        this.pushArchivingState(object, n);
        if (externalCoder != null) {
            externalCoder.encode(object, this);
        } else {
            ((Codable)object).encode(this);
        }
        this.popArchivingState();
        return n;
    }

    private void pushArchivingState(Object object, int n) {
        this.stack.pushArchiver(this);
        this.currentObject = object;
        this.currentTable = this.archive.classTableForIdentifier(n);
        this.currentId = n;
        this.currentRow = this.archive.rowForIdentifier(n);
        this.currentColumn = -1;
        this.currentColumnCount = this.currentTable.fieldCount;
    }

    private void popArchivingState() {
        this.stack.popArchiver(this);
    }

    private void prepareToArchiveField(String string) throws CodingException {
        int n = this.currentColumnCount;
        String[] stringArray = this.currentTable.fieldNames;
        int n2 = this.currentColumn + 1;
        while (n2 < n) {
            if (string == stringArray[n2]) {
                this.currentColumn = n2;
                return;
            }
            ++n2;
        }
        this.currentColumn = this.currentTable.columnForField(string);
        if (this.currentColumn < 0) {
            throw new CodingException("Unknown field name: " + string);
        }
    }

    public void encodeBoolean(String string, boolean bl) throws CodingException {
        this.prepareToArchiveField(string);
        this.currentTable.setBooleanAt(this.currentRow, this.currentColumn, bl);
    }

    public void encodeBooleanArray(String string, boolean[] blArray, int n, int n2) throws CodingException {
        boolean[] blArray2 = null;
        this.prepareToArchiveField(string);
        if (blArray != null) {
            blArray2 = new boolean[n2];
            System.arraycopy(blArray, n, blArray2, 0, n2);
        }
        this.currentTable.setBooleanArrayAt(this.currentRow, this.currentColumn, blArray2);
    }

    public void encodeChar(String string, char c) throws CodingException {
        this.prepareToArchiveField(string);
        this.currentTable.setCharAt(this.currentRow, this.currentColumn, c);
    }

    public void encodeCharArray(String string, char[] cArray, int n, int n2) throws CodingException {
        char[] cArray2 = null;
        this.prepareToArchiveField(string);
        if (cArray != null) {
            cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
        }
        this.currentTable.setCharArrayAt(this.currentRow, this.currentColumn, cArray2);
    }

    public void encodeByte(String string, byte by) throws CodingException {
        this.prepareToArchiveField(string);
        this.currentTable.setByteAt(this.currentRow, this.currentColumn, by);
    }

    public void encodeByteArray(String string, byte[] byArray, int n, int n2) throws CodingException {
        byte[] byArray2 = null;
        this.prepareToArchiveField(string);
        if (byArray != null) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        this.currentTable.setByteArrayAt(this.currentRow, this.currentColumn, byArray2);
    }

    public void encodeShort(String string, short s) throws CodingException {
        this.prepareToArchiveField(string);
        this.currentTable.setShortAt(this.currentRow, this.currentColumn, s);
    }

    public void encodeShortArray(String string, short[] sArray, int n, int n2) throws CodingException {
        short[] sArray2 = null;
        this.prepareToArchiveField(string);
        if (sArray != null) {
            sArray2 = new short[n2];
            System.arraycopy(sArray, n, sArray2, 0, n2);
        }
        this.currentTable.setShortArrayAt(this.currentRow, this.currentColumn, sArray2);
    }

    public void encodeInt(String string, int n) throws CodingException {
        this.prepareToArchiveField(string);
        this.currentTable.setIntAt(this.currentRow, this.currentColumn, n);
    }

    public void encodeIntArray(String string, int[] nArray, int n, int n2) throws CodingException {
        int[] nArray2 = null;
        this.prepareToArchiveField(string);
        if (nArray != null) {
            nArray2 = new int[n2];
            System.arraycopy(nArray, n, nArray2, 0, n2);
        }
        this.currentTable.setIntArrayAt(this.currentRow, this.currentColumn, nArray2);
    }

    public void encodeLong(String string, long l) throws CodingException {
        this.prepareToArchiveField(string);
        this.currentTable.setLongAt(this.currentRow, this.currentColumn, l);
    }

    public void encodeLongArray(String string, long[] lArray, int n, int n2) throws CodingException {
        long[] lArray2 = null;
        this.prepareToArchiveField(string);
        if (lArray != null) {
            lArray2 = new long[n2];
            System.arraycopy(lArray, n, lArray2, 0, n2);
        }
        this.currentTable.setLongArrayAt(this.currentRow, this.currentColumn, lArray2);
    }

    public void encodeFloat(String string, float f) throws CodingException {
        this.prepareToArchiveField(string);
        this.currentTable.setFloatAt(this.currentRow, this.currentColumn, f);
    }

    public void encodeFloatArray(String string, float[] fArray, int n, int n2) throws CodingException {
        float[] fArray2 = null;
        this.prepareToArchiveField(string);
        if (fArray != null) {
            fArray2 = new float[n2];
            System.arraycopy(fArray, n, fArray2, 0, n2);
        }
        this.currentTable.setFloatArrayAt(this.currentRow, this.currentColumn, fArray2);
    }

    public void encodeDouble(String string, double d) throws CodingException {
        this.prepareToArchiveField(string);
        this.currentTable.setDoubleAt(this.currentRow, this.currentColumn, d);
    }

    public void encodeDoubleArray(String string, double[] dArray, int n, int n2) throws CodingException {
        double[] dArray2 = null;
        this.prepareToArchiveField(string);
        if (dArray != null) {
            dArray2 = new double[n2];
            System.arraycopy(dArray, n, dArray2, 0, n2);
        }
        this.currentTable.setDoubleArrayAt(this.currentRow, this.currentColumn, dArray2);
    }

    public void encodeString(String string, String string2) throws CodingException {
        this.prepareToArchiveField(string);
        this.currentTable.setStringAt(this.currentRow, this.currentColumn, string2);
    }

    public void encodeStringArray(String string, String[] stringArray, int n, int n2) throws CodingException {
        String[] stringArray2 = null;
        this.prepareToArchiveField(string);
        if (stringArray != null) {
            stringArray2 = new String[n2];
            System.arraycopy(stringArray, n, stringArray2, 0, n2);
        }
        this.currentTable.setStringArrayAt(this.currentRow, this.currentColumn, stringArray2);
    }

    public void encodeObject(String string, Object object) throws CodingException {
        this.prepareToArchiveField(string);
        this.currentTable.setIdentifierAt(this.currentRow, this.currentColumn, this.identifierForObject(object));
    }

    public void encodeObjectArray(String string, Object[] objectArray, int n, int n2) throws CodingException {
        this.prepareToArchiveField(string);
        if (objectArray == null) {
            this.currentTable.setIdentifierArrayAt(this.currentRow, this.currentColumn, null);
            return;
        }
        int[] nArray = new int[n2];
        int n3 = n;
        while (n3 < n2) {
            nArray[n3] = this.identifierForObject(objectArray[n3]);
            ++n3;
        }
        this.currentTable.setIdentifierArrayAt(this.currentRow, this.currentColumn, nArray);
    }
}

