/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.jmx;

import java.util.Date;
import java.util.List;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.integration.jmx.IoSessionManagerMBean;
import org.apache.mina.management.IoSessionStat;
import org.apache.mina.management.StatCollector;

public class IoSessionManager
implements IoSessionManagerMBean {
    private IoSession session;

    public IoSessionManager(IoSession session) {
        this.session = session;
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public long getReadBytes() {
        return this.session.getReadBytes();
    }

    public long getWrittenBytes() {
        return this.session.getWrittenBytes();
    }

    public long getReadMessages() {
        return this.session.getReadMessages();
    }

    public long getWrittenMessages() {
        return this.session.getWrittenMessages();
    }

    public void close() throws InterruptedException {
        this.session.close().join();
    }

    public Date getCreationTime() {
        return new Date(this.session.getCreationTime());
    }

    public Date getLastIoTime() {
        return new Date(this.session.getLastIoTime());
    }

    public Date getLastReadTime() {
        return new Date(this.session.getLastReadTime());
    }

    public Date getLastWriteTime() {
        return new Date(this.session.getLastWriteTime());
    }

    public String[] getInstalledFilters() {
        List filters = this.session.getFilterChain().getAll();
        String[] res = new String[filters.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = ((IoFilterChain.Entry)filters.get(i)).getName();
        }
        return res;
    }

    public void addLastLoggingFilter() {
        LoggingFilter f = new LoggingFilter();
        this.session.getFilterChain().addLast("LoggerLast", f);
    }

    public void removeLastLoggingFilter() {
        this.session.getFilterChain().remove("LoggerLast");
    }

    public void addFirstLoggingFilter() {
        LoggingFilter f = new LoggingFilter();
        this.session.getFilterChain().addFirst("LoggerFirst", f);
    }

    public void removeFirstLoggingFilter() {
        this.session.getFilterChain().remove("LoggerFirst");
    }

    public long getReadIdleTime() {
        return this.session.getIdleTimeInMillis(IdleStatus.READER_IDLE);
    }

    public long getWriteIdleTime() {
        return this.session.getIdleTimeInMillis(IdleStatus.WRITER_IDLE);
    }

    public long getBothIdleTime() {
        return this.session.getIdleTimeInMillis(IdleStatus.BOTH_IDLE);
    }

    public float getByteReadThroughtput() {
        IoSessionStat stats = (IoSessionStat)this.session.getAttribute(StatCollector.KEY);
        if (stats == null) {
            return Float.NaN;
        }
        return stats.getByteReadThroughput();
    }

    public float getByteWrittenThroughtput() {
        IoSessionStat stats = (IoSessionStat)this.session.getAttribute(StatCollector.KEY);
        if (stats == null) {
            return Float.NaN;
        }
        return stats.getByteWrittenThroughput();
    }

    public float getMessageReadThroughtput() {
        IoSessionStat stats = (IoSessionStat)this.session.getAttribute(StatCollector.KEY);
        if (stats == null) {
            return Float.NaN;
        }
        return stats.getMessageReadThroughput();
    }

    public float getMessageWrittenThroughtput() {
        IoSessionStat stats = (IoSessionStat)this.session.getAttribute(StatCollector.KEY);
        if (stats == null) {
            return Float.NaN;
        }
        return stats.getMessageWrittenThroughput();
    }
}

