/*
 * $Header: /cvs/xierpa/aQute.lib/src/aQute/bytecodes/ClassParser.java,v 1.1 2007-01-03 17:27:51 pkriens Exp $
 * 
 * Copyright (c) The OSGi Alliance (2006). All Rights Reserved.
 * 
 * Implementation of certain elements of the OSGi Specification may be subject
 * to third party intellectual property rights, including without limitation,
 * patent rights (such a third party may or may not be a member of the OSGi
 * Alliance). The OSGi Alliance is not responsible and shall not be held
 * responsible in any manner for identifying or failing to identify any or all
 * such third party intellectual property rights.
 * 
 * This document and the information contained herein are provided on an "AS IS"
 * basis and THE OSGI ALLIANCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION
 * HEREIN WILL NOT INFRINGE ANY RIGHTS AND ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL THE
 * OSGI ALLIANCE BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF BUSINESS, LOSS OF
 * USE OF DATA, INTERRUPTION OF BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR
 * EXEMPLARY, INCIDENTIAL, PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN
 * CONNECTION WITH THIS DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 * 
 * All Company, brand and product names may be trademarks that are the sole
 * property of their respective owners. All rights reserved.
 */

package aQute.bytecodes;

import java.io.*;
import java.lang.reflect.*;

public class ClassParser {
	DataInputStream			in;
	protected int			magic;
	protected int			majorVersion;
	protected int			minorVersion;
	protected int			constPoolCount;
	protected PoolEntry[]	constPool;

	public ClassParser(InputStream in) {
		in = new DataInputStream(in);
	}

	public void go() throws IOException {
		magic = in.readInt();
		check(magic == 0xCAFEBABE, "Invalid magic");
		majorVersion = in.readUnsignedShort();
		minorVersion = in.readUnsignedShort();
		constPoolCount = in.readUnsignedShort();
		constPool = new PoolEntry[constPoolCount];
		for (int i = 1; i < constPoolCount; i++) {
			PoolEntry entry = new PoolEntry(constPool, in);
			constPool[i] = entry;
		}
		int accessFlags = in.readUnsignedShort();
		String thisClass = getClassName();
		String superClass = getClassName();
		int interfacesCount = in.readUnsignedShort();
		String[] interfaces = new String[interfacesCount];
		for (int i = 0; i < interfacesCount; i++) {
			interfaces[i] = getClassName();
		}
		if (!doClass(accessFlags, thisClass, superClass, interfaces))
			return;
		
		int fieldsCount = in.readUnsignedShort();
		for ( int i=0; i<fieldsCount; i++ ) {
			int access = in.readUnsignedShort();
			String name = getString();
			String descriptor = getString();
						
			doField(access, name, descriptor );
			
			doAttributes();
		}

		int methodsCount = in.readUnsignedShort();
		for ( int i=0; i<methodsCount; i++ ) {
			int access = in.readUnsignedShort();
			String name = getString();
			String descriptor = getString();
						
			doMethod(access, name, descriptor );
			doAttributes();
		}
		
		doAttributes();
	}

	private void check(boolean b, String msg) {
		if ( ! b ) 
			throw new IllegalArgumentException(msg);		
	}

	private String getClassName() throws IOException {
		return constPool[in.readUnsignedShort()].getClassName();
	}

	private String getString() throws IOException {
		return constPool[in.readUnsignedShort()].getString();
	}

	protected void doField(int access, String name, String descriptor) {
		// TODO Auto-generated method stub
	}

	private void doAttributes() throws IOException {
		int attributesCount = in.readUnsignedShort();
		for(int j=0; j<attributesCount; j++ ){
			String attributeName = constPool[in.readUnsignedShort()].getString();
			int attributeLength = in.readInt();
			if ( attributeLength < 0 )
				throw new IllegalArgumentException("Does not support attributes > 2gb");
			byte [] data = new byte[attributeLength];
			in.read(data);
			doAttribute(attributeName, data);
		}
	}

	protected void doMethod(int access, String name, String descriptor) {
	}

	protected void doAttribute(String name, byte[] data) {
	}

	protected boolean doClass(int accessFlags, String thisClass,
			String superClass, String[] interfaces) {
		return false;
	}
}
