﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/guardduty/model/MalwareProtectionConfiguration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

MalwareProtectionConfiguration::MalwareProtectionConfiguration() : 
    m_scanEc2InstanceWithFindingsHasBeenSet(false)
{
}

MalwareProtectionConfiguration::MalwareProtectionConfiguration(JsonView jsonValue) : 
    m_scanEc2InstanceWithFindingsHasBeenSet(false)
{
  *this = jsonValue;
}

MalwareProtectionConfiguration& MalwareProtectionConfiguration::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("scanEc2InstanceWithFindings"))
  {
    m_scanEc2InstanceWithFindings = jsonValue.GetObject("scanEc2InstanceWithFindings");

    m_scanEc2InstanceWithFindingsHasBeenSet = true;
  }

  return *this;
}

JsonValue MalwareProtectionConfiguration::Jsonize() const
{
  JsonValue payload;

  if(m_scanEc2InstanceWithFindingsHasBeenSet)
  {
   payload.WithObject("scanEc2InstanceWithFindings", m_scanEc2InstanceWithFindings.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
