﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/imagebuilder/model/VulnerabilityIdAggregation.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace imagebuilder
{
namespace Model
{

VulnerabilityIdAggregation::VulnerabilityIdAggregation() : 
    m_vulnerabilityIdHasBeenSet(false),
    m_severityCountsHasBeenSet(false)
{
}

VulnerabilityIdAggregation::VulnerabilityIdAggregation(JsonView jsonValue) : 
    m_vulnerabilityIdHasBeenSet(false),
    m_severityCountsHasBeenSet(false)
{
  *this = jsonValue;
}

VulnerabilityIdAggregation& VulnerabilityIdAggregation::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("vulnerabilityId"))
  {
    m_vulnerabilityId = jsonValue.GetString("vulnerabilityId");

    m_vulnerabilityIdHasBeenSet = true;
  }

  if(jsonValue.ValueExists("severityCounts"))
  {
    m_severityCounts = jsonValue.GetObject("severityCounts");

    m_severityCountsHasBeenSet = true;
  }

  return *this;
}

JsonValue VulnerabilityIdAggregation::Jsonize() const
{
  JsonValue payload;

  if(m_vulnerabilityIdHasBeenSet)
  {
   payload.WithString("vulnerabilityId", m_vulnerabilityId);

  }

  if(m_severityCountsHasBeenSet)
  {
   payload.WithObject("severityCounts", m_severityCounts.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace imagebuilder
} // namespace Aws
