// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

namespace Microsoft.AspNetCore.HttpSys.Internal
{
    internal static class HttpKnownHeaderNames
    {
        internal const string CacheControl = "Cache-Control";
        internal const string Connection = "Connection";
        internal const string Date = "Date";
        internal const string KeepAlive = "Keep-Alive";
        internal const string Pragma = "Pragma";
        internal const string ProxyConnection = "Proxy-Connection";
        internal const string Trailer = "Trailer";
        internal const string TransferEncoding = "Transfer-Encoding";
        internal const string Upgrade = "Upgrade";
        internal const string Via = "Via";
        internal const string Warning = "Warning";
        internal const string ContentLength = "Content-Length";
        internal const string ContentType = "Content-Type";
        internal const string ContentDisposition = "Content-Disposition";
        internal const string ContentEncoding = "Content-Encoding";
        internal const string ContentLanguage = "Content-Language";
        internal const string ContentLocation = "Content-Location";
        internal const string ContentRange = "Content-Range";
        internal const string Expires = "Expires";
        internal const string LastModified = "Last-Modified";
        internal const string Age = "Age";
        internal const string Location = "Location";
        internal const string ProxyAuthenticate = "Proxy-Authenticate";
        internal const string RetryAfter = "Retry-After";
        internal const string Server = "Server";
        internal const string SetCookie = "Set-Cookie";
        internal const string SetCookie2 = "Set-Cookie2";
        internal const string Vary = "Vary";
        internal const string WWWAuthenticate = "WWW-Authenticate";
        internal const string Accept = "Accept";
        internal const string AcceptCharset = "Accept-Charset";
        internal const string AcceptEncoding = "Accept-Encoding";
        internal const string AcceptLanguage = "Accept-Language";
        internal const string Authorization = "Authorization";
        internal const string Cookie = "Cookie";
        internal const string Cookie2 = "Cookie2";
        internal const string Expect = "Expect";
        internal const string From = "From";
        internal const string Host = "Host";
        internal const string IfMatch = "If-Match";
        internal const string IfModifiedSince = "If-Modified-Since";
        internal const string IfNoneMatch = "If-None-Match";
        internal const string IfRange = "If-Range";
        internal const string IfUnmodifiedSince = "If-Unmodified-Since";
        internal const string MaxForwards = "Max-Forwards";
        internal const string ProxyAuthorization = "Proxy-Authorization";
        internal const string Referer = "Referer";
        internal const string Range = "Range";
        internal const string UserAgent = "User-Agent";
        internal const string ContentMD5 = "Content-MD5";
        internal const string ETag = "ETag";
        internal const string TE = "TE";
        internal const string Allow = "Allow";
        internal const string AcceptRanges = "Accept-Ranges";
        internal const string P3P = "P3P";
        internal const string XPoweredBy = "X-Powered-By";
        internal const string XAspNetVersion = "X-AspNet-Version";
        internal const string SecWebSocketKey = "Sec-WebSocket-Key";
        internal const string SecWebSocketExtensions = "Sec-WebSocket-Extensions";
        internal const string SecWebSocketAccept = "Sec-WebSocket-Accept";
        internal const string Origin = "Origin";
        internal const string SecWebSocketProtocol = "Sec-WebSocket-Protocol";
        internal const string SecWebSocketVersion = "Sec-WebSocket-Version";
    }
}
