// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Diagnostics;
using System.Net;
using System.Runtime.InteropServices;
using System.Threading;
using Microsoft.Win32;

namespace System.Net.Sockets
{
    // BaseOverlappedAsyncResult
    //
    // This class is used to track state for async Socket operations such as the BeginSend, BeginSendTo,
    // BeginReceive, BeginReceiveFrom, BeginSendFile, and BeginAccept calls.
    internal partial class BaseOverlappedAsyncResult : ContextAwareResult
    {
        public BaseOverlappedAsyncResult(Socket socket, object? asyncState, AsyncCallback? asyncCallback)
            : base(socket, asyncState, asyncCallback)
        {
            if (NetEventSource.Log.IsEnabled()) NetEventSource.Info(this, socket);
        }

        protected void CompletionCallback(int numBytes, SocketError errorCode)
        {
            ErrorCode = (int)errorCode;
            InvokeCallback(PostCompletion(numBytes));
        }
    }
}
