/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.errorparsers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParserNamed;
import org.eclipse.cdt.core.errorparsers.RegexErrorPattern;

public class RegexErrorParser
implements IErrorParserNamed {
    private String fId;
    private String fName;
    private final List<RegexErrorPattern> fPatterns = new ArrayList<RegexErrorPattern>();

    public RegexErrorParser() {
        this.fName = this.getClass().getSimpleName();
        this.fId = this.getClass().getCanonicalName();
    }

    public RegexErrorParser(String id, String name) {
        this.fName = name;
        this.fId = id;
    }

    @Override
    public void setId(String id) {
        this.fId = id;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    public void addPattern(RegexErrorPattern pattern) {
        this.fPatterns.add(pattern);
    }

    public void removePattern(RegexErrorPattern pattern) {
        this.fPatterns.remove(pattern);
    }

    public void clearPatterns() {
        this.fPatterns.clear();
    }

    public String toString() {
        return "id=" + this.fId + ", name=" + this.fName;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public RegexErrorPattern[] getPatterns() {
        return this.fPatterns.toArray(new RegexErrorPattern[0]);
    }

    @Override
    public boolean processLine(String line, ErrorParserManager epManager) {
        for (RegexErrorPattern pattern : this.fPatterns) {
            try {
                if (!pattern.processLine(line, epManager)) continue;
                return true;
            }
            catch (Exception e) {
                String message = "Error parsing line [" + line + "]";
                CCorePlugin.log(message, e);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof RegexErrorParser) {
            RegexErrorParser that = (RegexErrorParser)o;
            return this.fId.equals(that.fId) && this.fName.equals(that.fName) && this.fPatterns.equals(that.fPatterns);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        RegexErrorParser that = new RegexErrorParser(this.fId, this.fName);
        for (RegexErrorPattern pattern : this.fPatterns) {
            that.addPattern((RegexErrorPattern)pattern.clone());
        }
        return that;
    }
}

