/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction;

import org.eclipse.cdt.core.parser.IPersistableProblem;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.ui.text.IProblemLocation;

public class ProblemLocation
implements IProblemLocation {
    private final int fId;
    private final String[] fArguments;
    private final int fOffset;
    private final int fLength;
    private final boolean fIsError;
    private final String fMarkerType;

    public ProblemLocation(int offset, int length, ICAnnotation annotation) {
        this.fId = annotation.getId();
        this.fArguments = annotation.getArguments();
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = "org.eclipse.cdt.ui.error".equals(annotation.getType());
        String markerType = annotation.getMarkerType();
        this.fMarkerType = markerType != null ? markerType : "org.eclipse.cdt.core.problem";
    }

    public ProblemLocation(int offset, int length, int id, String[] arguments, boolean isError, String markerType) {
        this.fId = id;
        this.fArguments = arguments;
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = isError;
        this.fMarkerType = markerType;
    }

    public ProblemLocation(IProblem problem) {
        this.fId = problem.getID();
        this.fArguments = problem.getArguments();
        this.fOffset = problem.getSourceStart();
        this.fLength = problem.getSourceEnd() - this.fOffset + 1;
        this.fIsError = problem.isError();
        this.fMarkerType = problem instanceof IPersistableProblem ? ((IPersistableProblem)problem).getMarkerType() : "org.eclipse.cdt.core.problem";
    }

    @Override
    public int getProblemId() {
        return this.fId;
    }

    @Override
    public String[] getProblemArguments() {
        return this.fArguments;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public boolean isError() {
        return this.fIsError;
    }

    @Override
    public String getMarkerType() {
        return this.fMarkerType;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Id: ").append(this.getErrorCode(this.fId)).append('\n');
        buf.append('[').append(this.fOffset).append(", ").append(this.fLength).append(']').append('\n');
        String[] arg = this.fArguments;
        if (arg != null) {
            int i = 0;
            while (i < arg.length) {
                buf.append(arg[i]);
                buf.append('\n');
                ++i;
            }
        }
        return buf.toString();
    }

    private String getErrorCode(int code) {
        StringBuilder buf = new StringBuilder();
        if ((code & 0x1000000) != 0) {
            buf.append("ScannerRelated + ");
        }
        if ((code & 0x2000000) != 0) {
            buf.append("PreprocessorRelated + ");
        }
        if ((code & 0x10000000) != 0) {
            buf.append("Internal + ");
        }
        if ((code & 0x4000000) != 0) {
            buf.append("Syntax + ");
        }
        buf.append(code & 0xFFFFFF);
        return buf.toString();
    }
}

