/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import java.util.HashMap;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.typehierarchy.THHierarchyModel;
import org.eclipse.cdt.internal.ui.typehierarchy.THNode;
import org.eclipse.cdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class THLabelProvider
extends AppearanceAwareLabelProvider {
    private static final long LABEL_OPTIONS_SIMPLE = 34613801L;
    private static final long LABEL_OPTIONS_SHOW_FILES = 2182097449L;
    private CUILabelProvider fCLabelProvider = new CUILabelProvider(34613801L, 0);
    private THHierarchyModel fModel;
    private HashMap<String, Image> fCachedImages = new HashMap();
    private Color fColorInactive;
    private boolean fMarkImplementers = true;
    private boolean fHideNonImplementers = false;

    public THLabelProvider(Display display, THHierarchyModel model) {
        this.fColorInactive = display.getSystemColor(16);
        this.fModel = model;
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof THNode) {
            THNode node = (THNode)element;
            ICElement decl = node.getElement();
            if (decl != null) {
                if (node.isFiltered() || this.fHideNonImplementers && !node.isImplementor()) {
                    this.fCLabelProvider.setImageFlags(4);
                }
                Image image = this.fCLabelProvider.getImage(decl);
                this.fCLabelProvider.setImageFlags(0);
                if (image != null) {
                    return this.decorateImage(image, node);
                }
            }
        } else if (element instanceof ICElement) {
            return this.fCLabelProvider.getImage(element);
        }
        return super.getImage(element);
    }

    @Override
    public String getText(Object element) {
        THNode node;
        ICElement decl;
        if (element instanceof THNode && (decl = (node = (THNode)element).getElement()) != null) {
            String label = this.fCLabelProvider.getText(decl);
            return this.decorateText(label, element);
        }
        return super.getText(element);
    }

    @Override
    public StyledString getStyledText(Object element) {
        THNode node;
        ICElement decl;
        if (element instanceof THNode && (decl = (node = (THNode)element).getElement()) != null) {
            StyledString label = this.fCLabelProvider.getStyledText(decl);
            this.fModel.isShowInheritedMembers();
            String decorated = this.decorateText(label.getString(), element);
            if (decorated != null) {
                return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.DECORATIONS_STYLER, (StyledString)label);
            }
            return label;
        }
        return super.getStyledText(element);
    }

    @Override
    public void dispose() {
        this.fCLabelProvider.dispose();
        for (Image image : this.fCachedImages.values()) {
            image.dispose();
        }
        this.fCachedImages.clear();
        super.dispose();
    }

    private Image decorateImage(Image image, THNode node) {
        String key;
        Image result;
        int flags = 0;
        if (node.hasChildren()) {
            flags = this.fModel.getHierarchyKind() == 2 ? (flags |= 0x200) : (flags |= 0x800);
        }
        if (this.fMarkImplementers && node.isImplementor()) {
            flags |= 0x4000;
        }
        if ((result = this.fCachedImages.get(key = image.toString() + String.valueOf(flags))) == null) {
            CElementImageDescriptor desc = new CElementImageDescriptor(new ImageImageDescriptor(image), flags, new Point(20, 16));
            result = desc.createImage();
            this.fCachedImages.put(key, result);
        }
        return result;
    }

    @Override
    public Color getForeground(Object element) {
        THNode node;
        if (element instanceof THNode && (node = (THNode)element).isFiltered()) {
            return this.fColorInactive;
        }
        return null;
    }

    public void setShowFiles(boolean show) {
        this.fCLabelProvider.setTextFlags(show ? 2182097449L : 34613801L);
    }

    public void setMarkImplementers(boolean val) {
        this.fMarkImplementers = val;
    }

    public void setHideNonImplementers(boolean val) {
        this.fHideNonImplementers = val;
    }

    @Override
    public void addLabelDecorator(ILabelDecorator decorator) {
        super.addLabelDecorator(decorator);
    }
}

