import { DateTime } from '../datetime/moment_wrapper';
export interface RawTimeRange {
    from: DateTime | string;
    to: DateTime | string;
}
export interface TimeRange {
    from: DateTime;
    to: DateTime;
    raw: RawTimeRange;
}
export interface AbsoluteTimeRange {
    from: number;
    to: number;
}
export interface IntervalValues {
    interval: string;
    intervalMs: number;
}
export declare type TimeZoneUtc = 'utc';
export declare type TimeZoneBrowser = 'browser';
export declare type TimeZone = TimeZoneBrowser | TimeZoneUtc | string;
export declare const DefaultTimeZone: TimeZone;
export interface TimeOption {
    from: string;
    to: string;
    display: string;
    section: number;
}
export interface TimeOptions {
    [key: string]: TimeOption[];
}
export declare type TimeFragment = string | DateTime;
export declare const TIME_FORMAT = "YYYY-MM-DD HH:mm:ss";
export declare function getDefaultTimeRange(): TimeRange;
