"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSyntheticEvent = exports.isElement = exports.isDomException = exports.isDomError = exports.isErrorEvent = exports.isError = exports.isEvent = exports.isPrimitive = exports.isThenable = exports.isRegExp = exports.isArray = exports.isFunction = exports.isObject = exports.isSymbol = exports.isBoolean = exports.isInt = exports.isNumber = exports.isString = exports.isNull = exports.isUndefined = exports.isInstanceOf = exports.isToString = exports.isTypeof = void 0;
function isTypeof(value, type) {
    return typeof value === type;
}
exports.isTypeof = isTypeof;
function isToString(value, type) {
    return Object.prototype.toString.call(value) === "'[object ".concat(type, "]'");
}
exports.isToString = isToString;
function isInstanceOf(value, reference) {
    try {
        return value instanceof reference;
    }
    catch (err) {
        return false;
    }
}
exports.isInstanceOf = isInstanceOf;
exports.isUndefined = (function (value) { return isTypeof(value, 'undefined'); });
exports.isNull = (function (value) { return isTypeof(value, 'null'); });
exports.isString = (function (value) { return isTypeof(value, 'string'); });
exports.isNumber = (function (value) {
    return (isTypeof(value, 'number') && !isNaN(value)) || isTypeof(value, 'bigint');
});
exports.isInt = (function (value) { return (0, exports.isNumber)(value) && Number.isInteger(value); });
exports.isBoolean = (function (value) { return isTypeof(value, 'boolean'); });
exports.isSymbol = (function (value) { return isTypeof(value, 'symbol'); });
exports.isObject = (function (value) { return !(0, exports.isNull)(value) && isTypeof(value, 'object'); });
exports.isFunction = (function (value) { return isTypeof(value, 'function'); });
exports.isArray = (function (value) { return isToString(value, 'Array'); });
exports.isRegExp = (function (value) { return isToString(value, 'RegExp'); });
exports.isThenable = (function (value) { return (0, exports.isFunction)(value === null || value === void 0 ? void 0 : value.then); });
exports.isPrimitive = (function (value) { return !(0, exports.isObject)(value) && !(0, exports.isFunction)(value); });
exports.isEvent = (function (value) { return !(0, exports.isUndefined)(Event) && isInstanceOf(value, Event); });
exports.isError = (function (value) { return !(0, exports.isUndefined)(Error) && isInstanceOf(value, Error); });
exports.isErrorEvent = (function (value) { return isToString(value, 'ErrorEvent'); });
exports.isDomError = (function (value) { return isToString(value, 'DOMError'); });
exports.isDomException = (function (value) { return isToString(value, 'DOMException'); });
exports.isElement = (function (value) { return !(0, exports.isUndefined)(Element) && isInstanceOf(value, Element); });
exports.isSyntheticEvent = (function (value) {
    return (0, exports.isObject)(value) &&
        'nativeEvent' in value &&
        'preventDefault' in value &&
        'stopPropagation' in value;
});
//# sourceMappingURL=is.js.map