export declare type IsFnHelper<T = unknown> = (value: unknown) => value is T;
export declare function isTypeof<T = unknown>(value: unknown, type: string): value is T;
export declare function isToString<T = unknown>(value: unknown, type: string): value is T;
export declare function isInstanceOf<T extends Function = any>(value: unknown, reference: T): value is T;
export declare const isUndefined: IsFnHelper<undefined>;
export declare const isNull: IsFnHelper<null>;
export declare const isString: IsFnHelper<string>;
export declare const isNumber: IsFnHelper<number | bigint>;
export declare const isInt: IsFnHelper<number>;
export declare const isBoolean: IsFnHelper<boolean>;
export declare const isSymbol: IsFnHelper<Symbol>;
export declare const isObject: IsFnHelper<object>;
export declare const isFunction: IsFnHelper<Function>;
export declare const isArray: IsFnHelper<unknown[]>;
export declare const isRegExp: IsFnHelper<string>;
export declare const isThenable: IsFnHelper<{
    then: Function;
}>;
export declare const isPrimitive: IsFnHelper<string | number | bigint | boolean | symbol>;
export declare const isEvent: IsFnHelper<Event>;
export declare const isError: IsFnHelper<Error>;
export declare const isErrorEvent: IsFnHelper<ErrorEvent>;
export declare const isDomError: IsFnHelper<DOMException>;
export declare const isDomException: IsFnHelper<DOMException>;
export declare const isElement: IsFnHelper<Element>;
export declare const isSyntheticEvent: IsFnHelper<Event>;
