import { CSSObject } from '@emotion/css';
import React, { ButtonHTMLAttributes } from 'react';
import { GrafanaTheme2 } from '@grafana/data';
import { IconName } from '../../types/icon';
import { ComponentSize } from '../../types/size';
import { PopoverContent, TooltipPlacement } from '../Tooltip';
export declare type ButtonVariant = 'primary' | 'secondary' | 'destructive' | 'success';
export declare const allButtonVariants: ButtonVariant[];
export declare type ButtonFill = 'solid' | 'outline' | 'text';
export declare const allButtonFills: ButtonFill[];
declare type CommonProps = {
    size?: ComponentSize;
    variant?: ButtonVariant;
    fill?: ButtonFill;
    icon?: IconName;
    className?: string;
    children?: React.ReactNode;
    fullWidth?: boolean;
    type?: string;
    /** Tooltip content to display on hover */
    tooltip?: PopoverContent;
    /** Position of the tooltip */
    tooltipPlacement?: TooltipPlacement;
};
export declare type ButtonProps = CommonProps & ButtonHTMLAttributes<HTMLButtonElement>;
export declare const Button: React.ForwardRefExoticComponent<CommonProps & React.ButtonHTMLAttributes<HTMLButtonElement> & React.RefAttributes<HTMLButtonElement>>;
export declare const LinkButton: React.ForwardRefExoticComponent<CommonProps & React.ButtonHTMLAttributes<HTMLButtonElement> & React.AnchorHTMLAttributes<HTMLAnchorElement> & React.RefAttributes<HTMLAnchorElement>>;
export interface StyleProps {
    size: ComponentSize;
    variant: ButtonVariant;
    fill?: ButtonFill;
    iconOnly?: boolean;
    theme: GrafanaTheme2;
    fullWidth?: boolean;
    narrow?: boolean;
}
export declare const getButtonStyles: (props: StyleProps) => {
    button: string;
    disabled: string;
    img: string;
    icon: string;
    content: string;
};
export declare function getPropertiesForVariant(theme: GrafanaTheme2, variant: ButtonVariant, fill: ButtonFill): CSSObject;
export {};
