import React from 'react';
import { Field, LinkModel, LogRowModel, LogsSortOrder, TimeZone, DataQueryResponse } from '@grafana/data';
import { RowContextOptions } from './LogRowContextProvider';
export declare const LogRow: React.FunctionComponent<{
    timeZone: TimeZone;
    row: LogRowModel;
    wrapLogMessage: boolean;
    onClickFilterLabel?: ((key: string, value: string) => void) | undefined;
    onClickFilterOutLabel?: ((key: string, value: string) => void) | undefined;
    showDetectedFields?: string[] | undefined;
    onClickShowDetectedField?: ((key: string) => void) | undefined;
    onClickHideDetectedField?: ((key: string) => void) | undefined;
    getRowContext: (row: LogRowModel, options?: RowContextOptions) => Promise<DataQueryResponse>;
    logsSortOrder?: LogsSortOrder | null | undefined;
    prettifyLogMessage: boolean;
    showContextToggle?: ((row?: LogRowModel) => boolean) | undefined;
    getRows: () => LogRowModel[];
    showDuplicates: boolean;
    getFieldLinks?: ((field: Field, rowIndex: number) => Array<LinkModel<Field>>) | undefined;
    showLabels: boolean;
    showTime: boolean;
    enableLogDetails: boolean;
    forceEscape?: boolean | undefined;
    onContextClick?: (() => void) | undefined;
    onLogRowHover?: ((row?: LogRowModel) => void) | undefined;
}>;
