/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.jss.tomcat;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractJsseEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.dogtagpki.jss.tomcat.JSSNioEndpoint;
import org.dogtagpki.jss.tomcat.TomcatJSS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http11NioProtocol
extends AbstractHttp11JsseProtocol<NioChannel> {
    public static Logger logger = LoggerFactory.getLogger(Http11NioProtocol.class);
    private static final Log log = LogFactory.getLog(Http11NioProtocol.class);
    TomcatJSS tomcatjss = TomcatJSS.getInstance();

    public Http11NioProtocol() {
        super((AbstractJsseEndpoint)new JSSNioEndpoint());
    }

    public String getCertdbDir() {
        return this.tomcatjss.getCertdbDir();
    }

    public void setCertdbDir(String certdbDir) {
        this.tomcatjss.setCertdbDir(certdbDir);
    }

    public String getPasswordClass() {
        return this.tomcatjss.getPasswordClass();
    }

    public void setPasswordClass(String passwordClass) {
        this.tomcatjss.setPasswordClass(passwordClass);
    }

    public String getPasswordFile() {
        return this.tomcatjss.getPasswordFile();
    }

    public void setPasswordFile(String passwordFile) {
        this.tomcatjss.setPasswordFile(passwordFile);
    }

    public String getServerCertNickFile() {
        return this.tomcatjss.getServerCertNickFile();
    }

    public void setServerCertNickFile(String serverCertNickFile) {
        this.tomcatjss.setServerCertNickFile(serverCertNickFile);
    }

    public boolean getEnabledOCSP() {
        return this.tomcatjss.getEnableOCSP();
    }

    public void setEnableOCSP(boolean enableOCSP) {
        this.tomcatjss.setEnableOCSP(enableOCSP);
    }

    public String getOcspResponderURL() {
        return this.tomcatjss.getOcspResponderURL();
    }

    public void setOcspResponderURL(String ocspResponderURL) {
        this.tomcatjss.setOcspResponderURL(ocspResponderURL);
    }

    public String getOcspResponderCertNickname() {
        return this.tomcatjss.getOcspResponderCertNickname();
    }

    public void setOcspResponderCertNickname(String ocspResponderCertNickname) {
        this.tomcatjss.setOcspResponderCertNickname(ocspResponderCertNickname);
    }

    public int getOcspCacheSize() {
        return this.tomcatjss.getOcspCacheSize();
    }

    public void setOcspCacheSize(int ocspCacheSize) {
        this.tomcatjss.setOcspCacheSize(ocspCacheSize);
    }

    public int getOcspMinCacheEntryDuration() {
        return this.tomcatjss.getOcspMinCacheEntryDuration();
    }

    public void setOcspMinCacheEntryDuration(int ocspMinCacheEntryDuration) {
        this.tomcatjss.setOcspMinCacheEntryDuration(ocspMinCacheEntryDuration);
    }

    public int getOcspMaxCacheEntryDuration() {
        return this.tomcatjss.getOcspMaxCacheEntryDuration();
    }

    public void setOcspMaxCacheEntryDuration(int ocspMaxCacheEntryDuration) {
        this.tomcatjss.setOcspMaxCacheEntryDuration(ocspMaxCacheEntryDuration);
    }

    public int getOcspTimeout() {
        return this.tomcatjss.getOcspTimeout();
    }

    public void setOcspTimeout(int ocspTimeout) {
        this.tomcatjss.setOcspTimeout(ocspTimeout);
    }

    public void setKeystorePassFile(String keystorePassFile) {
        try {
            Path path = Paths.get(keystorePassFile, new String[0]);
            String password = new String(Files.readAllBytes(path)).trim();
            this.setKeystorePass(password);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTruststorePassFile(String truststorePassFile) {
        try {
            Path path = Paths.get(truststorePassFile, new String[0]);
            String password = new String(Files.readAllBytes(path)).trim();
            this.setTruststorePass(password);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Log getLog() {
        return log;
    }

    protected String getNamePrefix() {
        if (this.isSSLEnabled()) {
            return "https-" + this.getSslImplementationShortName() + "-jss-nio";
        }
        return "http-jss-nio";
    }

    public void setSelectorTimeout(long timeout) {
        ((JSSNioEndpoint)this.getEndpoint()).setSelectorTimeout(timeout);
    }

    public long getSelectorTimeout() {
        return ((JSSNioEndpoint)this.getEndpoint()).getSelectorTimeout();
    }

    public void setPollerThreadPriority(int threadPriority) {
        ((JSSNioEndpoint)this.getEndpoint()).setPollerThreadPriority(threadPriority);
    }

    public int getPollerThreadPriority() {
        return ((JSSNioEndpoint)this.getEndpoint()).getPollerThreadPriority();
    }
}

