/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.cert.CertificateException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;

public class GenericASN1Extension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 8047548816784949009L;
    protected static final int MAX_ATTR = 10;
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_NAME = "name";
    protected static final String PROP_OID = "oid";
    protected static final String PROP_PATTERN = "pattern";
    protected static final String PROP_ATTRIBUTE = "attribute";
    protected static final String PROP_TYPE = "type";
    protected static final String PROP_SOURCE = "source";
    protected static final String PROP_VALUE = "value";
    protected static final String PROP_PREDICATE = "predicate";
    private String name;
    public String OID = null;
    public static Hashtable<String, String> mConfig = null;
    public String pattern = null;
    private int index = 0;

    private void encodeThis() throws IOException, ParseException {
        this.extensionValue = this.encodePattern();
    }

    private byte[] encodePattern() throws IOException, ParseException {
        DerOutputStream tmp = new DerOutputStream();
        String type = null;
        String value = null;
        String source = null;
        while (this.index < this.pattern.length()) {
            char ch = this.pattern.charAt(this.index);
            switch (ch) {
                case '{': {
                    ++this.index;
                    byte[] buff = this.encodePattern();
                    tmp.putDerValue(new DerValue(buff));
                    break;
                }
                case '}': {
                    try (DerOutputStream os = new DerOutputStream();){
                        os.write((byte)48, tmp);
                        byte[] byArray = os.toByteArray();
                        return byArray;
                    }
                }
                default: {
                    type = mConfig.get("attribute." + ch + ".type");
                    if (type.equalsIgnoreCase("integer")) {
                        int num = Integer.parseInt(mConfig.get("attribute." + ch + ".value"));
                        this.PutInteger(tmp, num);
                        break;
                    }
                    if (type.equalsIgnoreCase("ia5string")) {
                        source = mConfig.get("attribute." + ch + ".source");
                        value = mConfig.get("attribute." + ch + ".value");
                        if (source.equalsIgnoreCase("file")) {
                            this.PutIA5String(tmp, this.getFromFile(value));
                            break;
                        }
                        this.PutIA5String(tmp, value);
                        break;
                    }
                    if (type.equalsIgnoreCase("octetstring")) {
                        source = mConfig.get("attribute." + ch + ".source");
                        value = mConfig.get("attribute." + ch + ".value");
                        if (source.equalsIgnoreCase("file")) {
                            this.PutOctetString(tmp, this.getFromFile(value));
                            break;
                        }
                        this.PutOctetString(tmp, value);
                        break;
                    }
                    if (type.equalsIgnoreCase("bmpstring")) {
                        source = mConfig.get("attribute." + ch + ".source");
                        value = mConfig.get("attribute." + ch + ".value");
                        if (source.equalsIgnoreCase("file")) {
                            this.PutBMPString(tmp, this.getFromFile(value));
                            break;
                        }
                        this.PutBMPString(tmp, value);
                        break;
                    }
                    if (type.equalsIgnoreCase("printablestring")) {
                        source = mConfig.get("attribute." + ch + ".source");
                        value = mConfig.get("attribute." + ch + ".value");
                        if (source.equalsIgnoreCase("file")) {
                            this.PutPrintableString(tmp, this.getFromFile(value));
                            break;
                        }
                        this.PutPrintableString(tmp, value);
                        break;
                    }
                    if (type.equalsIgnoreCase("visiblestring")) {
                        source = mConfig.get("attribute." + ch + ".source");
                        value = mConfig.get("attribute." + ch + ".value");
                        if (source.equalsIgnoreCase("file")) {
                            this.PutVisibleString(tmp, this.getFromFile(value));
                            break;
                        }
                        this.PutVisibleString(tmp, value);
                        break;
                    }
                    if (type.equalsIgnoreCase("utctime")) {
                        value = mConfig.get("attribute." + ch + ".value");
                        this.PutUTCtime(tmp, value);
                        break;
                    }
                    if (type.equalsIgnoreCase(PROP_OID)) {
                        value = mConfig.get("attribute." + ch + ".value");
                        this.PutOID(tmp, value);
                        break;
                    }
                    if (type.equalsIgnoreCase("boolean")) {
                        boolean bool = false;
                        String b = mConfig.get("attribute." + ch + ".value");
                        bool = b.equalsIgnoreCase("true");
                        this.PutBoolean(tmp, bool);
                        break;
                    }
                    if (type.equalsIgnoreCase("null")) {
                        tmp.putNull();
                        break;
                    }
                    throw new ParseException("Unknown Attribute Type", 0);
                }
            }
            ++this.index;
        }
        return tmp.toByteArray();
    }

    public GenericASN1Extension(String name, String oid, String pattern, boolean critical, Hashtable<String, String> config) throws IOException, ParseException {
        ObjectIdentifier tmpid = new ObjectIdentifier(oid);
        this.name = name;
        this.OID = oid;
        mConfig = config;
        this.pattern = pattern;
        try {
            if (OIDMap.getName(tmpid) == null) {
                OIDMap.addAttribute("org.mozilla.jss.netscape.security.x509.GenericASN1Extension", oid, name);
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        this.extensionId = tmpid;
        this.critical = critical;
        this.encodeThis();
    }

    public GenericASN1Extension(Hashtable<String, String> config) throws IOException, ParseException {
        mConfig = config;
        ObjectIdentifier tmpid = new ObjectIdentifier(mConfig.get(PROP_OID));
        this.name = mConfig.get(PROP_NAME);
        this.OID = mConfig.get(PROP_OID);
        this.pattern = mConfig.get(PROP_PATTERN);
        try {
            if (OIDMap.getName(tmpid) == null) {
                OIDMap.addAttribute("GenericASN1Extension", this.OID, this.name);
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        this.extensionId = tmpid;
        this.critical = false;
        String b = mConfig.get(PROP_CRITICAL);
        this.critical = b.equalsIgnoreCase("true");
        this.encodeThis();
    }

    public GenericASN1Extension(Boolean critical, Object value) throws IOException {
        this.extensionId = new ObjectIdentifier(this.OID);
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public Object get(String name) throws IOException {
        return null;
    }

    @Override
    public void delete(String name) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        try {
            if (this.extensionValue == null) {
                this.extensionId = new ObjectIdentifier(this.OID);
                this.critical = true;
                this.encodeThis();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOID() {
        return this.OID;
    }

    public void setOID(String oid) {
        this.OID = oid;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement("octet");
        return elements.elements();
    }

    private void PutInteger(DerOutputStream os, int number) throws IOException, ParseException {
        os.putInteger(new BigInt(number));
    }

    private void PutIA5String(DerOutputStream os, String value) throws IOException, ParseException {
        os.putIA5String(value);
    }

    private void PutOctetString(DerOutputStream os, String value) throws IOException, ParseException {
        StringTokenizer token = new StringTokenizer(value, ":");
        byte[] octets = new byte[token.countTokens()];
        int i = 0;
        while (token.hasMoreElements()) {
            String num = (String)token.nextElement();
            octets[i] = (byte)Integer.parseInt(num, 16);
            ++i;
        }
        os.putOctetString(octets);
    }

    private void PutBMPString(DerOutputStream os, String value) throws IOException, ParseException {
        os.putBMPString(value);
    }

    private void PutPrintableString(DerOutputStream os, String value) throws IOException, ParseException {
        os.putPrintableString(value);
    }

    private void PutVisibleString(DerOutputStream os, String value) throws IOException, ParseException {
        os.putVisibleString(value);
    }

    private void PutUTCtime(DerOutputStream os, String value) throws IOException, ParseException {
        DateFormat df = DateFormat.getDateInstance(3);
        os.putUTCTime(df.parse(value));
    }

    private void PutOID(DerOutputStream os, String value) throws IOException, ParseException {
        os.putOID(new ObjectIdentifier(value));
    }

    private void PutBoolean(DerOutputStream os, boolean value) throws IOException, ParseException {
        os.putBoolean(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFromFile(String fname) throws IOException {
        char ch;
        String s = null;
        byte[] buff = null;
        int i = 0;
        int j = 0;
        if (fname == null || fname.equals("")) {
            throw new IOException("File name is not provided.");
        }
        try (FileInputStream fis = null;){
            fis = new FileInputStream(fname);
            int n = 0;
            while ((n = fis.available()) > 0) {
                buff = new byte[n];
                int result = fis.read(buff);
                if (result == -1) {
                    break;
                }
                s = new String(buff);
            }
        }
        if (s == null) {
            return "";
        }
        i = 0;
        for (j = 0; j < s.length(); ++j) {
            ch = s.charAt(j);
            if (ch == '\n' || ch == '\r' || ch == '\t') continue;
            ++i;
        }
        buff = new byte[i];
        i = 0;
        for (j = 0; j < s.length(); ++j) {
            ch = s.charAt(j);
            if (ch == '\n' || ch == '\r' || ch == '\t') continue;
            buff[i++] = (byte)ch;
        }
        s = new String(buff);
        return s;
    }
}

