/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.mozilla.jss.netscape.security.util.DerEncoder;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertParseError;
import org.mozilla.jss.netscape.security.x509.LdapDNStrConverter;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;

public final class AVA
implements DerEncoder {
    ObjectIdentifier oid;
    DerValue value;

    public AVA(String avaString) throws IOException {
        AVA ava = LdapDNStrConverter.getDefault().parseAVA(avaString);
        this.oid = ava.getOid();
        this.value = ava.getValue();
    }

    public AVA(String avaString, byte[] tags) throws IOException {
        AVA ava = LdapDNStrConverter.getDefault().parseAVA(avaString, tags);
        this.oid = ava.getOid();
        this.value = ava.getValue();
    }

    public AVA(String avaString, LdapDNStrConverter ldapDNStrConverter) throws IOException {
        AVA ava = ldapDNStrConverter.parseAVA(avaString);
        this.oid = ava.getOid();
        this.value = ava.getValue();
    }

    public AVA(ObjectIdentifier type, DerValue val) {
        this.oid = type;
        this.value = val;
    }

    public AVA(InputStream in) throws IOException {
        try {
            byte[] buffer = new byte[in.available()];
            if (in.read(buffer) > 0) {
                Charset charset = StandardCharsets.UTF_8;
                CharsetDecoder decoder = charset.newDecoder();
                CharBuffer charBuffer = decoder.decode(ByteBuffer.wrap(buffer));
                AVA a = LdapDNStrConverter.getDefault().parseAVA(charBuffer.toString());
                this.oid = a.getOid();
                this.value = a.getValue();
            }
        }
        catch (UnsupportedCharsetException e) {
            throw new IOException("UTF8 encoding not supported", e);
        }
    }

    public AVA(DerInputStream in) throws IOException {
        DerValue assertion = in.getDerValue();
        if (assertion.tag != 48) {
            throw new CertParseError("X500 AVA, not a sequence");
        }
        ObjectIdentifier o = assertion.data.getOID();
        this.oid = X500NameAttrMap.getDefault().getOid(o);
        if (this.oid == null) {
            this.oid = o;
        }
        this.value = assertion.data.getDerValue();
        if (assertion.data.available() != 0) {
            throw new CertParseError("AVA, extra bytes = " + assertion.data.available());
        }
    }

    public boolean equals(AVA other) {
        return this.oid.equals(other.oid) && this.value.equals(other.value);
    }

    public boolean equals(Object other) {
        AVA ava;
        return other instanceof AVA && this.equals(ava = (AVA)other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oid == null ? 0 : this.oid.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public void encode(DerOutputStream out) throws IOException {
        this.derEncode(out);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        try (DerOutputStream tmp2 = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            tmp.putOID(this.oid);
            this.value.encode(tmp);
            tmp2.write((byte)48, tmp);
            out.write(tmp2.toByteArray());
        }
    }

    public String toLdapDNString() throws IOException {
        LdapDNStrConverter v = LdapDNStrConverter.getDefault();
        return v.encodeAVA(this);
    }

    public String toLdapDNString(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        return ldapDNStrConverter.encodeAVA(this);
    }

    public String toString() {
        String s;
        try {
            s = this.toLdapDNString();
        }
        catch (IOException e) {
            return "";
        }
        return s;
    }

    public ObjectIdentifier getOid() {
        return this.oid;
    }

    public DerValue getValue() {
        return this.value;
    }
}

