/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import org.mozilla.jss.netscape.security.util.ASN1CharStrConvMap;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.AVAValueConverter;

public class IA5StringConverter
implements AVAValueConverter {
    @Override
    public DerValue getValue(String valueString) throws IOException {
        return this.getValue(valueString, null);
    }

    @Override
    public DerValue getValue(String valueString, byte[] tags) throws IOException {
        try {
            CharsetEncoder encoder = ASN1CharStrConvMap.getDefault().getEncoder((byte)22);
            if (encoder == null) {
                throw new IOException("No encoder for IA5String");
            }
            CharBuffer charBuffer = CharBuffer.wrap(valueString.toCharArray());
            ByteBuffer byteBuffer = encoder.encode(charBuffer);
            return new DerValue(22, byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Invalid IA5String AVA Value string");
        }
    }

    @Override
    public DerValue getValue(byte[] berStream) throws IOException {
        DerValue value = new DerValue(berStream);
        if (value.tag == 22) {
            return value;
        }
        if (value.tag == 19) {
            return value;
        }
        throw new IOException("Invalid IA5String AVA Value.");
    }

    @Override
    public String getAsString(DerValue avaValue) throws IOException {
        if (avaValue.tag == 22) {
            return avaValue.getIA5String();
        }
        if (avaValue.tag == 19) {
            return avaValue.getPrintableString();
        }
        throw new IOException("Invalid IA5String AVA Value.");
    }
}

