/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import org.mozilla.jss.netscape.security.util.ExtPrettyPrint;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.util.PrettyPrintResources;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.RevokedCertificate;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrlPrettyPrint {
    private static final String CUSTOM_LOCALE = "Custom";
    private static final Logger logger = LoggerFactory.getLogger(CrlPrettyPrint.class);
    private X509CRLImpl mCRL = null;
    private PrettyPrintFormat pp = null;

    public CrlPrettyPrint(X509CRLImpl crl) {
        this.mCRL = crl;
        this.pp = new PrettyPrintFormat(":");
    }

    public String toString(Locale clientLocale) {
        return this.toString(clientLocale, 0L, 0L, 0L);
    }

    public String toString(Locale clientLocale, long crlSize, long pageStart, long pageSize) {
        ResourceBundle resource = ResourceBundle.getBundle(PrettyPrintResources.class.getName());
        DateFormat dateFormater = DateFormat.getDateTimeInstance(0, 0, clientLocale);
        String tz = " ";
        String tzid = " ";
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(4) + resource.getString("tokenCRL") + "\n");
            sb.append(this.pp.indent(8) + resource.getString("tokenData") + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenVersion") + " v");
            sb.append(this.mCRL.getVersion() + 1 + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenSignatureAlgorithm") + this.mCRL.getSigAlgName() + " - " + this.mCRL.getSigAlgOID() + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenIssuer") + this.mCRL.getIssuerDN().toString() + "\n");
            String thisUpdate = dateFormater.format(this.mCRL.getThisUpdate());
            if (TimeZone.getDefault() != null) {
                tz = TimeZone.getDefault().getDisplayName(TimeZone.getDefault().inDaylightTime(this.mCRL.getThisUpdate()), 0, clientLocale);
                tzid = TimeZone.getDefault().getID();
            }
            if (tz.equals(tzid) || tzid.equals(CUSTOM_LOCALE)) {
                sb.append(this.pp.indent(12) + resource.getString("tokenThisUpdate") + thisUpdate + "\n");
            } else {
                sb.append(this.pp.indent(12) + resource.getString("tokenThisUpdate") + thisUpdate + " " + tzid + "\n");
            }
            if (this.mCRL.getNextUpdate() != null) {
                String nextUpdate = dateFormater.format(this.mCRL.getNextUpdate());
                if (TimeZone.getDefault() != null) {
                    tz = TimeZone.getDefault().getDisplayName(TimeZone.getDefault().inDaylightTime(this.mCRL.getNextUpdate()), 0, clientLocale);
                }
                if (tz.equals(tzid) || tzid.equals(CUSTOM_LOCALE)) {
                    sb.append(this.pp.indent(12) + resource.getString("tokenNextUpdate") + nextUpdate + "\n");
                } else {
                    sb.append(this.pp.indent(12) + resource.getString("tokenNextUpdate") + nextUpdate + " " + tzid + "\n");
                }
            }
            if (crlSize > 0L && pageStart == 0L && pageSize == 0L) {
                sb.append(this.pp.indent(12) + resource.getString("revokedCerts") + crlSize + "\n");
            } else if (crlSize == 0L && pageStart == 0L && pageSize == 0L || crlSize > 0L && pageStart > 0L && pageSize > 0L) {
                sb.append(this.pp.indent(12) + resource.getString("revokedCerts"));
                if (crlSize > 0L && pageStart > 0L && pageSize > 0L) {
                    long upperLimit = pageStart + pageSize - 1L > crlSize ? crlSize : pageStart + pageSize - 1L;
                    sb.append(pageStart + "-" + upperLimit + " of " + crlSize);
                }
                sb.append("\n");
                Set<RevokedCertificate> revokedCerts = this.mCRL.getRevokedCertificates();
                if (revokedCerts != null) {
                    Iterator<RevokedCertificate> i = revokedCerts.iterator();
                    for (long l = 1L; i.hasNext() && (crlSize == 0L || pageStart + pageSize > l); ++l) {
                        RevokedCertificate revokedCert = i.next();
                        if (crlSize != 0L && (pageStart > l || pageStart + pageSize <= l)) continue;
                        sb.append(this.pp.indent(16) + resource.getString("tokenSerial") + "0x" + revokedCert.getSerialNumber().toString(16).toUpperCase() + "\n");
                        String revocationDate = dateFormater.format(revokedCert.getRevocationDate());
                        if (TimeZone.getDefault() != null) {
                            tz = TimeZone.getDefault().getDisplayName(TimeZone.getDefault().inDaylightTime(revokedCert.getRevocationDate()), 0, clientLocale);
                        }
                        if (tz.equals(tzid) || tzid.equals(CUSTOM_LOCALE)) {
                            sb.append(this.pp.indent(16) + resource.getString("revocationDate") + revocationDate + "\n");
                        } else {
                            sb.append(this.pp.indent(16) + resource.getString("revocationDate") + revocationDate + " " + tzid + "\n");
                        }
                        if (!revokedCert.hasExtensions()) continue;
                        sb.append(this.pp.indent(16) + resource.getString("tokenExtensions") + "\n");
                        CRLExtensions crlExtensions = revokedCert.getExtensions();
                        if (crlExtensions == null) continue;
                        for (int k = 0; k < crlExtensions.size(); ++k) {
                            Extension ext = (Extension)crlExtensions.elementAt(k);
                            ExtPrettyPrint extpp = new ExtPrettyPrint(ext, 20);
                            sb.append(extpp.toString());
                        }
                    }
                }
            }
            CRLExtensions crlExtensions = this.mCRL.getExtensions();
            if (crlExtensions != null) {
                sb.append(this.pp.indent(8) + resource.getString("tokenExtensions") + "\n");
                for (int k = 0; k < crlExtensions.size(); ++k) {
                    Extension ext = (Extension)crlExtensions.elementAt(k);
                    ExtPrettyPrint extpp = new ExtPrettyPrint(ext, 12);
                    sb.append(extpp.toString());
                }
            }
            sb.append(this.pp.indent(8) + resource.getString("tokenSignature") + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenAlgorithm") + this.mCRL.getSigAlgName() + " - " + this.mCRL.getSigAlgOID() + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenSignature") + "\n");
            sb.append(this.pp.toHexString(this.mCRL.getSignature(), 16, 16));
        }
        catch (Exception e) {
            sb.append("\n\n" + this.pp.indent(4) + resource.getString("decodingError") + "\n\n");
            logger.debug("Problem converting to string", (Throwable)e);
        }
        return sb.toString();
    }
}

