/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.mozilla.jss.netscape.security.util.PrintableCharset;

public class PrintableCharsetEncoder
extends CharsetEncoder {
    public PrintableCharsetEncoder(Charset cs) {
        super(cs, 1.0f, 1.0f);
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        while (in.remaining() >= 1) {
            in.mark();
            char c = in.get();
            if (CodingErrorAction.REPORT == this.unmappableCharacterAction() && !PrintableCharset.isPrintableChar(c)) {
                return CoderResult.unmappableForLength(1);
            }
            if (out.remaining() < 1) {
                in.reset();
                return CoderResult.OVERFLOW;
            }
            out.put((byte)(c & 0x7F));
        }
        return CoderResult.UNDERFLOW;
    }
}

