/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.util.ECCurve;

public class EC {
    public static ECPoint decodeNSSPoint(byte[] data) {
        int index = 0;
        if (data[index] == 0) {
            ++index;
        }
        if (data[index] == 4) {
            int total_length = data.length - ++index;
            assert ((total_length & 1) == 0);
            int point_length = total_length / 2;
            BigInteger x1 = new BigInteger(1, Arrays.copyOfRange(data, index, index + point_length));
            BigInteger y1 = new BigInteger(1, Arrays.copyOfRange(data, index += point_length, index + point_length));
            assert (index + point_length == data.length);
            return new ECPoint(x1, y1);
        }
        throw new RuntimeException("Unrecognized CKA_EC_POINT encoding form: " + data[index]);
    }

    public static ECParameterSpec decodeNSSOID(byte[] data) {
        ASN1Value value;
        int offset = 0;
        if (data[offset] == 0) {
            ++offset;
        }
        try {
            value = ASN1Util.decode(OBJECT_IDENTIFIER.getTemplate(), Arrays.copyOfRange(data, offset, data.length));
            if (!(value instanceof OBJECT_IDENTIFIER)) {
                throw new RuntimeException("Unrecognized byte data: " + Utils.HexEncode(data));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage() + "\nData: " + Utils.HexEncode(data), e);
        }
        OBJECT_IDENTIFIER oid = (OBJECT_IDENTIFIER)value;
        ECCurve curve = ECCurve.fromOID(oid);
        if (curve == null) {
            throw new RuntimeException("Unrecognized curve: " + Utils.HexEncode(data) + " == OID " + oid);
        }
        return curve.getECParameterSpec();
    }
}

