/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.IA5String;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.TeletexString;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.asn1.UniversalString;

public class JSSUtil {
    public static byte[] encode(byte tag, String string) throws Exception {
        return ASN1Util.encode((ASN1Value)(switch (tag) {
            case 30 -> new BMPString(string);
            case 22 -> new IA5String(string);
            case 19 -> new PrintableString(string);
            case 20 -> new TeletexString(string);
            case 28 -> new UniversalString(string);
            case 12 -> new UTF8String(string);
            default -> throw new Exception("Unsupported tag: " + tag);
        }));
    }

    public static String decode(byte tag, byte[] bytes) throws Exception {
        ASN1Value asnValue = ASN1Util.decode((Tag)new Tag(Tag.UNIVERSAL, (long)tag), (ASN1Template)(switch (tag) {
            case 30 -> new BMPString.Template();
            case 22 -> new IA5String.Template();
            case 19 -> new PrintableString.Template();
            case 20 -> new TeletexString.Template();
            case 28 -> new UniversalString.Template();
            case 12 -> new UTF8String.Template();
            default -> throw new Exception("Unsupported tag: " + tag);
        }), (byte[])bytes);
        if (asnValue == null) {
            throw new Exception("Cannot decode the given bytes.");
        }
        return asnValue.toString();
    }
}

