/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCertificateApprovalCallback
implements SSLCertificateApprovalCallback {
    public static Logger logger = LoggerFactory.getLogger(TestCertificateApprovalCallback.class);

    public boolean approve(X509Certificate servercert, SSLCertificateApprovalCallback.ValidityStatus status) {
        logger.debug("in TestCertificateApprovalCallback.approve()");
        logger.debug("Peer cert details:");
        logger.debug("     subject: " + servercert.getSubjectDN());
        logger.debug("     issuer:  " + servercert.getIssuerDN());
        logger.debug("     serial:  " + servercert.getSerialNumber());
        boolean trust_the_server_cert = false;
        Enumeration errors = status.getReasons();
        int i = 0;
        while (errors.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            logger.debug("item " + ++i + " reason=" + item.getReason() + " depth=" + item.getDepth());
            PK11Cert cert = item.getCert();
            if (item.getReason() == -8172) {
                trust_the_server_cert = true;
            }
            logger.debug(" cert details:");
            logger.debug("     subject: " + cert.getSubjectDN());
            logger.debug("     issuer:  " + cert.getIssuerDN());
            logger.debug("     serial:  " + cert.getSerialNumber());
        }
        if (trust_the_server_cert) {
            logger.debug("importing certificate.");
            try {
                InternalCertificate newcert = CryptoManager.getInstance().importCertToPerm(servercert, "testnick");
                newcert.setSSLTrust(3);
            }
            catch (Exception e) {
                System.out.println("thrown exception: " + e);
            }
        }
        return true;
    }
}

