/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;

public class WrappingParams {
    SymmetricKey.Type skType;
    KeyGenAlgorithm skKeyGenAlgorithm;
    int skLength;
    KeyWrapAlgorithm skWrapAlgorithm;
    EncryptionAlgorithm payloadEncryptionAlgorithm;
    KeyWrapAlgorithm payloadWrapAlgorithm;
    IVParameterSpec payloadEncryptionIV;
    IVParameterSpec payloadWrappingIV;

    public WrappingParams(SymmetricKey.Type skType, KeyGenAlgorithm skKeyGenAlgorithm, int skLength, KeyWrapAlgorithm skWrapAlgorithm, EncryptionAlgorithm payloadEncryptionAlgorithm, KeyWrapAlgorithm payloadWrapAlgorithm, IVParameterSpec payloadEncryptIV, IVParameterSpec payloadWrapIV) {
        this.skType = skType;
        this.skKeyGenAlgorithm = skKeyGenAlgorithm;
        this.skLength = skLength;
        this.skWrapAlgorithm = skWrapAlgorithm;
        this.payloadEncryptionAlgorithm = payloadEncryptionAlgorithm;
        this.payloadWrapAlgorithm = payloadWrapAlgorithm;
        this.payloadEncryptionIV = payloadEncryptIV;
        this.payloadWrappingIV = payloadWrapIV;
    }

    public static EncryptionAlgorithm getEncryptionAlgorithmFromName(String name) throws Exception {
        String[] fields = name.split("//");
        String alg = fields[0];
        String mode = fields[1];
        String padding = fields[2];
        int strength = Integer.parseInt(fields[3]);
        return EncryptionAlgorithm.lookup(alg, mode, padding, strength);
    }

    public WrappingParams() {
    }

    public WrappingParams(String encryptOID, String wrapName, String priKeyAlgo, IVParameterSpec encryptIV, IVParameterSpec wrapIV) throws NumberFormatException, NoSuchAlgorithmException {
        EncryptionAlgorithm encrypt = null;
        OBJECT_IDENTIFIER eccOID = new OBJECT_IDENTIFIER("1.2.840.10045.2.1");
        encrypt = encryptOID.equals(eccOID.toString()) ? EncryptionAlgorithm.DES_CBC_PAD : (encryptOID.equals(KeyWrapAlgorithm.DES3_CBC_PAD_OID.toString()) ? EncryptionAlgorithm.DES3_CBC_PAD : (encryptOID.equals(KeyWrapAlgorithm.AES_CBC_PAD_OID.toString()) ? EncryptionAlgorithm.AES_128_CBC_PAD : EncryptionAlgorithm.fromOID(new OBJECT_IDENTIFIER(encryptOID))));
        KeyWrapAlgorithm wrap = null;
        if (wrapName != null) {
            this.payloadWrapAlgorithm = wrap = KeyWrapAlgorithm.fromString(wrapName);
        }
        switch (encrypt.getAlg().toString()) {
            case "AES": {
                encrypt = EncryptionAlgorithm.AES_128_CBC_PAD;
                this.skType = SymmetricKey.AES;
                this.skKeyGenAlgorithm = KeyGenAlgorithm.AES;
                if (wrap != null) break;
                this.payloadWrapAlgorithm = KeyWrapAlgorithm.AES_KEY_WRAP_PAD;
                break;
            }
            case "DESede": {
                this.skType = SymmetricKey.DES3;
                this.skKeyGenAlgorithm = KeyGenAlgorithm.DES3;
                this.skWrapAlgorithm = KeyWrapAlgorithm.DES3_CBC_PAD;
                if (wrap != null) break;
                this.payloadWrapAlgorithm = KeyWrapAlgorithm.DES3_CBC_PAD;
                break;
            }
            case "DES": {
                this.skType = SymmetricKey.DES;
                this.skKeyGenAlgorithm = KeyGenAlgorithm.DES;
                this.skWrapAlgorithm = KeyWrapAlgorithm.DES3_CBC_PAD;
                if (wrap != null) break;
                this.payloadWrapAlgorithm = KeyWrapAlgorithm.DES_CBC_PAD;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("Invalid algorithm");
            }
        }
        this.skLength = encrypt.getKeyStrength();
        this.skWrapAlgorithm = priKeyAlgo.equals("EC") ? KeyWrapAlgorithm.AES_ECB : KeyWrapAlgorithm.RSA;
        this.payloadEncryptionAlgorithm = encrypt;
        this.payloadEncryptionIV = encryptIV;
        this.payloadWrappingIV = this.payloadWrapAlgorithm == KeyWrapAlgorithm.AES_KEY_WRAP_PAD ? null : wrapIV;
    }

    private WrappingParams(String wrapOID, String priKeyAlgo, IVParameterSpec wrapIV) throws NumberFormatException, NoSuchAlgorithmException {
        KeyWrapAlgorithm kwAlg = KeyWrapAlgorithm.fromOID(wrapOID);
        if (kwAlg == KeyWrapAlgorithm.AES_KEY_WRAP_PAD) {
            this.skType = SymmetricKey.AES;
            this.skKeyGenAlgorithm = KeyGenAlgorithm.AES;
            this.payloadWrapAlgorithm = KeyWrapAlgorithm.AES_KEY_WRAP_PAD;
            this.payloadEncryptionAlgorithm = EncryptionAlgorithm.AES_128_CBC_PAD;
            this.skLength = 128;
        } else if (kwAlg == KeyWrapAlgorithm.AES_CBC_PAD) {
            this.skType = SymmetricKey.AES;
            this.skKeyGenAlgorithm = KeyGenAlgorithm.AES;
            this.payloadWrapAlgorithm = KeyWrapAlgorithm.AES_CBC_PAD;
            this.payloadEncryptionAlgorithm = EncryptionAlgorithm.AES_128_CBC_PAD;
            this.skLength = 128;
        } else if (kwAlg == KeyWrapAlgorithm.DES3_CBC_PAD) {
            this.skType = SymmetricKey.DES3;
            this.skKeyGenAlgorithm = KeyGenAlgorithm.DES3;
            this.skWrapAlgorithm = KeyWrapAlgorithm.DES3_CBC_PAD;
            this.payloadWrapAlgorithm = KeyWrapAlgorithm.DES3_CBC_PAD;
            this.payloadEncryptionAlgorithm = EncryptionAlgorithm.DES3_CBC_PAD;
            this.skLength = this.payloadEncryptionAlgorithm.getKeyStrength();
        } else if (kwAlg == KeyWrapAlgorithm.DES_CBC_PAD) {
            this.skType = SymmetricKey.DES;
            this.skKeyGenAlgorithm = KeyGenAlgorithm.DES;
            this.skWrapAlgorithm = KeyWrapAlgorithm.DES3_CBC_PAD;
            this.payloadWrapAlgorithm = KeyWrapAlgorithm.DES3_CBC_PAD;
            this.payloadEncryptionAlgorithm = EncryptionAlgorithm.DES_CBC_PAD;
            this.skLength = this.payloadEncryptionAlgorithm.getKeyStrength();
        }
        this.skWrapAlgorithm = priKeyAlgo.equals("EC") ? KeyWrapAlgorithm.AES_ECB : KeyWrapAlgorithm.RSA;
        this.payloadEncryptionIV = wrapIV;
        this.payloadWrappingIV = this.payloadWrapAlgorithm == KeyWrapAlgorithm.AES_KEY_WRAP_PAD ? null : wrapIV;
    }

    public static WrappingParams getWrappingParamsFromArchiveOptions(String wrapOID, String priKeyAlgo, IVParameterSpec wrapIV) throws NumberFormatException, NoSuchAlgorithmException {
        return new WrappingParams(wrapOID, priKeyAlgo, wrapIV);
    }

    public SymmetricKey.Type getSkType() {
        return this.skType;
    }

    public void setSkType(SymmetricKey.Type skType) {
        this.skType = skType;
    }

    public void setSkType(String skTypeName) throws NoSuchAlgorithmException {
        this.skType = SymmetricKey.Type.fromName(skTypeName);
    }

    public KeyGenAlgorithm getSkKeyGenAlgorithm() {
        return this.skKeyGenAlgorithm;
    }

    public void setSkKeyGenAlgorithm(KeyGenAlgorithm skKeyGenAlgorithm) {
        this.skKeyGenAlgorithm = skKeyGenAlgorithm;
    }

    public void setSkKeyGenAlgorithm(String algName) throws NoSuchAlgorithmException {
        if (algName.equalsIgnoreCase("AES")) {
            this.skKeyGenAlgorithm = KeyGenAlgorithm.AES;
        } else if (algName.equalsIgnoreCase("DES")) {
            this.skKeyGenAlgorithm = KeyGenAlgorithm.DES;
        } else if (algName.equalsIgnoreCase("DESede")) {
            this.skKeyGenAlgorithm = KeyGenAlgorithm.DES3;
        } else if (algName.equalsIgnoreCase("DES3")) {
            this.skKeyGenAlgorithm = KeyGenAlgorithm.DES3;
        }
    }

    public int getSkLength() {
        return this.skLength;
    }

    public void setSkLength(int skLength) {
        this.skLength = skLength;
    }

    public KeyWrapAlgorithm getSkWrapAlgorithm() {
        return this.skWrapAlgorithm;
    }

    public void setSkWrapAlgorithm(KeyWrapAlgorithm skWrapAlgorithm) {
        this.skWrapAlgorithm = skWrapAlgorithm;
    }

    public void setSkWrapAlgorithm(String name) throws NoSuchAlgorithmException {
        this.skWrapAlgorithm = KeyWrapAlgorithm.fromString(name);
    }

    public EncryptionAlgorithm getPayloadEncryptionAlgorithm() {
        return this.payloadEncryptionAlgorithm;
    }

    public void setPayloadEncryptionAlgorithm(EncryptionAlgorithm payloadEncryptionAlgorithm) {
        this.payloadEncryptionAlgorithm = payloadEncryptionAlgorithm;
    }

    public void setPayloadEncryptionAlgorithm(String algName, String modeName, String paddingName, int keyStrength) throws NoSuchAlgorithmException {
        this.payloadEncryptionAlgorithm = EncryptionAlgorithm.lookup(algName, modeName, paddingName, keyStrength);
    }

    public String getPayloadEncryptionAlgorithmName() {
        int strength = this.payloadEncryptionAlgorithm.getKeyStrength();
        String mode = this.payloadEncryptionAlgorithm.getMode().toString();
        String padding = this.payloadEncryptionAlgorithm.getPadding().toString();
        String alg = this.payloadEncryptionAlgorithm.getAlg().toString();
        return alg + "/" + mode + "/" + padding + "/" + Integer.toString(strength);
    }

    public KeyWrapAlgorithm getPayloadWrapAlgorithm() {
        return this.payloadWrapAlgorithm;
    }

    public void setPayloadWrapAlgorithm(KeyWrapAlgorithm payloadWrapAlgorithm) {
        this.payloadWrapAlgorithm = payloadWrapAlgorithm;
    }

    public void setPayloadWrapAlgorithm(String name) throws NoSuchAlgorithmException {
        this.payloadWrapAlgorithm = KeyWrapAlgorithm.fromString(name);
    }

    public IVParameterSpec getPayloadEncryptionIV() {
        return this.payloadEncryptionIV;
    }

    public void setPayloadEncryptionIV(IVParameterSpec payloadEncryptionIV) {
        this.payloadEncryptionIV = payloadEncryptionIV;
    }

    public IVParameterSpec getPayloadWrappingIV() {
        return this.payloadWrappingIV;
    }

    public void setPayloadWrappingIV(IVParameterSpec payloadWrappingIV) {
        this.payloadWrappingIV = payloadWrappingIV;
    }
}

