/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class BasicConstraintsExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 6213957094939885889L;
    public static final String IDENT = "x509.info.extensions.BasicConstraints";
    public static final String NAME = "BasicConstraints";
    public static final String IS_CA = "is_ca";
    public static final String PATH_LEN = "path_len";
    private boolean ca = false;
    private int pathLen = -1;

    private void encodeThis() throws IOException {
        try (DerOutputStream out = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            if (this.ca) {
                tmp.putBoolean(this.ca);
            }
            if (this.pathLen >= 0) {
                tmp.putInteger(new BigInt(this.pathLen));
            }
            out.write((byte)48, tmp);
            this.extensionValue = out.toByteArray();
        }
    }

    public BasicConstraintsExtension(boolean ca, int len) throws IOException {
        this.ca = ca;
        this.pathLen = len;
        this.extensionId = PKIXExtensions.BasicConstraints_Id;
        this.critical = ca;
        this.encodeThis();
    }

    public BasicConstraintsExtension(boolean ca, boolean critical, int len) throws IOException {
        this.ca = ca;
        this.pathLen = len;
        this.extensionId = PKIXExtensions.BasicConstraints_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public BasicConstraintsExtension(Boolean critical, Object value) throws IOException {
        DerValue opt;
        this.extensionId = PKIXExtensions.BasicConstraints_Id;
        this.critical = critical;
        if (value instanceof byte[]) {
            int len = Array.getLength(value);
            byte[] extValue = new byte[len];
            System.arraycopy(value, 0, extValue, 0, len);
            this.extensionValue = extValue;
            DerValue val = new DerValue(extValue);
            if (val.tag != 48) {
                throw new IOException("Invalid encoding of BasicConstraints");
            }
            if (val.data == null || val.data.available() < 1) {
                this.ca = false;
                this.pathLen = -1;
                return;
            }
            opt = val.data.getDerValue();
            if (opt.tag != 1) {
                this.ca = false;
            } else {
                this.ca = true;
                if (val.data.available() != 0) {
                    opt = val.data.getDerValue();
                } else {
                    this.pathLen = -1;
                    return;
                }
            }
            if (opt.tag != 2) {
                throw new IOException("Invalid encoding of BasicConstraints");
            }
        } else {
            throw new IOException("Invalid argument type");
        }
        this.pathLen = opt.getInteger().toInt();
    }

    @Override
    public String toString() {
        String s = super.toString() + "BasicConstraints:[\n";
        s = s + (this.ca ? "CA:true" : "CA:false") + "\n";
        s = this.pathLen >= 0 ? s + "PathLen:" + this.pathLen + "\n" : s + "PathLen: undefined\n";
        return s + "]\n";
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.BasicConstraints_Id;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.clearValue();
        if (name.equalsIgnoreCase(IS_CA)) {
            if (!(obj instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.ca = (Boolean)obj;
        } else if (name.equalsIgnoreCase(PATH_LEN)) {
            if (!(obj instanceof Integer)) {
                throw new IOException("Attribute value should be of type Integer.");
            }
            this.pathLen = (Integer)obj;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(IS_CA)) {
            return this.ca;
        }
        if (name.equalsIgnoreCase(PATH_LEN)) {
            return this.pathLen;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (name.equalsIgnoreCase(IS_CA)) {
            this.ca = false;
        } else if (name.equalsIgnoreCase(PATH_LEN)) {
            this.pathLen = -1;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(IS_CA);
        elements.addElement(PATH_LEN);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

