/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;

public class OtherName
implements GeneralNameInterface {
    private static final long serialVersionUID = -3533614377346132611L;
    private ObjectIdentifier mOID = null;
    private byte[] mData = null;

    public OtherName(DerValue derValue) throws IOException {
        this.decodeThis(derValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OtherName(ObjectIdentifier oid, byte[] data) throws IOException {
        this.mOID = oid;
        try (DerOutputStream dos = new DerOutputStream();){
            dos.putDerValue(new DerValue(data));
        }
        this.mData = dos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OtherName(ObjectIdentifier oid, byte tag, String value) throws IOException {
        this.mOID = oid;
        try (DerOutputStream dos = new DerOutputStream();){
            if (tag == 19) {
                dos.putPrintableString(value);
            } else if (tag == 22) {
                dos.putIA5String(value);
            } else if (tag == 30) {
                dos.putBMPString(value);
            } else if (tag == 12) {
                dos.putUTF8String(value);
            }
        }
        this.mData = dos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OtherName(ObjectIdentifier oid, String value) throws IOException {
        this.mOID = oid;
        try (DerOutputStream dos = new DerOutputStream();){
            dos.putPrintableString(value);
        }
        this.mData = dos.toByteArray();
    }

    public OtherName(byte[] data) {
        try {
            this.decodeThis(new DerValue(data));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ObjectIdentifier getOID() {
        return this.mOID;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        tmp.putOID(this.mOID);
        DerOutputStream tmp1 = new DerOutputStream();
        tmp1.write(this.mData);
        tmp.write(DerValue.createTag((byte)-128, true, (byte)-128), tmp1);
        out.write((byte)48, tmp);
    }

    public void decode(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.decodeThis(val);
    }

    private void decodeThis(DerValue derVal) throws IOException {
        this.mOID = derVal.data.getOID();
        DerValue tag = derVal.data.getDerValue();
        DerValue data = tag.data.getDerValue();
        this.mData = data.toByteArray();
    }

    public byte[] getValue() {
        return this.mData;
    }

    public String toString() {
        if (this.mData != null) {
            try {
                DerValue data = new DerValue(this.mData);
                if (data.tag == 19) {
                    return "OtherName: (PrintableString)" + this.mOID + "," + data.getPrintableString();
                }
                if (data.tag == 22) {
                    return "OtherName: (IA5String)" + this.mOID + "," + data.getIA5String();
                }
                if (data.tag == 30) {
                    return "OtherName: (BMPString)" + this.mOID + "," + data.getIA5String();
                }
                if (data.tag == 12) {
                    return "OtherName: (UTF8String)" + this.mOID + "," + data.getUTF8String();
                }
                return "OtherName: (Any)" + this.mOID + "," + this.toStr(data.toByteArray());
            }
            catch (IOException e) {
                return "OtherName: (Any)" + this.mOID + "," + this.toStr(this.mData);
            }
        }
        return "OtherName: ";
    }

    public String toStr(byte[] data) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if ((data[i] & 0xFF) < 16) {
                b.append("0");
            }
            b.append(Integer.toString(data[i] & 0xFF, 16));
        }
        return b.toString();
    }
}

