/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPCompareAttrNames;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.LDAPUrl;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.controls.LDAPVirtualListResponse;
import netscape.ldap.util.DSMLWriter;
import netscape.ldap.util.GetOpt;
import netscape.ldap.util.LDIFWriter;
import netscape.ldap.util.MimeBase64Encoder;

public class LDAPSearch
extends LDAPTool {
    private static final String DSML_INTRO = "<dsml:dsml xmlns:dsml=\"http://www.dsml.org/DSML\">";
    private static final String DSML_END = "</dsml:dsml>";
    private static final String DSML_RESULTS_INTRO = " <dsml:directory-entries>";
    private static final String DSML_RESULTS_END = " </dsml:directory-entries>";
    private static boolean m_attrsonly = false;
    private static int m_deref = 0;
    private static int m_scope = 2;
    private static int m_sizelimit = 0;
    private static int m_timelimit = 0;
    private static int verbose = 0;
    private static String[] m_attrs = null;
    private static String m_base = "o=ace industry,c=us";
    private static String m_filter = null;
    private static String m_sep = ":";
    private static Vector<String> m_sort = new Vector();
    private static boolean m_sortOnServer = false;
    private static boolean m_tempFiles = false;
    private static int m_beforeCount = 0;
    private static int m_afterCount = 0;
    private static int m_index = 0;
    private static int m_count = 0;
    private static int m_vlvTokens = 0;
    private static String m_searchVal = null;
    private static boolean m_foldLine = true;
    private static final int MAX_LINE = 77;
    private static PrintWriter m_pw = new PrintWriter(System.out);
    private static MimeBase64Encoder m_encoder = new MimeBase64Encoder();
    private static boolean m_printDSML = false;

    public static void main(String[] args) {
        LDAPSearch.extractParameters(args);
        if (!m_justShow) {
            try {
                m_client = new LDAPConnection();
                m_client.connect(m_ldaphost, m_ldapport);
            }
            catch (Exception e) {
                System.err.println("Error: client connection failed!");
                System.exit(0);
            }
            try {
                m_client.authenticate(m_version, m_binddn, m_passwd);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                System.exit(0);
            }
            LDAPSearch.dosearch();
            m_pw.flush();
            m_pw.close();
            try {
                m_client.disconnect();
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        }
        System.exit(0);
    }

    private static void doUsage() {
        System.err.println("usage: LDAPSearch -b basedn [options] filter [attributes...]");
        System.err.println("options");
        System.err.println("  -h host       LDAP server name or IP address");
        System.err.println("  -p port       LDAP server TCP port number");
        System.err.println("  -V version    LDAP protocol version number (default is 3)");
        System.err.println("  -D binddn     bind dn");
        System.err.println("  -w password   bind passwd (for simple authentication)");
        System.err.println("  -v            run in verbose mode");
        System.err.println("  -n            show what would be done but don't actually do it");
        System.err.println("  -d level      set LDAP debugging level to 'level'");
        System.err.println("  -R            do not automatically follow referrals");
        System.err.println("  -O hop limit  maximum number of referral hops to traverse");
        System.err.println("  -H            display usage information");
        System.err.println("  -t            write values to files");
        System.err.println("  -A            retrieve attribute names only");
        System.err.println("  -F sep        print 'sep' instead of '=' between attribute names and values");
        System.err.println("  -S attr       sort the results by attribute 'attr'");
        System.err.println("  -s scope      one of base, one, or sub (search scope)");
        System.err.println("  -a deref      one of never, always, search, or find (alias dereferencing)");
        System.err.println("  -l timelimit  time limit (in seconds) for search");
        System.err.println("  -T            do not fold (wrap) long lines (default is to fold)");
        System.err.println("  -x            perform sorting on server");
        System.err.println("  -M            manage references (treat them as regular entries)");
        System.err.println("  -z sizelimit  size limit (in entries) for search");
        System.err.println("  -G before:after:index:count | before:after:value where 'before' and 'after' are the number of entries surrounding 'index'. 'count' is the content count, 'value' is the search value.");
        System.err.println("  -y proxy-DN   DN to use for access control");
        System.err.println("  -X            output DSML instead of LDIF");
    }

    protected static void extractParameters(String[] args) {
        String param;
        String privateOpts = "HATtxvnXa:b:F:l:s:S:z:G:";
        GetOpt options = LDAPTool.extractParameters(privateOpts, args);
        if (options.hasOption('H')) {
            LDAPSearch.doUsage();
            System.exit(0);
        }
        if (options.hasOption('A')) {
            m_attrsonly = true;
        }
        if (options.hasOption('x')) {
            m_sortOnServer = true;
        }
        if (options.hasOption('t')) {
            m_tempFiles = true;
        }
        if (options.hasOption('F')) {
            m_sep = options.getOptionParam('F');
        }
        if (options.hasOption('a')) {
            param = options.getOptionParam('a');
            if (param.equalsIgnoreCase("never")) {
                m_deref = 0;
            } else if (param.equalsIgnoreCase("search")) {
                m_deref = 1;
            } else if (param.equalsIgnoreCase("find")) {
                m_deref = 2;
            } else if (param.equalsIgnoreCase("always")) {
                m_deref = 3;
            } else {
                System.err.println("Error: alias deref option should be never, search, find, or always.");
            }
        }
        if (options.hasOption('b')) {
            m_base = options.getOptionParam('b');
        }
        if (options.hasOption('S')) {
            m_sort.addElement(options.getOptionParam('S'));
        }
        if (options.hasOption('l')) {
            try {
                m_timelimit = Integer.parseInt(options.getOptionParam('l'));
            }
            catch (NumberFormatException e) {
                m_timelimit = 0;
            }
        }
        if (options.hasOption('s')) {
            param = options.getOptionParam('s');
            if (param.equalsIgnoreCase("base")) {
                m_scope = 0;
            } else if (param.equalsIgnoreCase("one")) {
                m_scope = 1;
            } else if (param.equalsIgnoreCase("sub")) {
                m_scope = 2;
            } else {
                System.err.println("Error: scope should be base, one or sub.");
            }
        }
        if (options.hasOption('z')) {
            try {
                m_sizelimit = Integer.parseInt(options.getOptionParam('z'));
            }
            catch (NumberFormatException e) {
                m_sizelimit = 0;
            }
        }
        if (options.hasOption('T')) {
            m_foldLine = false;
        }
        if (options.hasOption('X')) {
            m_printDSML = true;
        }
        LDAPSearch.parseVlv(options);
        Enumeration pa = options.getParameters().elements();
        Vector<String> vec = new Vector<String>();
        while (pa.hasMoreElements()) {
            vec.addElement((String)pa.nextElement());
        }
        int counter = vec.size();
        if (counter <= 0) {
            System.err.println("Error: must supply filter string!");
            LDAPSearch.doUsage();
            System.exit(0);
        }
        if (counter == 1) {
            m_filter = (String)vec.elementAt(0);
            if (m_verbose) {
                System.err.println("filter pattern: " + m_filter);
            }
            m_attrs = null;
            if (m_verbose) {
                System.err.println("returning: ALL");
                System.err.println("filter is: (" + m_filter + ")");
            }
        }
        if (counter > 1) {
            m_filter = (String)vec.elementAt(0);
            if (m_verbose) {
                System.err.println("filter pattern: " + m_filter);
                System.err.print("returning:");
            }
            m_attrs = new String[counter];
            for (int j = 1; j < counter; ++j) {
                LDAPSearch.m_attrs[j - 1] = (String)vec.elementAt(j);
                if (!m_verbose) continue;
                System.err.print(" " + m_attrs[j - 1]);
            }
            if (m_verbose) {
                System.err.println();
                System.err.println("filter is: (" + m_filter + ")");
            }
        }
    }

    private static void parseVlv(GetOpt options) {
        if (options.hasOption('G')) {
            String val = options.getOptionParam('G');
            StringTokenizer tokenizer = new StringTokenizer(val, ":");
            m_vlvTokens = tokenizer.countTokens();
            if (m_vlvTokens < 3) {
                LDAPSearch.doUsage();
                System.exit(0);
            }
            try {
                m_beforeCount = Integer.parseInt((String)tokenizer.nextElement());
            }
            catch (NumberFormatException e) {
                m_beforeCount = 0;
            }
            try {
                m_afterCount = Integer.parseInt((String)tokenizer.nextElement());
            }
            catch (NumberFormatException e) {
                m_afterCount = 0;
            }
            if (m_vlvTokens == 3) {
                m_searchVal = (String)tokenizer.nextElement();
            } else if (m_vlvTokens > 3) {
                try {
                    m_index = Integer.parseInt((String)tokenizer.nextElement());
                }
                catch (NumberFormatException e) {
                    m_index = 0;
                }
                try {
                    m_count = Integer.parseInt((String)tokenizer.nextElement());
                }
                catch (NumberFormatException e) {
                    m_count = 0;
                }
            }
        }
    }

    private static void dosearch() {
        Object[] controls = null;
        try {
            Vector<Object> cons = new Vector<Object>();
            LDAPSortControl sort = null;
            if (m_sortOnServer && m_sort.size() > 0) {
                LDAPSortKey[] keys = new LDAPSortKey[m_sort.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = new LDAPSortKey(m_sort.elementAt(i));
                }
                sort = new LDAPSortControl(keys, true);
                cons.addElement(sort);
            }
            if (sort == null && m_vlvTokens >= 3) {
                System.err.println("Server-side sorting is required for virtual list option");
                LDAPSearch.doUsage();
                System.exit(0);
            }
            LDAPVirtualListControl vControl = null;
            if (m_vlvTokens == 3) {
                vControl = new LDAPVirtualListControl(m_searchVal, m_beforeCount, m_afterCount);
            } else if (m_vlvTokens > 3) {
                vControl = new LDAPVirtualListControl(m_index, m_beforeCount, m_afterCount, m_count);
            }
            if (vControl != null) {
                cons.addElement(vControl);
            }
            if (m_proxyControl != null) {
                cons.addElement(m_proxyControl);
            }
            if (m_ordinary) {
                LDAPControl manageDSAITControl = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
                cons.addElement(manageDSAITControl);
            }
            if (cons.size() > 0) {
                controls = new LDAPControl[cons.size()];
                cons.copyInto(controls);
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            System.exit(0);
        }
        LDAPSearchResults res = null;
        try {
            LDAPSearchConstraints cons = m_client.getSearchConstraints();
            cons.setServerControls(controls);
            cons.setDereference(m_deref);
            cons.setMaxResults(m_sizelimit);
            cons.setServerTimeLimit(m_timelimit);
            cons.setReferrals(m_referrals);
            if (m_referrals) {
                LDAPSearch.setDefaultReferralCredentials((LDAPConstraints)cons);
            }
            cons.setHopLimit(m_hopLimit);
            res = m_client.search(m_base, m_scope, m_filter, m_attrs, m_attrsonly, cons);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        if (m_sort.size() > 0 && !m_sortOnServer) {
            String[] sortAttrs = new String[m_sort.size()];
            for (int i = 0; i < sortAttrs.length; ++i) {
                sortAttrs[i] = m_sort.elementAt(i);
            }
            res.sort((LDAPEntryComparator)new LDAPCompareAttrNames(sortAttrs));
        }
        LDAPSearch.printResults(res);
        LDAPSearch.showControls(m_client.getResponseControls());
    }

    private static void printResults(LDAPSearchResults res) {
        DSMLWriter writer;
        boolean isSchema = false;
        boolean didEntryIntro = false;
        if (m_printDSML) {
            LDAPSearch.printString(DSML_INTRO);
            writer = new DSMLWriter(m_pw);
        } else {
            writer = new LDIFWriter(m_pw, m_attrsonly, m_sep, m_foldLine, m_tempFiles);
        }
        try {
            while (res.hasMoreElements()) {
                LDAPEntry entry = null;
                try {
                    entry = res.next();
                }
                catch (LDAPReferralException ee) {
                    LDAPUrl[] urls = ee.getURLs();
                    System.err.println("Referral entries: ");
                    for (int i = 0; i < urls.length; ++i) {
                        System.err.println("\t" + urls[i].getUrl().toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    m_pw.flush();
                    System.err.println(e.toString());
                    continue;
                }
                if (LDAPSearch.isSchemaEntry(entry)) {
                    writer.printSchema(entry);
                    continue;
                }
                if (m_printDSML && !didEntryIntro) {
                    LDAPSearch.printString(DSML_RESULTS_INTRO);
                    didEntryIntro = true;
                }
                writer.printEntry(entry);
            }
        }
        catch (Exception e) {
            m_pw.flush();
            System.err.println(e.toString());
            System.exit(0);
        }
        if (m_printDSML) {
            if (didEntryIntro) {
                LDAPSearch.printString(DSML_RESULTS_END);
            }
            LDAPSearch.printString(DSML_END);
        }
    }

    protected static void printString(String value) {
        m_pw.print(value);
        m_pw.print('\n');
    }

    protected static boolean isSchemaEntry(LDAPEntry entry) {
        LDAPAttribute attr = entry.getAttribute("objectclass");
        if (attr != null) {
            String[] vals = attr.getStringValueArray();
            for (int i = 0; i < vals.length; ++i) {
                if (!vals[i].equalsIgnoreCase("subschema")) continue;
                return true;
            }
        }
        return false;
    }

    private static void showControls(LDAPControl[] controls) {
        if (controls == null) {
            return;
        }
        LDAPSortControl sControl = null;
        LDAPVirtualListResponse vResponse = null;
        for (int i = 0; i < controls.length; ++i) {
            if (controls[i] instanceof LDAPSortControl) {
                sControl = (LDAPSortControl)controls[i];
                continue;
            }
            if (!(controls[i] instanceof LDAPVirtualListResponse)) continue;
            vResponse = (LDAPVirtualListResponse)controls[i];
        }
        if (sControl != null) {
            String bad = sControl.getFailedAttribute();
            int result = sControl.getResultCode();
            if (result != 0) {
                System.err.println("Error code: " + result);
                if (bad != null) {
                    System.err.println("Offending attribute: " + bad);
                } else {
                    System.err.println("No offending attribute returned");
                }
            } else {
                m_pw.println("Server indicated results sorted OK");
            }
        }
        if (vResponse != null) {
            int resultCode = vResponse.getResultCode();
            if (resultCode == 0) {
                m_pw.println("Server indicated virtual list positioning OK");
                m_pw.println("index " + vResponse.getFirstPosition() + " content count " + vResponse.getContentCount());
            } else {
                System.err.println("Virtual List Error: " + LDAPException.errorCodeToString((int)resultCode));
            }
        }
    }
}

