/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import netscape.ldap.util.BadFilterException;
import netscape.ldap.util.LDAPFilter;

public class LDAPIntFilterList {
    private Vector<LDAPFilter> m_vFilter;
    private String m_strMatchPattern;
    private Pattern m_patMatch = null;

    LDAPIntFilterList(LDAPFilter filter) throws BadFilterException {
        this.m_strMatchPattern = filter.getMatchPattern();
        try {
            this.m_patMatch = Pattern.compile(this.m_strMatchPattern);
        }
        catch (PatternSyntaxException e) {
            throw new BadFilterException("The Regular Expression for this filter is bad. Line number: " + filter.getLineNumber());
        }
        this.m_vFilter = new Vector();
        this.m_vFilter.addElement(filter);
    }

    void AddFilter(LDAPFilter filter) {
        this.m_vFilter.addElement(filter);
    }

    int numFilters() {
        return this.m_vFilter.size();
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer(100);
        strBuf.append("    Match Pattern: \"" + this.m_strMatchPattern + "\"\n");
        for (int i = 0; i < this.m_vFilter.size(); ++i) {
            strBuf.append(this.m_vFilter.elementAt(i).toString());
            strBuf.append("\n");
        }
        return strBuf.toString();
    }

    LDAPFilter getFilter(int nFilter) {
        return this.m_vFilter.elementAt(nFilter);
    }

    boolean MatchFilter(String matcherValue) {
        return this.m_patMatch.matcher(matcherValue).matches();
    }
}

