/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __KVM_X86_TDX_ERRNO_H
#define __KVM_X86_TDX_ERRNO_H

/*
 * TDX SEAMCALL Status Codes (returned in RAX)
 */
#define TDX_SUCCESS				0x0000000000000000
#define TDX_NON_RECOVERABLE_VCPU		0x4000000100000000
#define TDX_NON_RECOVERABLE_TD			0x4000000200000000
#define TDX_INTERRUPTED_RESUMABLE		0x8000000300000000
#define TDX_INTERRUPTED_RESTARTABLE		0x8000000400000000
#define TDX_NON_RECOVERABLE_FATAL		0x4000000500000000
#define TDX_INVALID_RESUMPTION			0xC000000600000000
#define TDX_NON_RECOVERABLE_TD_NO_APIC		0xC000000700000000
#define TDX_OPERAND_INVALID			0xC000010000000000
#define TDX_OPERAND_ADDR_RANGE_ERROR		0xC000010100000000
#define TDX_OPERAND_BUSY			0x8000020000000000
#define TDX_PREVIOUS_TLB_EPOCH_BUSY		0x8000020100000000
#define TDX_SYS_BUSY				0x8000020200000000
#define TDX_PAGE_METADATA_INCORRECT		0xC000030000000000
#define TDX_PAGE_ALREADY_FREE			0x0000030100000000
#define TDX_PAGE_NOT_OWNED_BY_TD		0xC000030200000000
#define TDX_PAGE_NOT_FREE			0xC000030300000000
#define TDX_TD_ASSOCIATED_PAGES_EXIST		0xC000040000000000
#define TDX_SYSINIT_NOT_PENDING			0xC000050000000000
#define TDX_SYSINIT_NOT_DONE			0xC000050100000000
#define TDX_SYSINITLP_NOT_DONE			0xC000050200000000
#define TDX_SYSINITLP_DONE			0xC000050300000000
#define TDX_SYS_NOT_READY			0xC000050500000000
#define TDX_SYS_SHUTDOWN			0xC000050600000000
#define TDX_SYSCONFIG_NOT_DONE			0xC000050700000000
#define TDX_TD_NOT_INITIALIZED			0xC000060000000000
#define TDX_TD_INITIALIZED			0xC000060100000000
#define TDX_TD_NOT_FINALIZED			0xC000060200000000
#define TDX_TD_FINALIZED			0xC000060300000000
#define TDX_TD_FATAL				0xC000060400000000
#define TDX_TD_NON_DEBUG			0xC000060500000000
#define TDX_TDCX_NUM_INCORRECT			0xC000061000000000
#define TDX_VCPU_STATE_INCORRECT		0xC000070000000000
#define TDX_VCPU_ASSOCIATED			0x8000070100000000
#define TDX_VCPU_NOT_ASSOCIATED			0x8000070200000000
#define TDX_TDVPX_NUM_INCORRECT			0xC000070300000000
#define TDX_NO_VALID_VE_INFO			0xC000070400000000
#define TDX_MAX_VCPUS_EXCEEDED			0xC000070500000000
#define TDX_TSC_ROLLBACK			0xC000070600000000
#define TDX_FIELD_NOT_WRITABLE			0xC000072000000000
#define TDX_FIELD_NOT_READABLE			0xC000072100000000
#define TDX_TD_VMCS_FIELD_NOT_INITIALIZED	0xC000073000000000
#define TDX_KEY_GENERATION_FAILED		0x8000080000000000
#define TDX_TD_KEYS_NOT_CONFIGURED		0x8000081000000000
#define TDX_KEY_STATE_INCORRECT			0xC000081100000000
#define TDX_KEY_CONFIGURED			0x0000081500000000
#define TDX_WBCACHE_NOT_COMPLETE		0x8000081700000000
#define TDX_HKID_NOT_FREE			0xC000082000000000
#define TDX_NO_HKID_READY_TO_WBCACHE		0x0000082100000000
#define TDX_WBCACHE_RESUME_ERROR		0xC000082300000000
#define TDX_FLUSHVP_NOT_DONE			0x8000082400000000
#define TDX_NUM_ACTIVATED_HKIDS_NOT_SUPPORRTED	0xC000082500000000
#define TDX_INCORRECT_CPUID_VALUE		0xC000090000000000
#define TDX_BOOT_NT4_SET			0xC000090100000000
#define TDX_INCONSISTENT_CPUID_FIELD		0xC000090200000000
#define TDX_CPUID_LEAF_1F_FORMAT_UNRECOGNIZED	0xC000090400000000
#define TDX_INVALID_WBINVD_SCOPE		0xC000090500000000
#define TDX_INVALID_PKG_ID			0xC000090600000000
#define TDX_CPUID_LEAF_NOT_SUPPORTED		0xC000090800000000
#define TDX_SMRR_NOT_LOCKED			0xC000091000000000
#define TDX_INVALID_SMRR_CONFIGURATION		0xC000091100000000
#define TDX_SMRR_OVERLAPS_CMR			0xC000091200000000
#define TDX_SMRR_LOCK_NOT_SUPPORTED		0xC000091300000000
#define TDX_SMRR_NOT_SUPPORTED			0xC000091400000000
#define TDX_INCONSISTENT_MSR			0xC000092000000000
#define TDX_INCORRECT_MSR_VALUE			0xC000092100000000
#define TDX_SEAMREPORT_NOT_AVAILABLE		0xC000093000000000
#define TDX_PERF_COUNTERS_ARE_PEBS_ENABLED	0xC000094000000000
#define TDX_INVALID_TDMR			0xC0000A0000000000
#define TDX_NON_ORDERED_TDMR			0xC0000A0100000000
#define TDX_TDMR_OUTSIDE_CMRS			0xC0000A0200000000
#define TDX_TDMR_ALREADY_INITIALIZED		0x00000A0300000000
#define TDX_INVALID_PAMT			0xC0000A1000000000
#define TDX_PAMT_OUTSIDE_CMRS			0xC0000A1100000000
#define TDX_PAMT_OVERLAP			0xC0000A1200000000
#define TDX_INVALID_RESERVED_IN_TDMR		0xC0000A2000000000
#define TDX_NON_ORDERED_RESERVED_IN_TDMR	0xC0000A2100000000
#define TDX_CMR_LIST_INVALID			0xC0000A2200000000
#define TDX_EPT_WALK_FAILED			0xC0000B0000000000
#define TDX_EPT_ENTRY_FREE			0xC0000B0100000000
#define TDX_EPT_ENTRY_NOT_FREE			0xC0000B0200000000
#define TDX_EPT_ENTRY_NOT_PRESENT		0xC0000B0300000000
#define TDX_EPT_ENTRY_NOT_LEAF			0xC0000B0400000000
#define TDX_EPT_ENTRY_LEAF			0xC0000B0500000000
#define TDX_GPA_RANGE_NOT_BLOCKED		0xC0000B0600000000
#define TDX_GPA_RANGE_ALREADY_BLOCKED		0x00000B0700000000
#define TDX_TLB_TRACKING_NOT_DONE		0xC0000B0800000000
#define TDX_EPT_INVALID_PROMOTE_CONDITIONS	0xC0000B0900000000
#define TDX_PAGE_ALREADY_ACCEPTED		0x00000B0A00000000
#define TDX_PAGE_SIZE_MISMATCH			0x00000B0B00000000

/*
 * TDG.VP.VMCALL Status Codes (returned in R10)
 */
#define TDG_VP_VMCALL_SUCCESS			0x0000000000000000
#define TDG_VP_VMCALL_INVALID_OPERAND		0x8000000000000000
#define TDG_VP_VMCALL_TDREPORT_FAILED		0x8000000000000001

#endif /* __KVM_X86_TDX_ERRNO_H */
