; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -enable-machine-outliner -verify-machineinstrs | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64-pc-linux-gnu"

declare i32 @thunk_called_fn(i32, i32, i32, i32)

define i32 @a() {
; CHECK-LABEL: a:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl OUTLINED_FUNCTION_1
; CHECK-NEXT:    add w0, w0, #8
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %call = tail call i32 @thunk_called_fn(i32 1, i32 2, i32 3, i32 4)
  %cx = add i32 %call, 8
  ret i32 %cx
}

define i32 @b() {
; CHECK-LABEL: b:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl OUTLINED_FUNCTION_1
; CHECK-NEXT:    add w0, w0, #88
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %call = tail call i32 @thunk_called_fn(i32 1, i32 2, i32 3, i32 4)
  %cx = add i32 %call, 88
  ret i32 %cx
}

define hidden i32 @c(i32 (i32, i32, i32, i32)* %fptr) {
; CHECK-LABEL: c:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl OUTLINED_FUNCTION_0
; CHECK-NEXT:    add w0, w0, #8
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %call = tail call i32 %fptr(i32 1, i32 2, i32 3, i32 4)
  %add = add nsw i32 %call, 8
  ret i32 %add
}

define hidden i32 @d(i32 (i32, i32, i32, i32)* %fptr) {
; CHECK-LABEL: d:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl OUTLINED_FUNCTION_0
; CHECK-NEXT:    add w0, w0, #88
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %call = tail call i32 %fptr(i32 1, i32 2, i32 3, i32 4)
  %add = add nsw i32 %call, 88
  ret i32 %add
}

; CHECK: OUTLINED_FUNCTION_0:
; CHECK-SAME: // @OUTLINED_FUNCTION_0 Thunk
; CHECK:        // %bb.0:
; CHECK-NEXT:   mov     x8, x0
; CHECK-NEXT:   mov     w0, #1
; CHECK-NEXT:   mov     w1, #2
; CHECK-NEXT:   mov     w2, #3
; CHECK-NEXT:   mov     w3, #4
; CHECK-NEXT:   br      x8

; CHECK: OUTLINED_FUNCTION_1:
; CHECK-SAME: // @OUTLINED_FUNCTION_1 Thunk
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov     w0, #1
; CHECK-NEXT:    mov     w1, #2
; CHECK-NEXT:    mov     w2, #3
; CHECK-NEXT:    mov     w3, #4
; CHECK-NEXT:    b       thunk_called_fn
