; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1030 < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1030 < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11 %s

define float @v_fma(float %a, float %b, float %c)  {
; GFX10-LABEL: v_fma:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_fma_legacy_f32 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fma:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_fma_dx9_zero_f32 v0, v0, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fma = call float @llvm.amdgcn.fma.legacy(float %a, float %b, float %c)
  ret float %fma
}

define float @v_fma_imm(float %a, float %c)  {
; GCN-LABEL: v_fma_imm:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_waitcnt_vscnt null, 0x0
; GCN-NEXT:    v_fmac_legacy_f32_e32 v1, 0x41200000, v0
; GCN-NEXT:    v_mov_b32_e32 v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
; GFX10-LABEL: v_fma_imm:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_fma_legacy_f32 v0, 0x41200000, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fma_imm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_fma_dx9_zero_f32 v0, 0x41200000, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fma = call float @llvm.amdgcn.fma.legacy(float %a, float 10.0, float %c)
  ret float %fma
}

define float @v_fabs_fma(float %a, float %b, float %c)  {
; GFX10-LABEL: v_fabs_fma:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_fma_legacy_f32 v0, |v0|, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fabs_fma:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_fma_dx9_zero_f32 v0, |v0|, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fabs.a = call float @llvm.fabs.f32(float %a)
  %fma = call float @llvm.amdgcn.fma.legacy(float %fabs.a, float %b, float %c)
  ret float %fma
}

define float @v_fneg_fabs_fma(float %a, float %b, float %c)  {
; GFX10-LABEL: v_fneg_fabs_fma:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_fma_legacy_f32 v0, v0, -|v1|, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_fabs_fma:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_fma_dx9_zero_f32 v0, v0, -|v1|, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fabs.b = call float @llvm.fabs.f32(float %b)
  %neg.fabs.b = fneg float %fabs.b
  %fma = call float @llvm.amdgcn.fma.legacy(float %a, float %neg.fabs.b, float %c)
  ret float %fma
}

define float @v_fneg_fma(float %a, float %b, float %c)  {
; GFX10-LABEL: v_fneg_fma:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_fma_legacy_f32 v0, v0, v1, -v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fneg_fma:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_fma_dx9_zero_f32 v0, v0, v1, -v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %neg.c = fneg float %c
  %fma = call float @llvm.amdgcn.fma.legacy(float %a, float %b, float %neg.c)
  ret float %fma
}

define float @v_fma_const_const(float %a)  {
; GFX10-LABEL: v_fma_const_const:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_fma_legacy_f32 v0, v0, 2.0, -1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fma_const_const:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_fma_dx9_zero_f32 v0, v0, 2.0, -1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fma = call float @llvm.amdgcn.fma.legacy(float %a, float 2.0, float -1.0)
  ret float %fma
}

declare float @llvm.amdgcn.fma.legacy(float, float, float)
declare float @llvm.fabs.f32(float)
