; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -data-layout="e-p:32:32:32-p1:16:16:16-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-n8:16:32" -passes=gvn,dce -enable-split-backedge-in-load-pre -S | FileCheck %s --check-prefixes=CHECK,LE
; RUN: opt < %s -data-layout="E-p:32:32:32-p1:16:16:16-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:64:64-n32" -passes=gvn,dce -enable-split-backedge-in-load-pre -S | FileCheck %s --check-prefixes=CHECK,BE

;; Trivial RLE test.
define i32 @test0(i32 %V, ptr %P) {
; CHECK-LABEL: @test0(
; CHECK-NEXT:    store i32 [[V:%.*]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret i32 [[V]]
;
  store i32 %V, ptr %P

  %A = load i32, ptr %P
  ret i32 %A
}


;;===----------------------------------------------------------------------===;;
;; Tests for crashers
;;===----------------------------------------------------------------------===;;

;; PR5016
define i8 @crash0({i32, i32} %A, ptr %P) {
; CHECK-LABEL: @crash0(
; CHECK-NEXT:    store { i32, i32 } [[A:%.*]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[Y:%.*]] = load i8, ptr [[P]], align 1
; CHECK-NEXT:    ret i8 [[Y]]
;
  store {i32, i32} %A, ptr %P
  %Y = load i8, ptr %P
  ret i8 %Y
}

;; No PR filed, crashed in CaptureTracker.
declare void @helper()
define void @crash1() {
; CHECK-LABEL: @crash1(
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr undef, ptr undef, i64 undef, i1 false) #[[ATTR3:[0-9]+]]
; CHECK-NEXT:    ret void
;
  tail call void @llvm.memcpy.p0.p0.i64(ptr undef, ptr undef, i64 undef, i1 false) nounwind
  %ttmp = load i8, ptr @helper
  %x = icmp eq i8 %ttmp, 15
  ret void
}


;;===----------------------------------------------------------------------===;;
;; Store -> Load  and  Load -> Load forwarding where src and dst are different
;; types, but where the base pointer is a must alias.
;;===----------------------------------------------------------------------===;;

;; i32 -> f32 forwarding.
define float @coerce_mustalias1(i32 %V, ptr %P) {
; CHECK-LABEL: @coerce_mustalias1(
; CHECK-NEXT:    store i32 [[V:%.*]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i32 [[V]] to float
; CHECK-NEXT:    ret float [[TMP1]]
;
  store i32 %V, ptr %P


  %A = load float, ptr %P
  ret float %A
}

;; ptr -> float forwarding.
define float @coerce_mustalias2(ptr %V, ptr %P) {
; CHECK-LABEL: @coerce_mustalias2(
; CHECK-NEXT:    store ptr [[V:%.*]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[V]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i32 [[TMP1]] to float
; CHECK-NEXT:    ret float [[TMP2]]
;
  store ptr %V, ptr %P


  %A = load float, ptr %P
  ret float %A
}

;; float -> ptr forwarding.
define ptr @coerce_mustalias3(float %V, ptr %P) {
; CHECK-LABEL: @coerce_mustalias3(
; CHECK-NEXT:    store float [[V:%.*]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast float [[V]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = inttoptr i32 [[TMP1]] to ptr
; CHECK-NEXT:    ret ptr [[TMP2]]
;
  store float %V, ptr %P


  %A = load ptr, ptr %P
  ret ptr %A
}

;; i32 -> f32 load forwarding.
define float @coerce_mustalias4(ptr %P, i1 %cond) {
; CHECK-LABEL: @coerce_mustalias4(
; CHECK-NEXT:    [[A:%.*]] = load i32, ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i32 [[A]] to float
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret float [[TMP1]]
; CHECK:       F:
; CHECK-NEXT:    ret float [[TMP1]]
;
  %A = load i32, ptr %P

  %B = load float, ptr %P
  br i1 %cond, label %T, label %F
T:
  ret float %B

F:
  %X = bitcast i32 %A to float
  ret float %X

}

;; i32 -> i8 forwarding
define i8 @coerce_mustalias5(i32 %V, ptr %P) {
; LE-LABEL: @coerce_mustalias5(
; LE-NEXT:    store i32 [[V:%.*]], ptr [[P:%.*]], align 4
; LE-NEXT:    [[TMP1:%.*]] = trunc i32 [[V]] to i8
; LE-NEXT:    ret i8 [[TMP1]]
;
; BE-LABEL: @coerce_mustalias5(
; BE-NEXT:    store i32 [[V:%.*]], ptr [[P:%.*]], align 4
; BE-NEXT:    [[TMP1:%.*]] = lshr i32 [[V]], 24
; BE-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i8
; BE-NEXT:    ret i8 [[TMP2]]
;
  store i32 %V, ptr %P


  %A = load i8, ptr %P
  ret i8 %A
}

;; i64 -> float forwarding
define float @coerce_mustalias6(i64 %V, ptr %P) {
; LE-LABEL: @coerce_mustalias6(
; LE-NEXT:    store i64 [[V:%.*]], ptr [[P:%.*]], align 4
; LE-NEXT:    [[TMP1:%.*]] = trunc i64 [[V]] to i32
; LE-NEXT:    [[TMP2:%.*]] = bitcast i32 [[TMP1]] to float
; LE-NEXT:    ret float [[TMP2]]
;
; BE-LABEL: @coerce_mustalias6(
; BE-NEXT:    store i64 [[V:%.*]], ptr [[P:%.*]], align 4
; BE-NEXT:    [[TMP1:%.*]] = lshr i64 [[V]], 32
; BE-NEXT:    [[TMP2:%.*]] = trunc i64 [[TMP1]] to i32
; BE-NEXT:    [[TMP3:%.*]] = bitcast i32 [[TMP2]] to float
; BE-NEXT:    ret float [[TMP3]]
;
  store i64 %V, ptr %P


  %A = load float, ptr %P
  ret float %A
}

;; i64 -> ptr (32-bit) forwarding
define ptr @coerce_mustalias7(i64 %V, ptr %P) {
; LE-LABEL: @coerce_mustalias7(
; LE-NEXT:    store i64 [[V:%.*]], ptr [[P:%.*]], align 4
; LE-NEXT:    [[TMP1:%.*]] = trunc i64 [[V]] to i32
; LE-NEXT:    [[TMP2:%.*]] = inttoptr i32 [[TMP1]] to ptr
; LE-NEXT:    ret ptr [[TMP2]]
;
; BE-LABEL: @coerce_mustalias7(
; BE-NEXT:    store i64 [[V:%.*]], ptr [[P:%.*]], align 4
; BE-NEXT:    [[TMP1:%.*]] = lshr i64 [[V]], 32
; BE-NEXT:    [[TMP2:%.*]] = trunc i64 [[TMP1]] to i32
; BE-NEXT:    [[TMP3:%.*]] = inttoptr i32 [[TMP2]] to ptr
; BE-NEXT:    ret ptr [[TMP3]]
;
  store i64 %V, ptr %P


  %A = load ptr, ptr %P
  ret ptr %A
}

; memset -> i16 forwarding.
define signext i16 @memset_to_i16_local(ptr %A) nounwind ssp {
; CHECK-LABEL: @memset_to_i16_local(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.memset.p0.i64(ptr [[A:%.*]], i8 1, i64 200, i1 false)
; CHECK-NEXT:    ret i16 257
;
entry:
  tail call void @llvm.memset.p0.i64(ptr %A, i8 1, i64 200, i1 false)
  %arrayidx = getelementptr inbounds i16, ptr %A, i64 42
  %ttmp2 = load i16, ptr %arrayidx
  ret i16 %ttmp2
}

; memset -> float forwarding.
define float @memset_to_float_local(ptr %A, i8 %Val) nounwind ssp {
; CHECK-LABEL: @memset_to_float_local(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.memset.p0.i64(ptr [[A:%.*]], i8 [[VAL:%.*]], i64 400, i1 false)
; CHECK-NEXT:    [[TMP0:%.*]] = zext i8 [[VAL]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[TMP0]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[TMP3:%.*]] = shl i32 [[TMP2]], 16
; CHECK-NEXT:    [[TMP4:%.*]] = or i32 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP4]] to float
; CHECK-NEXT:    ret float [[TMP5]]
;
entry:
  tail call void @llvm.memset.p0.i64(ptr %A, i8 %Val, i64 400, i1 false)
  %arrayidx = getelementptr inbounds float, ptr %A, i64 42 ; <ptr> [#uses=1]
  %ttmp2 = load float, ptr %arrayidx                   ; <float> [#uses=1]
  ret float %ttmp2
}

;; non-local memset -> i16 load forwarding.
define i16 @memset_to_i16_nonlocal0(ptr %P, i1 %cond) {
; CHECK-LABEL: @memset_to_i16_nonlocal0(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    tail call void @llvm.memset.p0.i64(ptr [[P:%.*]], i8 1, i64 400, i1 false)
; CHECK-NEXT:    br label [[CONT:%.*]]
; CHECK:       F:
; CHECK-NEXT:    tail call void @llvm.memset.p0.i64(ptr [[P]], i8 2, i64 400, i1 false)
; CHECK-NEXT:    br label [[CONT]]
; CHECK:       Cont:
; CHECK-NEXT:    [[A:%.*]] = phi i16 [ 514, [[F]] ], [ 257, [[T]] ]
; CHECK-NEXT:    ret i16 [[A]]
;
  br i1 %cond, label %T, label %F
T:
  tail call void @llvm.memset.p0.i64(ptr %P, i8 1, i64 400, i1 false)
  br label %Cont

F:
  tail call void @llvm.memset.p0.i64(ptr %P, i8 2, i64 400, i1 false)
  br label %Cont

Cont:
  %P2 = getelementptr i16, ptr %P, i32 4
  %A = load i16, ptr %P2
  ret i16 %A

}

@GCst = constant {i32, float, i32 } { i32 42, float 14., i32 97 }
@GCst_as1 = addrspace(1) constant {i32, float, i32 } { i32 42, float 14., i32 97 }

; memset -> float forwarding.
define float @memcpy_to_float_local(ptr %A) nounwind ssp {
; CHECK-LABEL: @memcpy_to_float_local(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr [[A:%.*]], ptr @GCst, i64 12, i1 false)
; CHECK-NEXT:    ret float 1.400000e+01
;
entry:
  tail call void @llvm.memcpy.p0.p0.i64(ptr %A, ptr @GCst, i64 12, i1 false)
  %arrayidx = getelementptr inbounds float, ptr %A, i64 1 ; <ptr> [#uses=1]
  %ttmp2 = load float, ptr %arrayidx                   ; <float> [#uses=1]
  ret float %ttmp2
}

; memcpy from address space 1
define float @memcpy_to_float_local_as1(ptr %A) nounwind ssp {
; CHECK-LABEL: @memcpy_to_float_local_as1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p1.i64(ptr [[A:%.*]], ptr addrspace(1) @GCst_as1, i64 12, i1 false)
; CHECK-NEXT:    ret float 1.400000e+01
;
entry:
  tail call void @llvm.memcpy.p0.p1.i64(ptr %A, ptr addrspace(1) @GCst_as1, i64 12, i1 false)
  %arrayidx = getelementptr inbounds float, ptr %A, i64 1 ; <ptr> [#uses=1]
  %ttmp2 = load float, ptr %arrayidx                   ; <float> [#uses=1]
  ret float %ttmp2
}

;; non-local i32/float -> i8 load forwarding.
define i8 @coerce_mustalias_nonlocal0(ptr %P, i1 %cond) {
; LE-LABEL: @coerce_mustalias_nonlocal0(
; LE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; LE:       T:
; LE-NEXT:    store i32 42, ptr [[P:%.*]], align 4
; LE-NEXT:    br label [[CONT:%.*]]
; LE:       F:
; LE-NEXT:    store float 1.000000e+00, ptr [[P]], align 4
; LE-NEXT:    br label [[CONT]]
; LE:       Cont:
; LE-NEXT:    [[A:%.*]] = phi i8 [ 0, [[F]] ], [ 42, [[T]] ]
; LE-NEXT:    ret i8 [[A]]
;
; BE-LABEL: @coerce_mustalias_nonlocal0(
; BE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; BE:       T:
; BE-NEXT:    store i32 42, ptr [[P:%.*]], align 4
; BE-NEXT:    br label [[CONT:%.*]]
; BE:       F:
; BE-NEXT:    store float 1.000000e+00, ptr [[P]], align 4
; BE-NEXT:    br label [[CONT]]
; BE:       Cont:
; BE-NEXT:    [[A:%.*]] = phi i8 [ 63, [[F]] ], [ 0, [[T]] ]
; BE-NEXT:    ret i8 [[A]]
;
  br i1 %cond, label %T, label %F
T:
  store i32 42, ptr %P
  br label %Cont

F:
  store float 1.0, ptr %P
  br label %Cont

Cont:
  %A = load i8, ptr %P
  ret i8 %A

}


;; non-local i32/float -> i8 load forwarding.  This also tests that the "P3"
;; bitcast equivalence can be properly phi translated.
define i8 @coerce_mustalias_nonlocal1(ptr %P, i1 %cond) {
; LE-LABEL: @coerce_mustalias_nonlocal1(
; LE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; LE:       T:
; LE-NEXT:    store i32 42, ptr [[P:%.*]], align 4
; LE-NEXT:    br label [[CONT:%.*]]
; LE:       F:
; LE-NEXT:    store float 1.000000e+00, ptr [[P]], align 4
; LE-NEXT:    br label [[CONT]]
; LE:       Cont:
; LE-NEXT:    [[A:%.*]] = phi i8 [ 0, [[F]] ], [ 42, [[T]] ]
; LE-NEXT:    ret i8 [[A]]
;
; BE-LABEL: @coerce_mustalias_nonlocal1(
; BE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; BE:       T:
; BE-NEXT:    store i32 42, ptr [[P:%.*]], align 4
; BE-NEXT:    br label [[CONT:%.*]]
; BE:       F:
; BE-NEXT:    store float 1.000000e+00, ptr [[P]], align 4
; BE-NEXT:    br label [[CONT]]
; BE:       Cont:
; BE-NEXT:    [[A:%.*]] = phi i8 [ 63, [[F]] ], [ 0, [[T]] ]
; BE-NEXT:    ret i8 [[A]]
;
  br i1 %cond, label %T, label %F
T:
  store i32 42, ptr %P
  br label %Cont

F:
  store float 1.0, ptr %P
  br label %Cont

Cont:
  %A = load i8, ptr %P
  ret i8 %A

}


;; non-local i32 -> i8 partial redundancy load forwarding.
define i8 @coerce_mustalias_pre0(ptr %P, i1 %cond) {
; LE-LABEL: @coerce_mustalias_pre0(
; LE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; LE:       T:
; LE-NEXT:    store i32 42, ptr [[P:%.*]], align 4
; LE-NEXT:    br label [[CONT:%.*]]
; LE:       F:
; LE-NEXT:    [[A_PRE:%.*]] = load i8, ptr [[P]], align 1
; LE-NEXT:    br label [[CONT]]
; LE:       Cont:
; LE-NEXT:    [[A:%.*]] = phi i8 [ [[A_PRE]], [[F]] ], [ 42, [[T]] ]
; LE-NEXT:    ret i8 [[A]]
;
; BE-LABEL: @coerce_mustalias_pre0(
; BE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; BE:       T:
; BE-NEXT:    store i32 42, ptr [[P:%.*]], align 4
; BE-NEXT:    br label [[CONT:%.*]]
; BE:       F:
; BE-NEXT:    [[A_PRE:%.*]] = load i8, ptr [[P]], align 1
; BE-NEXT:    br label [[CONT]]
; BE:       Cont:
; BE-NEXT:    [[A:%.*]] = phi i8 [ [[A_PRE]], [[F]] ], [ 0, [[T]] ]
; BE-NEXT:    ret i8 [[A]]
;
  br i1 %cond, label %T, label %F
T:
  store i32 42, ptr %P
  br label %Cont

F:
  br label %Cont

Cont:
  %A = load i8, ptr %P
  ret i8 %A

}

;;===----------------------------------------------------------------------===;;
;; Store -> Load  and  Load -> Load forwarding where src and dst are different
;; types, and the reload is an offset from the store pointer.
;;===----------------------------------------------------------------------===;;

;; i32 -> i8 forwarding.
;; PR4216
define i8 @coerce_offset0(i32 %V, ptr %P) {
; LE-LABEL: @coerce_offset0(
; LE-NEXT:    store i32 [[V:%.*]], ptr [[P:%.*]], align 4
; LE-NEXT:    [[TMP1:%.*]] = lshr i32 [[V]], 16
; LE-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i8
; LE-NEXT:    ret i8 [[TMP2]]
;
; BE-LABEL: @coerce_offset0(
; BE-NEXT:    store i32 [[V:%.*]], ptr [[P:%.*]], align 4
; BE-NEXT:    [[TMP1:%.*]] = lshr i32 [[V]], 8
; BE-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i8
; BE-NEXT:    ret i8 [[TMP2]]
;
  store i32 %V, ptr %P

  %P3 = getelementptr i8, ptr %P, i32 2

  %A = load i8, ptr %P3
  ret i8 %A
}

;; non-local i32/float -> i8 load forwarding.
define i8 @coerce_offset_nonlocal0(ptr %P, i1 %cond) {
; LE-LABEL: @coerce_offset_nonlocal0(
; LE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; LE:       T:
; LE-NEXT:    store i32 57005, ptr [[P:%.*]], align 4
; LE-NEXT:    br label [[CONT:%.*]]
; LE:       F:
; LE-NEXT:    store float 1.000000e+00, ptr [[P]], align 4
; LE-NEXT:    br label [[CONT]]
; LE:       Cont:
; LE-NEXT:    [[A:%.*]] = phi i8 [ -128, [[F]] ], [ 0, [[T]] ]
; LE-NEXT:    ret i8 [[A]]
;
; BE-LABEL: @coerce_offset_nonlocal0(
; BE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; BE:       T:
; BE-NEXT:    store i32 57005, ptr [[P:%.*]], align 4
; BE-NEXT:    br label [[CONT:%.*]]
; BE:       F:
; BE-NEXT:    store float 1.000000e+00, ptr [[P]], align 4
; BE-NEXT:    br label [[CONT]]
; BE:       Cont:
; BE-NEXT:    [[A:%.*]] = phi i8 [ 0, [[F]] ], [ -34, [[T]] ]
; BE-NEXT:    ret i8 [[A]]
;
  %P4 = getelementptr i8, ptr %P, i32 2
  br i1 %cond, label %T, label %F
T:
  store i32 57005, ptr %P
  br label %Cont

F:
  store float 1.0, ptr %P
  br label %Cont

Cont:
  %A = load i8, ptr %P4
  ret i8 %A

}


;; non-local i32 -> i8 partial redundancy load forwarding.
define i8 @coerce_offset_pre0(ptr %P, i1 %cond) {
; CHECK-LABEL: @coerce_offset_pre0(
; CHECK-NEXT:    [[P4:%.*]] = getelementptr i8, ptr [[P:%.*]], i32 2
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    store i32 42, ptr [[P]], align 4
; CHECK-NEXT:    br label [[CONT:%.*]]
; CHECK:       F:
; CHECK-NEXT:    [[A_PRE:%.*]] = load i8, ptr [[P4]], align 1
; CHECK-NEXT:    br label [[CONT]]
; CHECK:       Cont:
; CHECK-NEXT:    [[A:%.*]] = phi i8 [ [[A_PRE]], [[F]] ], [ 0, [[T]] ]
; CHECK-NEXT:    ret i8 [[A]]
;
  %P4 = getelementptr i8, ptr %P, i32 2
  br i1 %cond, label %T, label %F
T:
  store i32 42, ptr %P
  br label %Cont

F:
  br label %Cont

Cont:
  %A = load i8, ptr %P4
  ret i8 %A

}

define i32 @chained_load(ptr %p, i32 %x, i32 %y) {
; CHECK-LABEL: @chained_load(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[A:%.*]] = alloca ptr, align 4
; CHECK-NEXT:    [[Z:%.*]] = load ptr, ptr [[P:%.*]], align 4
; CHECK-NEXT:    store ptr [[Z]], ptr [[A]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[BLOCK2:%.*]], label [[BLOCK3:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    br label [[BLOCK4:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    br label [[BLOCK4]]
; CHECK:       block4:
; CHECK-NEXT:    [[D:%.*]] = load i32, ptr [[Z]], align 4
; CHECK-NEXT:    ret i32 [[D]]
;
block1:
  %A = alloca ptr

  %z = load ptr, ptr %p
  store ptr %z, ptr %A
  %cmp = icmp eq i32 %x, %y
  br i1 %cmp, label %block2, label %block3

block2:
  %a = load ptr, ptr %p
  br label %block4

block3:
  %b = load ptr, ptr %p
  br label %block4

block4:
  %c = load ptr, ptr %p
  %d = load i32, ptr %c
  ret i32 %d

}


declare i1 @cond() readonly
declare i1 @cond2() readonly

define i32 @phi_trans2() {
; CHECK-LABEL: @phi_trans2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[P:%.*]] = alloca i32, i32 400, align 4
; CHECK-NEXT:    br label [[F1:%.*]]
; CHECK:       F1:
; CHECK-NEXT:    [[A:%.*]] = phi i32 [ 1, [[ENTRY:%.*]] ], [ 2, [[F:%.*]] ]
; CHECK-NEXT:    [[COND2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[COND2]], label [[T1:%.*]], label [[TY:%.*]]
; CHECK:       T1:
; CHECK-NEXT:    [[P2:%.*]] = getelementptr i32, ptr [[P]], i32 [[A]]
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[P2]], align 4
; CHECK-NEXT:    [[COND:%.*]] = call i1 @cond2()
; CHECK-NEXT:    br i1 [[COND]], label [[TX:%.*]], label [[F]]
; CHECK:       F:
; CHECK-NEXT:    [[P3:%.*]] = getelementptr i32, ptr [[P]], i32 2
; CHECK-NEXT:    store i32 17, ptr [[P3]], align 4
; CHECK-NEXT:    store i32 42, ptr [[P2]], align 4
; CHECK-NEXT:    br label [[F1]]
; CHECK:       TX:
; CHECK-NEXT:    ret i32 [[X]]
; CHECK:       TY:
; CHECK-NEXT:    ret i32 0
;
entry:
  %P = alloca i32, i32 400
  br label %F1

F1:
  %A = phi i32 [1, %entry], [2, %F]
  %cond2 = call i1 @cond()
  br i1 %cond2, label %T1, label %TY

T1:
  %P2 = getelementptr i32, ptr %P, i32 %A
  %x = load i32, ptr %P2
  %cond = call i1 @cond2()
  br i1 %cond, label %TX, label %F

F:
  %P3 = getelementptr i32, ptr %P, i32 2
  store i32 17, ptr %P3

  store i32 42, ptr %P2  ; Provides "P[A]".
  br label %F1

TX:
  ; This load should not be compiled to 'ret i32 42'.  An overly clever
  ; implementation of GVN would see that we're returning 17 if the loop
  ; executes once or 42 if it executes more than that, but we'd have to do
  ; loop restructuring to expose this, and GVN shouldn't do this sort of CFG
  ; transformation.

  ret i32 %x
TY:
  ret i32 0
}

define i32 @phi_trans3(ptr %p, i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @phi_trans3(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[CMPXY:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMPXY]], label [[BLOCK2:%.*]], label [[BLOCK3:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    store i32 87, ptr [[P:%.*]], align 4
; CHECK-NEXT:    br label [[BLOCK4:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    [[P2:%.*]] = getelementptr i32, ptr [[P]], i32 43
; CHECK-NEXT:    store i32 97, ptr [[P2]], align 4
; CHECK-NEXT:    br label [[BLOCK4]]
; CHECK:       block4:
; CHECK-NEXT:    [[D:%.*]] = phi i32 [ 87, [[BLOCK2]] ], [ 97, [[BLOCK3]] ]
; CHECK-NEXT:    br i1 [[CMPXY]], label [[BLOCK5:%.*]], label [[EXIT:%.*]]
; CHECK:       block5:
; CHECK-NEXT:    br i1 true, label [[BLOCK6:%.*]], label [[BLOCK5_EXIT_CRIT_EDGE:%.*]]
; CHECK:       block5.exit_crit_edge:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       block6:
; CHECK-NEXT:    br i1 true, label [[BLOCK7:%.*]], label [[BLOCK6_EXIT_CRIT_EDGE:%.*]]
; CHECK:       block6.exit_crit_edge:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       block7:
; CHECK-NEXT:    ret i32 [[D]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 -1
;
block1:
  %cmpxy = icmp eq i32 %x, %y
  br i1 %cmpxy, label %block2, label %block3

block2:
  store i32 87, ptr %p
  br label %block4

block3:
  %p2 = getelementptr i32, ptr %p, i32 43
  store i32 97, ptr %p2
  br label %block4

block4:
  %A = phi i32 [-1, %block2], [42, %block3]
  br i1 %cmpxy, label %block5, label %exit


block5:
  %B = add i32 %A, 1
  br i1 %cmpxy, label %block6, label %exit

block6:
  %C = getelementptr i32, ptr %p, i32 %B
  br i1 %cmpxy, label %block7, label %exit

block7:
  %D = load i32, ptr %C
  ret i32 %D


exit:
  ret i32 -1
}

define i8 @phi_trans4(ptr %p) {
; CHECK-LABEL: @phi_trans4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X3:%.*]] = getelementptr i8, ptr [[P:%.*]], i32 192
; CHECK-NEXT:    store i8 -64, ptr [[X3]], align 1
; CHECK-NEXT:    [[X:%.*]] = getelementptr i8, ptr [[P]], i32 4
; CHECK-NEXT:    [[Y:%.*]] = load i8, ptr [[X]], align 1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[Y2:%.*]] = phi i8 [ [[Y]], [[ENTRY:%.*]] ], [ 0, [[LOOP]] ]
; CHECK-NEXT:    [[COND:%.*]] = call i1 @cond2()
; CHECK-NEXT:    store i32 0, ptr [[X3]], align 4
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[OUT:%.*]]
; CHECK:       out:
; CHECK-NEXT:    [[R:%.*]] = add i8 [[Y]], [[Y2]]
; CHECK-NEXT:    ret i8 [[R]]
;
entry:
  %X3 = getelementptr i8, ptr %p, i32 192
  store i8 192, ptr %X3

  %X = getelementptr i8, ptr %p, i32 4
  %Y = load i8, ptr %X
  br label %loop

loop:
  %i = phi i32 [4, %entry], [192, %loop]
  %X2 = getelementptr i8, ptr %p, i32 %i
  %Y2 = load i8, ptr %X2


  %cond = call i1 @cond2()

  store i32 0, ptr %X3
  br i1 %cond, label %loop, label %out

out:
  %R = add i8 %Y, %Y2
  ret i8 %R
}

define i8 @phi_trans5(ptr %p) {
; CHECK-LABEL: @phi_trans5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X4:%.*]] = getelementptr i8, ptr [[P:%.*]], i32 2
; CHECK-NEXT:    store i8 19, ptr [[X4]], align 1
; CHECK-NEXT:    [[X:%.*]] = getelementptr i8, ptr [[P]], i32 4
; CHECK-NEXT:    [[Y:%.*]] = load i8, ptr [[X]], align 1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[Y2:%.*]] = phi i8 [ [[Y]], [[ENTRY:%.*]] ], [ [[Y2_PRE:%.*]], [[CONT:%.*]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ 4, [[ENTRY]] ], [ 3, [[CONT]] ]
; CHECK-NEXT:    [[X2:%.*]] = getelementptr i8, ptr [[P]], i32 [[I]]
; CHECK-NEXT:    [[COND:%.*]] = call i1 @cond2()
; CHECK-NEXT:    br i1 [[COND]], label [[CONT]], label [[OUT:%.*]]
; CHECK:       cont:
; CHECK-NEXT:    [[Z:%.*]] = getelementptr i8, ptr [[X2]], i32 -1
; CHECK-NEXT:    store i32 50462976, ptr [[Z]], align 4
; CHECK-NEXT:    [[X2_PHI_TRANS_INSERT:%.*]] = getelementptr i8, ptr [[P]], i32 3
; CHECK-NEXT:    [[Y2_PRE]] = load i8, ptr [[X2_PHI_TRANS_INSERT]], align 1
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       out:
; CHECK-NEXT:    [[R:%.*]] = add i8 [[Y]], [[Y2]]
; CHECK-NEXT:    ret i8 [[R]]
;
entry:

  %X4 = getelementptr i8, ptr %p, i32 2
  store i8 19, ptr %X4

  %X = getelementptr i8, ptr %p, i32 4
  %Y = load i8, ptr %X
  br label %loop

loop:
  %i = phi i32 [4, %entry], [3, %cont]
  %X2 = getelementptr i8, ptr %p, i32 %i
  %Y2 = load i8, ptr %X2  ; Ensure this load is not being incorrectly replaced.
  %cond = call i1 @cond2()
  br i1 %cond, label %cont, label %out

cont:
  %Z = getelementptr i8, ptr %X2, i32 -1
  store i32 50462976, ptr %Z  ;; (1 << 8) | (2 << 16) | (3 << 24)


  br label %loop

out:
  %R = add i8 %Y, %Y2
  ret i8 %R
}

declare void @use_i32(i32) readonly

; indirectbr currently prevents MergeBlockIntoPredecessor from merging latch
; into header. Make sure we translate the address for %l1 correctly where
; parts of the address computations are in different basic blocks.
define i32 @phi_trans6(ptr noalias nocapture readonly %x, i1 %cond) {
; CHECK-LABEL: @phi_trans6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L0:%.*]] = load i32, ptr [[X:%.*]], align 4
; CHECK-NEXT:    call void @use_i32(i32 [[L0]])
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[L1:%.*]] = phi i32 [ [[L0]], [[ENTRY:%.*]] ], [ [[L1_PRE:%.*]], [[LATCH_HEADER_CRIT_EDGE:%.*]] ]
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[IV_NEXT:%.*]], [[LATCH_HEADER_CRIT_EDGE]] ]
; CHECK-NEXT:    indirectbr ptr blockaddress(@phi_trans6, [[LATCH:%.*]]), [label %latch]
; CHECK:       latch:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[EXIT:%.*]], label [[LATCH_HEADER_CRIT_EDGE]]
; CHECK:       latch.header_crit_edge:
; CHECK-NEXT:    [[GEP_1_PHI_TRANS_INSERT_PHI_TRANS_INSERT:%.*]] = getelementptr i32, ptr [[X]], i32 [[IV_NEXT]]
; CHECK-NEXT:    [[L1_PRE]] = load i32, ptr [[GEP_1_PHI_TRANS_INSERT_PHI_TRANS_INSERT]], align 4
; CHECK-NEXT:    br label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l0 = load i32, ptr %x
  call void @use_i32(i32 %l0)
  br label %header

header:
  %iv = phi i32 [0, %entry], [ %iv.next, %latch]
  indirectbr ptr blockaddress(@phi_trans6, %latch), [label %latch]

latch:
  %gep.1 = getelementptr i32, ptr %x, i32 %iv
  %l1 = load i32, ptr %gep.1
  %iv.next = add i32 %iv, 1
  br i1 %cond, label %exit, label %header

exit:
  ret i32 %l1
}

; FIXME: Currently we fail to translate the PHI in this case.
define i32 @phi_trans7(ptr noalias nocapture readonly %x, i1 %cond) {
; CHECK-LABEL: @phi_trans7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L0:%.*]] = load i32, ptr [[X:%.*]], align 4
; CHECK-NEXT:    call void @use_i32(i32 [[L0]])
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 2, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LATCH_HEADER_CRIT_EDGE:%.*]] ]
; CHECK-NEXT:    [[OFFSET:%.*]] = add i32 [[IV]], -2
; CHECK-NEXT:    indirectbr ptr blockaddress(@phi_trans7, [[LATCH:%.*]]), [label %latch]
; CHECK:       latch:
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr i32, ptr [[X]], i32 [[OFFSET]]
; CHECK-NEXT:    [[L1:%.*]] = load i32, ptr [[GEP_1]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[EXIT:%.*]], label [[LATCH_HEADER_CRIT_EDGE]]
; CHECK:       latch.header_crit_edge:
; CHECK-NEXT:    br label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l0 = load i32, ptr %x
  call void @use_i32(i32 %l0)
  br label %header

header:
  %iv = phi i32 [2, %entry], [ %iv.next, %latch]
  %offset = add i32 %iv, -2
  indirectbr ptr blockaddress(@phi_trans7, %latch), [label %latch]

latch:
  %gep.1 = getelementptr i32, ptr %x, i32 %offset
  %l1 = load i32, ptr %gep.1
  %iv.next = add i32 %iv, 1
  br i1 %cond, label %exit, label %header

exit:
  ret i32 %l1
}

; FIXME: Currently we fail to translate the PHI in this case.
define i32 @phi_trans8(ptr noalias nocapture readonly %x, i1 %cond) {
; CHECK-LABEL: @phi_trans8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L0:%.*]] = load i32, ptr [[X:%.*]], align 4
; CHECK-NEXT:    call void @use_i32(i32 [[L0]])
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 2, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LATCH_HEADER_CRIT_EDGE:%.*]] ]
; CHECK-NEXT:    indirectbr ptr blockaddress(@phi_trans8, [[LATCH:%.*]]), [label %latch]
; CHECK:       latch:
; CHECK-NEXT:    [[OFFSET:%.*]] = add i32 [[IV]], -2
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr i32, ptr [[X]], i32 [[OFFSET]]
; CHECK-NEXT:    [[L1:%.*]] = load i32, ptr [[GEP_1]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[EXIT:%.*]], label [[LATCH_HEADER_CRIT_EDGE]]
; CHECK:       latch.header_crit_edge:
; CHECK-NEXT:    br label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l0 = load i32, ptr %x
  call void @use_i32(i32 %l0)
  br label %header

header:
  %iv = phi i32 [2, %entry], [ %iv.next, %latch]
  indirectbr ptr blockaddress(@phi_trans8, %latch), [label %latch]

latch:
  %offset = add i32 %iv, -2
  %gep.1 = getelementptr i32, ptr %x, i32 %offset
  %l1 = load i32, ptr %gep.1
  %iv.next = add i32 %iv, 1
  br i1 %cond, label %exit, label %header

exit:
  ret i32 %l1
}



; PR6642
define i32 @memset_to_load() nounwind readnone {
; CHECK-LABEL: @memset_to_load(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = alloca [256 x i32], align 4
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[X]], i8 0, i64 1024, i1 false)
; CHECK-NEXT:    ret i32 0
;
entry:
  %x = alloca [256 x i32], align 4                ; <ptr> [#uses=2]
  call void @llvm.memset.p0.i64(ptr align 4 %x, i8 0, i64 1024, i1 false)
  %arraydecay = getelementptr inbounds [256 x i32], ptr %x, i32 0, i32 0 ; <ptr>
  %ttmp1 = load i32, ptr %arraydecay                   ; <i32> [#uses=1]
  ret i32 %ttmp1
}


;;===----------------------------------------------------------------------===;;
;; Load -> Load forwarding in partial alias case.
;;===----------------------------------------------------------------------===;;

define i32 @load_load_partial_alias(ptr %P) nounwind ssp {
; LE-LABEL: @load_load_partial_alias(
; LE-NEXT:  entry:
; LE-NEXT:    [[TTMP2:%.*]] = load i32, ptr [[P:%.*]], align 4
; LE-NEXT:    [[TMP0:%.*]] = lshr i32 [[TTMP2]], 8
; LE-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i8
; LE-NEXT:    [[CONV:%.*]] = zext i8 [[TMP1]] to i32
; LE-NEXT:    [[ADD:%.*]] = add nsw i32 [[TTMP2]], [[CONV]]
; LE-NEXT:    ret i32 [[ADD]]
;
; BE-LABEL: @load_load_partial_alias(
; BE-NEXT:  entry:
; BE-NEXT:    [[TTMP2:%.*]] = load i32, ptr [[P:%.*]], align 4
; BE-NEXT:    [[TMP0:%.*]] = lshr i32 [[TTMP2]], 16
; BE-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i8
; BE-NEXT:    [[CONV:%.*]] = zext i8 [[TMP1]] to i32
; BE-NEXT:    [[ADD:%.*]] = add nsw i32 [[TTMP2]], [[CONV]]
; BE-NEXT:    ret i32 [[ADD]]
;
entry:
  %ttmp2 = load i32, ptr %P
  %add.ptr = getelementptr inbounds i8, ptr %P, i64 1
  %ttmp5 = load i8, ptr %add.ptr
  %conv = zext i8 %ttmp5 to i32
  %add = add nsw i32 %ttmp2, %conv
  ret i32 %add
}


; Cross block partial alias case.
define i32 @load_load_partial_alias_cross_block(ptr %P) nounwind ssp {
; LE-LABEL: @load_load_partial_alias_cross_block(
; LE-NEXT:  entry:
; LE-NEXT:    [[X1:%.*]] = load i32, ptr [[P:%.*]], align 4
; LE-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X1]], 127
; LE-NEXT:    [[TMP0:%.*]] = lshr i32 [[X1]], 8
; LE-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i8
; LE-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[IF_END:%.*]]
; LE:       land.lhs.true:
; LE-NEXT:    [[CONV6:%.*]] = zext i8 [[TMP1]] to i32
; LE-NEXT:    ret i32 [[CONV6]]
; LE:       if.end:
; LE-NEXT:    ret i32 52
;
; BE-LABEL: @load_load_partial_alias_cross_block(
; BE-NEXT:  entry:
; BE-NEXT:    [[X1:%.*]] = load i32, ptr [[P:%.*]], align 4
; BE-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X1]], 127
; BE-NEXT:    [[TMP0:%.*]] = lshr i32 [[X1]], 16
; BE-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i8
; BE-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[IF_END:%.*]]
; BE:       land.lhs.true:
; BE-NEXT:    [[CONV6:%.*]] = zext i8 [[TMP1]] to i32
; BE-NEXT:    ret i32 [[CONV6]]
; BE:       if.end:
; BE-NEXT:    ret i32 52
;
entry:
  %x1 = load i32, ptr %P, align 4
  %cmp = icmp eq i32 %x1, 127
  br i1 %cmp, label %land.lhs.true, label %if.end

land.lhs.true:                                    ; preds = %entry
  %arrayidx4 = getelementptr inbounds i8, ptr %P, i64 1
  %ttmp5 = load i8, ptr %arrayidx4, align 1
  %conv6 = zext i8 %ttmp5 to i32
  ret i32 %conv6

if.end:
  ret i32 52
}

define i32 @load_load_partial_alias_cross_block_phi_trans(ptr %P) nounwind {
; LE-LABEL: @load_load_partial_alias_cross_block_phi_trans(
; LE-NEXT:  entry:
; LE-NEXT:    [[X1:%.*]] = load i32, ptr [[P:%.*]], align 4
; LE-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X1]], 127
; LE-NEXT:    [[TMP0:%.*]] = lshr i32 [[X1]], 16
; LE-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i8
; LE-NEXT:    [[TMP2:%.*]] = lshr i32 [[X1]], 8
; LE-NEXT:    [[TMP3:%.*]] = trunc i32 [[TMP2]] to i8
; LE-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[ELSE:%.*]]
; LE:       if:
; LE-NEXT:    br label [[JOIN:%.*]]
; LE:       else:
; LE-NEXT:    br label [[JOIN]]
; LE:       join:
; LE-NEXT:    [[TTMP5:%.*]] = phi i8 [ [[TMP3]], [[IF]] ], [ [[TMP1]], [[ELSE]] ]
; LE-NEXT:    [[CONV6:%.*]] = zext i8 [[TTMP5]] to i32
; LE-NEXT:    ret i32 [[CONV6]]
; LE:       if.end:
; LE-NEXT:    ret i32 52
;
; BE-LABEL: @load_load_partial_alias_cross_block_phi_trans(
; BE-NEXT:  entry:
; BE-NEXT:    [[X1:%.*]] = load i32, ptr [[P:%.*]], align 4
; BE-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X1]], 127
; BE-NEXT:    [[TMP0:%.*]] = lshr i32 [[X1]], 8
; BE-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i8
; BE-NEXT:    [[TMP2:%.*]] = lshr i32 [[X1]], 16
; BE-NEXT:    [[TMP3:%.*]] = trunc i32 [[TMP2]] to i8
; BE-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[ELSE:%.*]]
; BE:       if:
; BE-NEXT:    br label [[JOIN:%.*]]
; BE:       else:
; BE-NEXT:    br label [[JOIN]]
; BE:       join:
; BE-NEXT:    [[TTMP5:%.*]] = phi i8 [ [[TMP3]], [[IF]] ], [ [[TMP1]], [[ELSE]] ]
; BE-NEXT:    [[CONV6:%.*]] = zext i8 [[TTMP5]] to i32
; BE-NEXT:    ret i32 [[CONV6]]
; BE:       if.end:
; BE-NEXT:    ret i32 52
;
entry:
  %x1 = load i32, ptr %P, align 4
  %cmp = icmp eq i32 %x1, 127
  br i1 %cmp, label %if, label %else

if:
  %arrayidx.if = getelementptr inbounds i8, ptr %P, i64 1
  br label %join

else:
  %arrayidx.else = getelementptr inbounds i8, ptr %P, i64 2
  br label %join

join:
  %idx = phi i64 [ 1, %if ], [ 2, %else ]
  %arrayidx4 = getelementptr inbounds i8, ptr %P, i64 %idx
  %ttmp5 = load i8, ptr %arrayidx4, align 1
  %conv6 = zext i8 %ttmp5 to i32
  ret i32 %conv6

if.end:
  ret i32 52
}

define void @load_load_partial_alias_loop(ptr %P) {
; LE-LABEL: @load_load_partial_alias_loop(
; LE-NEXT:  entry:
; LE-NEXT:    [[P_1:%.*]] = getelementptr i8, ptr [[P:%.*]], i64 1
; LE-NEXT:    [[V_1:%.*]] = load i8, ptr [[P_1]], align 1
; LE-NEXT:    call void @use.i8(i8 [[V_1]])
; LE-NEXT:    [[V_1_32:%.*]] = load i32, ptr [[P_1]], align 4
; LE-NEXT:    call void @use.i32(i32 [[V_1_32]])
; LE-NEXT:    [[TMP0:%.*]] = trunc i32 [[V_1_32]] to i8
; LE-NEXT:    br label [[LOOP:%.*]]
; LE:       loop:
; LE-NEXT:    [[V_I:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[V_I_PRE:%.*]], [[LOOP_LOOP_CRIT_EDGE:%.*]] ]
; LE-NEXT:    [[I:%.*]] = phi i64 [ 1, [[ENTRY]] ], [ [[I_INC:%.*]], [[LOOP_LOOP_CRIT_EDGE]] ]
; LE-NEXT:    [[P_I:%.*]] = getelementptr i8, ptr [[P]], i64 [[I]]
; LE-NEXT:    call void @use.i8(i8 [[V_I]])
; LE-NEXT:    [[V_I_32:%.*]] = load i32, ptr [[P_I]], align 4
; LE-NEXT:    call void @use.i32(i32 [[V_I_32]])
; LE-NEXT:    [[I_INC]] = add i64 [[I]], 1
; LE-NEXT:    [[CMP:%.*]] = icmp ne i64 [[I_INC]], 64
; LE-NEXT:    br i1 [[CMP]], label [[LOOP_LOOP_CRIT_EDGE]], label [[EXIT:%.*]]
; LE:       loop.loop_crit_edge:
; LE-NEXT:    [[P_I_PHI_TRANS_INSERT:%.*]] = getelementptr i8, ptr [[P]], i64 [[I_INC]]
; LE-NEXT:    [[V_I_PRE]] = load i8, ptr [[P_I_PHI_TRANS_INSERT]], align 1
; LE-NEXT:    br label [[LOOP]]
; LE:       exit:
; LE-NEXT:    ret void
;
; BE-LABEL: @load_load_partial_alias_loop(
; BE-NEXT:  entry:
; BE-NEXT:    [[P_1:%.*]] = getelementptr i8, ptr [[P:%.*]], i64 1
; BE-NEXT:    [[V_1:%.*]] = load i8, ptr [[P_1]], align 1
; BE-NEXT:    call void @use.i8(i8 [[V_1]])
; BE-NEXT:    [[V_1_32:%.*]] = load i32, ptr [[P_1]], align 4
; BE-NEXT:    call void @use.i32(i32 [[V_1_32]])
; BE-NEXT:    [[TMP0:%.*]] = lshr i32 [[V_1_32]], 24
; BE-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i8
; BE-NEXT:    br label [[LOOP:%.*]]
; BE:       loop:
; BE-NEXT:    [[V_I:%.*]] = phi i8 [ [[TMP1]], [[ENTRY:%.*]] ], [ [[V_I_PRE:%.*]], [[LOOP_LOOP_CRIT_EDGE:%.*]] ]
; BE-NEXT:    [[I:%.*]] = phi i64 [ 1, [[ENTRY]] ], [ [[I_INC:%.*]], [[LOOP_LOOP_CRIT_EDGE]] ]
; BE-NEXT:    [[P_I:%.*]] = getelementptr i8, ptr [[P]], i64 [[I]]
; BE-NEXT:    call void @use.i8(i8 [[V_I]])
; BE-NEXT:    [[V_I_32:%.*]] = load i32, ptr [[P_I]], align 4
; BE-NEXT:    call void @use.i32(i32 [[V_I_32]])
; BE-NEXT:    [[I_INC]] = add i64 [[I]], 1
; BE-NEXT:    [[CMP:%.*]] = icmp ne i64 [[I_INC]], 64
; BE-NEXT:    br i1 [[CMP]], label [[LOOP_LOOP_CRIT_EDGE]], label [[EXIT:%.*]]
; BE:       loop.loop_crit_edge:
; BE-NEXT:    [[P_I_PHI_TRANS_INSERT:%.*]] = getelementptr i8, ptr [[P]], i64 [[I_INC]]
; BE-NEXT:    [[V_I_PRE]] = load i8, ptr [[P_I_PHI_TRANS_INSERT]], align 1
; BE-NEXT:    br label [[LOOP]]
; BE:       exit:
; BE-NEXT:    ret void
;
entry:
  %P.1 = getelementptr i8, ptr %P, i64 1
  %v.1 = load i8, ptr %P.1
  call void @use.i8(i8 %v.1)
  %v.1.32 = load i32, ptr %P.1
  call void @use.i32(i32 %v.1.32)
  br label %loop

loop:
  %i = phi i64 [ 1, %entry ], [ %i.inc, %loop ]
  %P.i = getelementptr i8, ptr %P, i64 %i
  %v.i = load i8, ptr %P.i
  call void @use.i8(i8 %v.i)
  %v.i.32 = load i32, ptr %P.i
  call void @use.i32(i32 %v.i.32)
  %i.inc = add i64 %i, 1
  %cmp = icmp ne i64 %i.inc, 64
  br i1 %cmp, label %loop, label %exit

exit:
  ret void
}

declare void @use.i8(i8) readnone
declare void @use.i32(i32) readnone

@global = external local_unnamed_addr global i8, align 4

define void @load_load_partial_alias_atomic(ptr %arg) {
; LE-LABEL: @load_load_partial_alias_atomic(
; LE-NEXT:  bb:
; LE-NEXT:    [[TMP2_1:%.*]] = getelementptr inbounds i8, ptr [[ARG:%.*]], i64 1
; LE-NEXT:    [[TMP2_3:%.*]] = load i64, ptr [[TMP2_1]], align 4
; LE-NEXT:    [[TMP3_1:%.*]] = getelementptr inbounds i8, ptr [[ARG]], i64 2
; LE-NEXT:    [[TMP0:%.*]] = lshr i64 [[TMP2_3]], 8
; LE-NEXT:    [[TMP1:%.*]] = trunc i64 [[TMP0]] to i8
; LE-NEXT:    br label [[BB5:%.*]]
; LE:       bb5:
; LE-NEXT:    [[TMP4_1:%.*]] = phi i8 [ [[TMP4_1_PRE:%.*]], [[BB5]] ], [ [[TMP1]], [[BB:%.*]] ]
; LE-NEXT:    [[TMP6_1:%.*]] = load atomic i8, ptr @global acquire, align 4
; LE-NEXT:    [[TMP7_1:%.*]] = add i8 [[TMP6_1]], [[TMP4_1]]
; LE-NEXT:    store i8 [[TMP7_1]], ptr [[ARG]], align 1
; LE-NEXT:    [[TMP4_1_PRE]] = load i8, ptr [[TMP3_1]], align 4
; LE-NEXT:    br label [[BB5]]
;
; BE-LABEL: @load_load_partial_alias_atomic(
; BE-NEXT:  bb:
; BE-NEXT:    [[TMP2_1:%.*]] = getelementptr inbounds i8, ptr [[ARG:%.*]], i64 1
; BE-NEXT:    [[TMP2_3:%.*]] = load i64, ptr [[TMP2_1]], align 4
; BE-NEXT:    [[TMP3_1:%.*]] = getelementptr inbounds i8, ptr [[ARG]], i64 2
; BE-NEXT:    [[TMP0:%.*]] = lshr i64 [[TMP2_3]], 48
; BE-NEXT:    [[TMP1:%.*]] = trunc i64 [[TMP0]] to i8
; BE-NEXT:    br label [[BB5:%.*]]
; BE:       bb5:
; BE-NEXT:    [[TMP4_1:%.*]] = phi i8 [ [[TMP4_1_PRE:%.*]], [[BB5]] ], [ [[TMP1]], [[BB:%.*]] ]
; BE-NEXT:    [[TMP6_1:%.*]] = load atomic i8, ptr @global acquire, align 4
; BE-NEXT:    [[TMP7_1:%.*]] = add i8 [[TMP6_1]], [[TMP4_1]]
; BE-NEXT:    store i8 [[TMP7_1]], ptr [[ARG]], align 1
; BE-NEXT:    [[TMP4_1_PRE]] = load i8, ptr [[TMP3_1]], align 4
; BE-NEXT:    br label [[BB5]]
;
bb:
  %tmp2.1 = getelementptr inbounds i8, ptr %arg, i64 1
  %tmp2.3 = load i64, ptr %tmp2.1, align 4
  %tmp2.4 = icmp ugt i64 %tmp2.3, 1

  %tmp3.1 = getelementptr inbounds i8, ptr %arg, i64 2
  br label %bb5

bb5:                                              ; preds = %bb14, %bb
  %tmp4.1 = load i8, ptr %tmp3.1, align 4
  %tmp6.1 = load atomic i8, ptr @global acquire, align 4
  %tmp7.1 = add i8 %tmp6.1, %tmp4.1
  store i8 %tmp7.1, ptr %arg
  br label %bb5

}

;;===----------------------------------------------------------------------===;;
;; Load Widening
;; We explicitly choose NOT to widen. And are testing to make sure we don't.
;;===----------------------------------------------------------------------===;;

%widening1 = type { i32, i8, i8, i8, i8 }

@f = global %widening1 zeroinitializer, align 4

define i32 @test_widening1(ptr %P) nounwind ssp noredzone {
; CHECK-LABEL: @test_widening1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TTMP:%.*]] = load i8, ptr getelementptr inbounds ([[WIDENING1:%.*]], ptr @f, i64 0, i32 1), align 4
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TTMP]] to i32
; CHECK-NEXT:    [[TTMP1:%.*]] = load i8, ptr getelementptr inbounds ([[WIDENING1]], ptr @f, i64 0, i32 2), align 1
; CHECK-NEXT:    [[CONV2:%.*]] = zext i8 [[TTMP1]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV2]]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  %ttmp = load i8, ptr getelementptr inbounds (%widening1, ptr @f, i64 0, i32 1), align 4
  %conv = zext i8 %ttmp to i32
  %ttmp1 = load i8, ptr getelementptr inbounds (%widening1, ptr @f, i64 0, i32 2), align 1
  %conv2 = zext i8 %ttmp1 to i32
  %add = add nsw i32 %conv, %conv2
  ret i32 %add
}

define i32 @test_widening2() nounwind ssp noredzone {
; CHECK-LABEL: @test_widening2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TTMP:%.*]] = load i8, ptr getelementptr inbounds ([[WIDENING1:%.*]], ptr @f, i64 0, i32 1), align 4
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TTMP]] to i32
; CHECK-NEXT:    [[TTMP1:%.*]] = load i8, ptr getelementptr inbounds ([[WIDENING1]], ptr @f, i64 0, i32 2), align 1
; CHECK-NEXT:    [[CONV2:%.*]] = zext i8 [[TTMP1]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV2]]
; CHECK-NEXT:    [[TTMP2:%.*]] = load i8, ptr getelementptr inbounds ([[WIDENING1]], ptr @f, i64 0, i32 3), align 2
; CHECK-NEXT:    [[CONV3:%.*]] = zext i8 [[TTMP2]] to i32
; CHECK-NEXT:    [[ADD2:%.*]] = add nsw i32 [[ADD]], [[CONV3]]
; CHECK-NEXT:    [[TTMP3:%.*]] = load i8, ptr getelementptr inbounds ([[WIDENING1]], ptr @f, i64 0, i32 4), align 1
; CHECK-NEXT:    [[CONV4:%.*]] = zext i8 [[TTMP3]] to i32
; CHECK-NEXT:    [[ADD3:%.*]] = add nsw i32 [[ADD2]], [[CONV4]]
; CHECK-NEXT:    ret i32 [[ADD3]]
;
entry:
  %ttmp = load i8, ptr getelementptr inbounds (%widening1, ptr @f, i64 0, i32 1), align 4
  %conv = zext i8 %ttmp to i32
  %ttmp1 = load i8, ptr getelementptr inbounds (%widening1, ptr @f, i64 0, i32 2), align 1
  %conv2 = zext i8 %ttmp1 to i32
  %add = add nsw i32 %conv, %conv2

  %ttmp2 = load i8, ptr getelementptr inbounds (%widening1, ptr @f, i64 0, i32 3), align 2
  %conv3 = zext i8 %ttmp2 to i32
  %add2 = add nsw i32 %add, %conv3

  %ttmp3 = load i8, ptr getelementptr inbounds (%widening1, ptr @f, i64 0, i32 4), align 1
  %conv4 = zext i8 %ttmp3 to i32
  %add3 = add nsw i32 %add2, %conv4

  ret i32 %add3
}


declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i1) nounwind

declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1) nounwind
declare void @llvm.memcpy.p0.p1.i64(ptr nocapture, ptr addrspace(1) nocapture, i64, i1) nounwind


;;===----------------------------------------------------------------------===;;
;; Load -> Store dependency which isn't interfered with by a call that happens
;; before the pointer was captured.
;;===----------------------------------------------------------------------===;;

%class.X = type { [8 x i8] }

@_ZTV1X = weak_odr constant [5 x ptr] zeroinitializer
@_ZTV1Y = weak_odr constant [5 x ptr] zeroinitializer

declare void @use()
declare void @use3(ptr, ptr)

; PR8908
define void @test_escape1() nounwind {
; CHECK-LABEL: @test_escape1(
; CHECK-NEXT:    [[X:%.*]] = alloca ptr, align 8
; CHECK-NEXT:    store ptr getelementptr inbounds ([5 x ptr], ptr @_ZTV1X, i64 0, i64 2), ptr [[X]], align 8
; CHECK-NEXT:    call void @use() #[[ATTR3]]
; CHECK-NEXT:    call void @use3(ptr [[X]], ptr getelementptr inbounds ([5 x ptr], ptr @_ZTV1X, i64 0, i64 2)) #[[ATTR3]]
; CHECK-NEXT:    ret void
;
  %x = alloca ptr, align 8
  store ptr getelementptr inbounds ([5 x ptr], ptr @_ZTV1X, i64 0, i64 2), ptr %x, align 8
  call void @use() nounwind
  %DEAD = load ptr, ptr %x, align 8
  call void @use3(ptr %x, ptr %DEAD) nounwind
  ret void
}
