/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class ByteArrayParameter
extends NotLongDataParameterHolder {
    private byte[] bytes;
    private boolean noBackslashEscapes;

    public ByteArrayParameter(byte[] bytes, boolean noBackslashEscapes) {
        this.bytes = bytes;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        ParameterWriter.write(os, this.bytes, this.noBackslashEscapes);
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return this.bytes.length * 2;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        writeBuffer.writeByteArrayLength(this.bytes);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.VARSTRING;
    }

    @Override
    public String toString() {
        return "<bytearray> " + new String(this.bytes);
    }
}

